/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login.common;

import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ServerLoginCallbackHandler
implements CallbackHandler {
    private static final String GP_CB = "javax.security.auth.message.callback.GroupPrincipalCallback";
    private static final String GPCBH_UTIL = "com.sun.enterprise.security.jaspic.callback.ServerLoginCBHUtil";
    private static final String GPCBH_UTIL_METHOD = "processGroupPrincipal";
    private String username;
    private char[] password;
    private String moduleID;

    public ServerLoginCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public ServerLoginCallbackHandler(String username, char[] password, String moduleID) {
        this.username = username;
        this.password = password;
        this.moduleID = moduleID;
    }

    public ServerLoginCallbackHandler() {
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public void setPassword(char[] pass) {
        this.password = pass;
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nme = (NameCallback)callback;
                nme.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pswd = (PasswordCallback)callback;
                pswd.setPassword(this.password);
                continue;
            }
            if (callback instanceof CertificateRealm.AppContextCallback) {
                ((CertificateRealm.AppContextCallback)callback).setModuleID(this.moduleID);
                continue;
            }
            if (GP_CB.equals(callback.getClass().getName())) {
                ServerLoginCallbackHandler.processGroupPrincipal(callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private static void processGroupPrincipal(Callback callback) throws UnsupportedCallbackException {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(GPCBH_UTIL).getMethod(GPCBH_UTIL_METHOD, Callback.class).invoke(null, callback);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

