/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-password-alias")
@PerLookup
@I18n(value="create.password.alias")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="create-password-alias", description="create-password-alias")})
@AccessRequired(resource={"domain/passwordAliases"}, action={"create"})
public class CreatePasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreatePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    private String aliasName;
    @Param(name="aliaspassword", password=true)
    private String aliasPassword;
    @Inject
    private DomainScopedPasswordAliasStore domainPasswordAliasStore;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.domainPasswordAliasStore.containsKey(this.aliasName)) {
                report.setMessage(localStrings.getLocalString("create.password.alias.alreadyexists", "Password alias with the specified name already exists. Please use the update-password-alias command to change it", new Object[]{this.aliasName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.domainPasswordAliasStore.put(this.aliasName, this.aliasPassword.toCharArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.password.alias.fail", "Creation of Password Alias {0} failed", new Object[]{this.aliasName}) + "  " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

