/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.appserv.util.cache.LruCache;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBHomeInvocationHandler;
import com.sun.ejb.containers.EJBLocalHomeInvocationHandler;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.ejb.monitoring.stats.EjbCacheStatsProvider;
import com.sun.ejb.monitoring.stats.EjbCacheStatsProviderDelegate;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import com.sun.ejb.monitoring.stats.EjbPoolStatsProvider;
import com.sun.ejb.portable.EJBMetaDataImpl;
import com.sun.ejb.portable.ObjrefEnumeration;
import com.sun.ejb.spi.container.BeanStateSynchronization;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.BeanCacheDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.persistence.ejb.entitybean.container.ActiveTxCache;
import org.glassfish.persistence.ejb.entitybean.container.EntityBeanHomeImpl;
import org.glassfish.persistence.ejb.entitybean.container.EntityBeanLocalHomeImpl;
import org.glassfish.persistence.ejb.entitybean.container.EntityContextImpl;
import org.glassfish.persistence.ejb.entitybean.container.cache.EJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.cache.EJBObjectCacheListener;
import org.glassfish.persistence.ejb.entitybean.container.cache.FIFOEJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.cache.UnboundedEJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.spi.ReadOnlyEJBHome;
import org.glassfish.persistence.ejb.entitybean.container.spi.ReadOnlyEJBLocalHome;
import org.glassfish.persistence.ejb.entitybean.container.stats.EntityBeanStatsProvider;

public class EntityContainer
extends BaseContainer
implements CacheListener {
    private final ThreadLocal ejbServant = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };
    static final Logger _logger = LogDomains.getLogger(EntityContainer.class, (String)"javax.enterprise.system.container.ejb");
    static final int POOLED = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    protected static final int HIGH_WATER_MARK = 100;
    private static final int DEFAULT_TX_CACHE_BUCKETS = 16;
    protected EJBObjectCache ejbObjectStore;
    protected EJBObjectCache ejbLocalObjectStore;
    protected Stack passivationCandidates = new Stack();
    protected Cache readyStore;
    protected AbstractPool entityCtxPool;
    protected boolean isReentrant;
    protected boolean isContainerManagedPers;
    protected final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final int DEFAULT_CACHE_SIZE = 8192;
    protected int _maxBuckets = 8;
    protected IASEjbExtraDescriptors iased = null;
    protected BeanCacheDescriptor beanCacheDes = null;
    protected BeanPoolDescriptor beanPoolDes = null;
    protected EjbContainer ejbContainer;
    boolean largeCache = false;
    CacheProperties cacheProp = null;
    PoolProperties poolProp = null;
    Object asyncTaskSemaphore = new Object();
    boolean addedASyncTask = false;
    protected IdleBeansPassivator idleEJBObjectPassivator;
    protected IdleBeansPassivator idleLocalEJBObjectPassivator;
    protected boolean defaultCacheEJBO = true;
    IdleBeansPassivator idleBeansPassivator;
    boolean timerValid = true;
    long idleTimeout;
    protected int ejboRemoved;
    protected int totalPassivations;
    protected int totalPassivationErrors;
    private EntityCacheStatsProvider cacheStatsProvider;

    protected EntityContainer(org.glassfish.ejb.deployment.descriptor.EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        this(BaseContainer.ContainerType.ENTITY, desc, loader, sm);
    }

    protected EntityContainer(BaseContainer.ContainerType containerType, org.glassfish.ejb.deployment.descriptor.EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        super(containerType, desc, loader, sm);
        EjbEntityDescriptor ed = (EjbEntityDescriptor)desc;
        this.isReentrant = ed.isReentrant();
        this.isContainerManagedPers = !ed.getPersistenceType().equals("Bean");
        this.isBeanManagedTran = false;
        this.iased = ed.getIASEjbExtraDescriptors();
        if (this.iased != null) {
            this.beanCacheDes = this.iased.getBeanCache();
            this.beanPoolDes = this.iased.getBeanPool();
        }
        this.ejbContainer = this.ejbContainerUtilImpl.getEjbContainer();
        this.createCaches();
        super.createCallFlowAgent(this.isContainerManagedPers ? ComponentType.CMP : ComponentType.BMP);
        _logger.log(Level.FINE, "[EntityContainer] Created EntityContainer: " + this.logParams[0]);
    }

    protected void preInitialize(org.glassfish.ejb.deployment.descriptor.EjbDescriptor desc, ClassLoader loader) {
        EjbEntityDescriptor ed = (EjbEntityDescriptor)desc;
        this.isReentrant = ed.isReentrant();
        this.isContainerManagedPers = !ed.getPersistenceType().equals("Bean");
        _logger.log(Level.FINE, "[EntityContainer] preInitialize==>isContainerManagedPers: " + this.isContainerManagedPers);
    }

    protected void setEJBMetaData() throws Exception {
        EjbEntityDescriptor ed = (EjbEntityDescriptor)this.ejbDescriptor;
        Class<?> primaryKeyClass = this.loader.loadClass(ed.getPrimaryKeyClassName());
        this.metadata = new EJBMetaDataImpl(this.ejbHomeStub, this.homeIntf, this.remoteIntf, primaryKeyClass);
    }

    protected void validateTxAttr(MethodDescriptor md, int txAttr) throws EJBException {
        EjbCMPEntityDescriptor e;
        super.validateTxAttr(md, txAttr);
        if (((EjbEntityDescriptor)this.ejbDescriptor).getPersistenceType().equals("Container") && !(e = (EjbCMPEntityDescriptor)this.ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean() && e.isEJB20() && txAttr != 3 && txAttr != 5 && txAttr != 6) {
            throw new EJBException("Transaction attribute for EJB2.0 CMP EntityBeans must be Required/RequiresNew/Mandatory");
        }
    }

    protected void adjustHomeTargetMethodInfo(InvocationInfo invInfo, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        if (invInfo.startsWithCreate) {
            String extraCreateChars = methodName.substring("create".length());
            invInfo.targetMethod2 = this.ejbClass.getMethod("ejbPostCreate" + extraCreateChars, paramTypes);
        }
    }

    protected EJBHomeInvocationHandler getEJBHomeInvocationHandler(Class homeIntfClass) throws Exception {
        return new EntityBeanHomeImpl((EjbDescriptor)this.ejbDescriptor, homeIntfClass);
    }

    protected EJBLocalHomeInvocationHandler getEJBLocalHomeInvocationHandler(Class homeIntfClass) throws Exception {
        return new EntityBeanLocalHomeImpl((EjbDescriptor)this.ejbDescriptor, homeIntfClass);
    }

    public IdleBeansPassivator setupIdleBeansPassivator(Cache cache) throws Exception {
        IdleBeansPassivator idleBeansPassivator = new IdleBeansPassivator(cache);
        this.ejbContainerUtilImpl.getTimer().scheduleAtFixedRate((TimerTask)idleBeansPassivator, this.idleTimeout, this.idleTimeout);
        return idleBeansPassivator;
    }

    public void cancelTimerTasks() {
        this.timerValid = false;
        if (this.idleBeansPassivator != null) {
            try {
                this.idleBeansPassivator.cancel();
                this.idleBeansPassivator.cache = null;
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "[EntityContainer] cancelTimerTask: " + e);
            }
        }
        if (this.idleEJBObjectPassivator != null) {
            try {
                this.idleEJBObjectPassivator.cancel();
                this.idleEJBObjectPassivator.cache = null;
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "[EntityContainer] cancelTimerTask: " + e);
            }
        }
        if (this.idleLocalEJBObjectPassivator != null) {
            try {
                this.idleLocalEJBObjectPassivator.cancel();
                this.idleLocalEJBObjectPassivator.cache = null;
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "[EntityContainer] cancelTimerTask: " + e);
            }
        }
        this.idleEJBObjectPassivator = null;
        this.idleLocalEJBObjectPassivator = null;
        this.idleBeansPassivator = null;
    }

    protected InvocationInfo postProcessInvocationInfo(InvocationInfo invInfo) {
        boolean isCMPField;
        Method method = invInfo.method;
        boolean bl = isCMPField = this.isContainerManagedPers && invInfo.isBusinessMethod && invInfo.methodIntf.equals("Local");
        if (isCMPField) {
            String methodName = method.getName();
            boolean bl2 = isCMPField = methodName.startsWith("get") || methodName.startsWith("set");
            if (isCMPField) {
                try {
                    Method methodInBeanClass = this.ejbClass.getSuperclass().getMethod(methodName, method.getParameterTypes());
                    isCMPField = Modifier.isAbstract(methodInBeanClass.getModifiers());
                }
                catch (NoSuchMethodException ignore) {
                    isCMPField = false;
                }
            }
        }
        invInfo.isTxRequiredLocalCMPField = isCMPField && invInfo.txAttr == 3;
        return invInfo;
    }

    protected void initializeHome() throws Exception {
        EntityContextFactory entityCtxFactory = new EntityContextFactory(this);
        boolean steadyPoolSize = false;
        int resizeQuantity = 10;
        int idleTimeoutInSeconds = 0x7FFFFFFE;
        this.poolProp = new PoolProperties(this);
        super.initializeHome();
        this.entityCtxPool = new NonBlockingPool(this.getContainerId(), this.ejbDescriptor.getName(), (ObjectFactory)entityCtxFactory, this.poolProp.steadyPoolSize, this.poolProp.poolResizeQuantity, this.poolProp.maxPoolSize, this.poolProp.poolIdleTimeoutInSeconds, this.loader);
        this.registerMonitorableComponents();
    }

    protected void registerMonitorableComponents() {
        super.registerMonitorableComponents();
        if (this.readyStore != null) {
            int confMaxCacheSize = this.cacheProp.maxCacheSize;
            if (confMaxCacheSize <= 0) {
                confMaxCacheSize = Integer.MAX_VALUE;
            }
            this.cacheStatsProvider = new EntityCacheStatsProvider((BaseCache)this.readyStore, confMaxCacheSize);
            this.cacheProbeListener = new EjbCacheStatsProvider((EjbCacheStatsProviderDelegate)this.cacheStatsProvider, this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
            this.cacheProbeListener.register();
        }
        this.poolProbeListener = new EjbPoolStatsProvider(this.entityCtxPool, this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
        this.poolProbeListener.register();
        _logger.log(Level.FINE, "[Entity Container] registered monitorable");
    }

    protected EjbMonitoringStatsProvider getMonitoringStatsProvider(String appName, String modName, String ejbName) {
        return new EntityBeanStatsProvider(this, this.getContainerId(), appName, modName, ejbName);
    }

    public void onReady() {
    }

    public int getMaxCacheSize() {
        int maxSize = 0;
        if (this.readyStore != null) {
            maxSize = this.cacheProp.maxCacheSize <= 0 ? Integer.MAX_VALUE : this.cacheProp.maxCacheSize;
        }
        return maxSize;
    }

    public int getSteadyPoolSize() {
        return this.entityCtxPool.getSteadyPoolSize();
    }

    public int getMaxPoolSize() {
        return this.entityCtxPool.getMaxPoolSize();
    }

    public long getPooledCount() {
        return this.entityCtxPool.getSize();
    }

    public long getReadyCount() {
        return this.readyStore == null ? 0L : (long)this.readyStore.getEntryCount();
    }

    protected EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        throw new EJBException("INTERNAL ERROR: EntityContainer.createEJBObject() called");
    }

    protected EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        throw new EJBException("INTERNAL ERROR: EntityContainer.createEJBLocalObjectImpl() called");
    }

    protected EJBObjectImpl getEJBObjectImpl(byte[] streamKey) {
        Object primaryKey;
        try {
            primaryKey = EJBUtils.deserializeObject((byte[])streamKey, (ClassLoader)this.loader, (boolean)false, (long)this.getApplicationId());
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        return this.internalGetEJBObjectImpl(primaryKey, streamKey);
    }

    protected EJBLocalObjectImpl getEJBLocalObjectImpl(Object key) {
        return this.internalGetEJBLocalObjectImpl(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentContext _getContext(EjbInvocation inv) {
        if (inv.invocationInfo.isCreateHomeFinder) {
            EntityContextImpl context = this.getPooledEJB();
            context.setState(EJBContextImpl.BeanState.INVOKING);
            if (inv.invocationInfo.startsWithCreate) {
                this.preCreate(inv, context);
            } else if (inv.invocationInfo.startsWithFind) {
                this.preFind(inv, context);
            }
            context.setLastTransactionStatus(-1);
            context.incrementCalls();
            return context;
        }
        EntityContextImpl context = null;
        if (this.willInvokeWithClientTx(inv)) {
            context = this.getEJBWithIncompleteTx(inv);
        }
        if (context == null) {
            context = this.getReadyEJB(inv);
        }
        EntityContextImpl entityContextImpl = context;
        synchronized (entityContextImpl) {
            if (context.isInState(EJBContextImpl.BeanState.INVOKING) && !this.isReentrant) {
                throw new EJBException("EJB is already executing another request");
            }
            if (context.isInState(EJBContextImpl.BeanState.POOLED) || context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
                throw new EJBException("Internal error: unknown EJB state");
            }
            context.setState(EJBContextImpl.BeanState.INVOKING);
        }
        context.setLastTransactionStatus(-1);
        context.incrementCalls();
        context.setDirty(true);
        return context;
    }

    protected boolean willInvokeWithClientTx(EjbInvocation inv) {
        int status = 5;
        try {
            Integer preInvokeTxStatus = inv.getPreInvokeTxStatus();
            status = preInvokeTxStatus != null ? preInvokeTxStatus.intValue() : this.transactionManager.getStatus();
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        if (status != 6) {
            int txAttr = inv.invocationInfo.txAttr;
            switch (txAttr) {
                case 3: 
                case 4: 
                case 6: {
                    return true;
                }
            }
        }
        return false;
    }

    public void releaseContext(EjbInvocation inv) {
        EntityContextImpl context = (EntityContextImpl)inv.context;
        boolean decrementedCalls = false;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        try {
            if (context.hasReentrantCall()) {
                if (this.containerStateManager.isRemovedEJBObject(inv)) {
                    this.removeIncompleteTxEJB(context, true);
                    this.containerStateManager.disconnectContext((EJBContextImpl)context);
                } else if (context.isInState(EJBContextImpl.BeanState.INVOKING)) {
                    this.doFlush(inv);
                }
            } else if (this.containerStateManager.isNullEJBObject((EJBContextImpl)context) && this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
                decrementedCalls = true;
                context.decrementCalls();
                if (!inv.invocationInfo.startsWithCreate) {
                    context.setTransaction(null);
                    this.addPooledEJB(context);
                } else if (context.getTransaction() == null) {
                    this.addPooledEJB(context);
                } else {
                    context.setState(EJBContextImpl.BeanState.INCOMPLETE_TX);
                }
            } else if (this.containerStateManager.isRemovedEJBObject(inv)) {
                this.removeIncompleteTxEJB(context, true);
                this.containerStateManager.markObjectRemoved((EJBContextImpl)context, false);
                decrementedCalls = true;
                context.decrementCalls();
                if (context.getTransaction() == null) {
                    this.addPooledEJB(context);
                } else {
                    context.setState(EJBContextImpl.BeanState.INCOMPLETE_TX);
                }
            } else if (context.getTransaction() == null) {
                int status = context.getLastTransactionStatus();
                decrementedCalls = true;
                context.decrementCalls();
                context.setLastTransactionStatus(-1);
                if (status == -1 || status == 3 || status == 6) {
                    this.addReadyEJB(context);
                } else {
                    this.passivateAndPoolEJB(context);
                }
            } else {
                context.setState(EJBContextImpl.BeanState.INCOMPLETE_TX);
                this.doFlush(inv);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "entitybean.container.release_context_exception", this.logParams);
            _logger.log(Level.FINE, "", ex);
            throw new EJBException(ex);
        }
        finally {
            if (!decrementedCalls) {
                context.decrementCalls();
            }
            context.touch();
        }
    }

    protected void preCreate(EjbInvocation inv, EntityContextImpl context) {
        this.ejbProbeNotifier.ejbBeanCreatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
    }

    public void postCreate(EjbInvocation inv, Object primaryKey) throws CreateException {
        EntityContextImpl context;
        if (primaryKey == null) {
            throw new EJBException("Null primary key returned by ejbCreate method");
        }
        if (this.isRemote && !inv.isLocal) {
            EJBObjectImpl ejbObjImpl = this.internalGetEJBObjectImpl(primaryKey, null, true);
            this.containerStateManager.attachObject(inv, (EJBContextImpl)inv.context, ejbObjImpl, null);
        }
        if (this.isLocal) {
            EJBLocalObjectImpl localObjImpl = this.internalGetEJBLocalObjectImpl(primaryKey, true);
            this.containerStateManager.attachObject(inv, (EJBContextImpl)inv.context, null, localObjImpl);
        }
        if ((context = (EntityContextImpl)inv.context).getTransaction() != null) {
            this.addIncompleteTxEJB(context);
        }
        context.setDirty(true);
    }

    protected Object invokeFindByPrimaryKey(Method method, EjbInvocation inv, Object[] args) throws Throwable {
        Object pKeys = super.invokeTargetBeanMethod(method, inv, inv.ejb, args, null);
        return this.postFind(inv, pKeys, null);
    }

    protected void authorizeLocalGetPrimaryKey(EJBLocalRemoteObject ejbObj) throws EJBException {
        this.authorizeLocalMethod(11);
        this.checkExists(ejbObj);
    }

    protected void authorizeRemoteGetPrimaryKey(EJBLocalRemoteObject ejbObj) throws RemoteException {
        this.authorizeRemoteMethod(6);
    }

    protected void preFind(EjbInvocation inv, EntityContextImpl context) {
        if (this.willInvokeWithClientTx(inv) && !inv.method.getName().equals("findByPrimaryKey")) {
            Transaction tx = null;
            try {
                tx = this.transactionManager.getTransaction();
            }
            catch (SystemException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            this.storeAllBeansInTx(tx);
        }
    }

    public void preSelect() throws EJBException {
        _logger.fine(" inside preSelect...");
        Transaction tx = null;
        try {
            _logger.fine("PRESELECT : getting transaction...");
            tx = this.transactionManager.getTransaction();
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        _logger.fine("PRESELECT : calling storeAllBeansInTx()...");
        this.storeAllBeansInTx(tx);
    }

    public Object postFind(EjbInvocation inv, Object primaryKeys, Object[] findParams) throws FinderException {
        if (primaryKeys instanceof Enumeration) {
            Enumeration e = (Enumeration)primaryKeys;
            ObjrefEnumeration objrefs = new ObjrefEnumeration();
            while (e.hasMoreElements()) {
                Object primaryKey = e.nextElement();
                if (primaryKey != null) {
                    Object ref = inv.isLocal ? this.getEJBLocalObjectForPrimaryKey(primaryKey) : this.getEJBObjectStub(primaryKey, null);
                    objrefs.add(ref);
                    continue;
                }
                objrefs.add(null);
            }
            return objrefs;
        }
        if (primaryKeys instanceof Collection) {
            Collection c = (Collection)primaryKeys;
            Iterator it = c.iterator();
            ArrayList<EJBLocalObject> objrefs = new ArrayList<EJBLocalObject>();
            while (it.hasNext()) {
                Object primaryKey = it.next();
                if (primaryKey != null) {
                    Object ref = inv.isLocal ? this.getEJBLocalObjectForPrimaryKey(primaryKey) : this.getEJBObjectStub(primaryKey, null);
                    objrefs.add((EJBLocalObject)ref);
                    continue;
                }
                objrefs.add(null);
            }
            return objrefs;
        }
        if (primaryKeys != null) {
            if (inv.isLocal) {
                return this.getEJBLocalObjectForPrimaryKey(primaryKeys);
            }
            return this.getEJBObjectStub(primaryKeys, null);
        }
        return null;
    }

    public EJBObject getEJBObjectForPrimaryKey(Object pkey) {
        return this.getEJBObjectStub(pkey, null);
    }

    public EJBLocalObject getEJBLocalObjectForPrimaryKey(Object pkey, EJBContext ctx) {
        assert (ctx instanceof EntityContextImpl);
        EntityContextImpl context = (EntityContextImpl)ctx;
        EJBLocalObjectImpl ejbLocalObjectImpl = this.internalGetEJBLocalObjectImpl(pkey);
        if (context.isCascadeDeleteBeforeEJBRemove()) {
            EntityContextImpl ctx2;
            ActiveTxCache activeTxCache;
            JavaEETransaction current = null;
            try {
                current = (JavaEETransaction)this.transactionManager.getTransaction();
            }
            catch (SystemException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            ActiveTxCache activeTxCache2 = activeTxCache = current == null ? null : (ActiveTxCache)this.ejbContainerUtilImpl.getActiveTxCache((Transaction)current);
            if (activeTxCache != null && (ctx2 = activeTxCache.get(this, pkey)) != null && ctx2.isCascadeDeleteAfterSuperEJBRemove()) {
                return null;
            }
            return (EJBLocalObject)ejbLocalObjectImpl.getClientObject();
        }
        return (EJBLocalObject)ejbLocalObjectImpl.getClientObject();
    }

    public EJBLocalObject getEJBLocalObjectForPrimaryKey(Object pkey) {
        EJBLocalObjectImpl localObjectImpl = this.internalGetEJBLocalObjectImpl(pkey);
        return localObjectImpl != null ? (EJBLocalObject)localObjectImpl.getClientObject() : null;
    }

    protected void doEJBHomeRemove(Object primaryKey, Method removeMethod, boolean local) throws RemoveException, EJBException, RemoteException {
        Object ejbo = local ? this.internalGetEJBLocalObjectImpl(primaryKey, false, true) : this.internalGetEJBObjectImpl(primaryKey, null, false, true);
        this.removeBean((EJBLocalRemoteObject)ejbo, removeMethod, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException, RemoteException {
        EjbInvocation i = super.createEjbInvocation();
        i.ejbObject = ejbo;
        i.isLocal = local;
        i.isRemote = !local;
        i.method = removeMethod;
        Class<?> declaringClass = removeMethod.getDeclaringClass();
        i.isHome = declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class;
        try {
            this.preInvoke(i);
            this.removeBean(i);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "entitybean.container.preinvoke_exception", this.logParams);
            _logger.log(Level.SEVERE, "", e);
            i.exception = e;
        }
        finally {
            this.postInvoke(i);
        }
        if (i.exception != null) {
            if (i.exception instanceof RemoveException) {
                throw (RemoveException)i.exception;
            }
            if (i.exception instanceof RuntimeException) {
                throw (RuntimeException)i.exception;
            }
            if (i.exception instanceof Exception) {
                throw new EJBException((Exception)i.exception);
            }
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(i.exception);
            throw ejbEx;
        }
    }

    protected void removeBean(EjbInvocation inv) throws RemoveException {
        try {
            this.ejbProbeNotifier.ejbBeanDestroyedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
            EntityBean ejb = (EntityBean)inv.ejb;
            EntityContextImpl context = (EntityContextImpl)inv.context;
            this.callEJBRemove(ejb, context);
            Object primaryKey = this.getInvocationKey(inv);
            if (this.isRemote) {
                this.removeEJBObjectFromStore(primaryKey);
            }
            if (this.isLocal) {
                this.ejbLocalObjectStore.remove(primaryKey);
            }
            this.containerStateManager.markObjectRemoved((EJBContextImpl)context, true);
            this.cancelTimers(primaryKey);
        }
        catch (RemoveException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "entitybean.container.local_remove_exception", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "entitybean.container.remove_bean_exception", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
            throw new EJBException(ex);
        }
    }

    private void removeEJBObjectFromStore(Object primaryKey) {
        this.removeEJBObjectFromStore(primaryKey, true);
    }

    ComponentInvocation getCurrentInvocation() {
        return this.invocationManager.getCurrentInvocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEJBObjectFromStore(Object primaryKey, boolean decrementRefCount) {
        EJBObjectImpl ejbObjImpl = (EJBObjectImpl)this.ejbObjectStore.remove(primaryKey, decrementRefCount);
        if (ejbObjImpl != null) {
            EJBObjectImpl eJBObjectImpl = ejbObjImpl;
            synchronized (eJBObjectImpl) {
                this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
            }
        }
    }

    public void removeBeanUnchecked(EJBLocalObject localObj) {
        EJBLocalObjectImpl localObjectImpl = EJBLocalObjectImpl.toEJBLocalObjectImpl((EJBLocalObject)localObj);
        this.internalRemoveBeanUnchecked((EJBLocalRemoteObject)localObjectImpl, true);
    }

    public void removeBeanUnchecked(Object primaryKey) {
        if (this.isLocal) {
            EJBLocalObjectImpl ejbo = this.internalGetEJBLocalObjectImpl(primaryKey);
            this.internalRemoveBeanUnchecked((EJBLocalRemoteObject)ejbo, true);
        } else {
            EJBObjectImpl ejbo = this.internalGetEJBObjectImpl(primaryKey, null);
            this.internalRemoveBeanUnchecked((EJBLocalRemoteObject)ejbo, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveBeanUnchecked(EJBLocalRemoteObject localRemoteObj, boolean local) {
        EjbInvocation inv = super.createEjbInvocation();
        inv.ejbObject = localRemoteObj;
        inv.isLocal = local;
        inv.isRemote = !local;
        Method method = null;
        try {
            method = EJBLocalObject.class.getMethod("remove", NO_PARAMS);
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.FINE, "Exception in internalRemoveBeanUnchecked()", e);
        }
        inv.method = method;
        inv.invocationInfo = (InvocationInfo)this.invocationInfoMap.get(method);
        try {
            EntityContextImpl context = this.getEJBWithIncompleteTx(inv);
            if (context == null) {
                context = this.getReadyEJB(inv);
            }
            EntityContextImpl entityContextImpl = context;
            synchronized (entityContextImpl) {
                if (context.isInState(EJBContextImpl.BeanState.INVOKING) && !this.isReentrant) {
                    throw new EJBException("EJB is already executing another request");
                }
                if (context.isInState(EJBContextImpl.BeanState.POOLED) || context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
                    throw new EJBException("Internal error: unknown EJB state");
                }
                context.setState(EJBContextImpl.BeanState.INVOKING);
            }
            inv.context = context;
            context.setLastTransactionStatus(-1);
            context.incrementCalls();
            inv.instance = inv.ejb = context.getEJB();
            inv.container = this;
            this.invocationManager.preInvoke((ComponentInvocation)inv);
            this.useClientTx(context.getTransaction(), inv);
            try {
                context.setCascadeDeleteBeforeEJBRemove(true);
                this.removeBean(inv);
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception in internalRemoveBeanUnchecked()", ex);
                inv.exception = this.checkExceptionClientTx(context, ex);
            }
            if (inv.exception != null) {
                throw inv.exception;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        catch (Throwable ex) {
            throw (EJBException)new EJBException().initCause(ex);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)inv);
            this.releaseContext(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceDestroyBean(EJBContextImpl ctx) {
        EntityContextImpl context = (EntityContextImpl)ctx;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            this.entityCtxPool.destroyObject(null);
            return;
        }
        EntityContextImpl entityContextImpl = context;
        synchronized (entityContextImpl) {
            try {
                Object primaryKey = context.getPrimaryKey();
                if (primaryKey != null) {
                    Transaction txCurrent;
                    ActiveTxCache activeTxCache;
                    if (context.getTransaction() != null && (activeTxCache = (ActiveTxCache)this.ejbContainerUtilImpl.getActiveTxCache(txCurrent = context.getTransaction())) != null) {
                        activeTxCache.remove(this, primaryKey);
                    }
                    this.removeContextFromReadyStore(primaryKey, context);
                    if (!this.containerStateManager.isNullEJBObject((EJBContextImpl)context)) {
                        this.removeEJBObjectFromStore(primaryKey);
                    }
                    if (!this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
                        this.ejbLocalObjectStore.remove(primaryKey);
                    }
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception in forceDestroyBean()", ex);
            }
            finally {
                try {
                    context.setState(EJBContextImpl.BeanState.DESTROYED);
                    this.entityCtxPool.destroyObject((Object)context);
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Exception in forceDestroyBean()", ex);
                }
            }
        }
    }

    protected void checkUnfinishedTx(Transaction prevTx, EjbInvocation inv) {
        try {
            if (prevTx != null && prevTx.getStatus() != 6) {
                throw new IllegalStateException("Bean is associated with a different unfinished transaction");
            }
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    protected void checkExists(EJBLocalRemoteObject ejbObj) {
    }

    protected void afterBegin(EJBContextImpl ctx) {
        EntityContextImpl context = (EntityContextImpl)ctx;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        if (!this.containerStateManager.isNullEJBObject((EJBContextImpl)context) || !this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
            if (context.getTransaction() != null) {
                this.addIncompleteTxEJB(context);
            }
            EntityBean e = (EntityBean)context.getEJB();
            try {
                this.callEJBLoad(e, context, true);
            }
            catch (NoSuchEntityException ex) {
                _logger.log(Level.FINE, "Exception in afterBegin()", ex);
                this.forceDestroyBean(context);
                throw new NoSuchObjectLocalException("NoSuchEntityException thrown by ejbLoad, EJB instance discarded", (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException(ex);
            }
            context.setNewlyActivated(false);
        }
    }

    protected void beforeCompletion(EJBContextImpl ctx) {
        EntityContextImpl context = (EntityContextImpl)ctx;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        if ((!this.containerStateManager.isNullEJBObject((EJBContextImpl)context) && !this.containerStateManager.isRemovedEJBObject((EJBContextImpl)context) || !this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context) && !this.containerStateManager.isRemovedEJBLocalObject((EJBContextImpl)context)) && context.isDirty()) {
            this.enlistResourcesAndStore(context);
        }
    }

    private void enlistResourcesAndStore(EntityContextImpl context) {
        EntityBean e = (EntityBean)context.getEJB();
        EjbInvocation inv = super.createEjbInvocation((Object)e, (ComponentContext)context);
        this.invocationManager.preInvoke((ComponentInvocation)inv);
        try {
            this.transactionManager.enlistComponentResources();
            this.callEJBStore(e, context);
        }
        catch (NoSuchEntityException ex) {
            this.forceDestroyBean(context);
            throw new NoSuchObjectLocalException("NoSuchEntityException thrown by ejbStore, EJB instance discarded", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.forceDestroyBean(context);
            throw new EJBException(ex);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)inv);
        }
    }

    protected void afterCompletion(EJBContextImpl ctx, int status) {
        EntityContextImpl context = (EntityContextImpl)ctx;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        if (super.isUndeployed()) {
            this.transactionManager.componentDestroyed((ResourceHandler)ctx);
            return;
        }
        if (!this.containerStateManager.isRemovedEJBObject((EJBContextImpl)context) || !this.containerStateManager.isRemovedEJBLocalObject((EJBContextImpl)context)) {
            context.setTransaction(null);
            context.setLastTransactionStatus(status);
            context.setCascadeDeleteAfterSuperEJBRemove(false);
            context.setCascadeDeleteBeforeEJBRemove(false);
            if (!context.isInState(EJBContextImpl.BeanState.INVOKING)) {
                if (status == 3 || status == 6) {
                    this.addReadyEJB(context);
                } else {
                    this.passivateAndPoolEJB(context);
                }
            }
        } else if (this.containerStateManager.isNullEJBObject((EJBContextImpl)context) && this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
            context.setTransaction(null);
            context.setLastTransactionStatus(status);
            context.setCascadeDeleteAfterSuperEJBRemove(false);
            context.setCascadeDeleteBeforeEJBRemove(false);
            if (!context.isInState(EJBContextImpl.BeanState.INVOKING)) {
                this.addPooledEJB(context);
            }
        } else if (this.containerStateManager.isRemovedEJBObject((EJBContextImpl)context) || this.containerStateManager.isRemovedEJBLocalObject((EJBContextImpl)context)) {
            context.setTransaction(null);
            context.setLastTransactionStatus(status);
            if (context.isInState(EJBContextImpl.BeanState.INCOMPLETE_TX)) {
                this.addPooledEJB(context);
            }
        }
    }

    protected void preInvokeNoTx(EjbInvocation inv) {
        EntityContextImpl context = (EntityContextImpl)inv.context;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        if (context.isNewlyActivated() && !inv.invocationInfo.isCreateHomeFinder) {
            EntityBean e = (EntityBean)context.getEJB();
            try {
                this.callEJBLoad(e, context, false);
            }
            catch (NoSuchEntityException ex) {
                this.forceDestroyBean(context);
                throw new NoSuchObjectLocalException("NoSuchEntityException thrown by ejbLoad, EJB instance discarded", (Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException(ex);
            }
            context.setNewlyActivated(false);
        }
    }

    protected void postInvokeNoTx(EjbInvocation inv) {
        this.beforeCompletion((EJBContextImpl)inv.context);
    }

    protected void adjustInvocationInfo(InvocationInfo invInfo, Method method, int txAttr, boolean flushEnabled, String methodIntf, Class originalIntf) throws EJBException {
        invInfo.isHomeFinder = this.isHomeFinder(method);
    }

    private final boolean isHomeFinder(Method method) {
        Class<?> methodClass = method.getDeclaringClass();
        if (this.isRemote && this.hasRemoteHomeView && methodClass.isAssignableFrom(this.homeIntf) && methodClass != EJBHome.class && !method.getName().startsWith("create")) {
            return true;
        }
        return this.isLocal && this.hasLocalHomeView && methodClass.isAssignableFrom(this.localHomeIntf) && methodClass != EJBLocalHome.class && !method.getName().startsWith("create");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimEvent(Object primaryKey, Object context) {
        Object object = this.asyncTaskSemaphore;
        synchronized (object) {
            this.passivationCandidates.add(context);
            if (this.addedASyncTask) {
                return;
            }
            this.addedASyncTask = true;
        }
        try {
            ASyncPassivator work = new ASyncPassivator();
            this.ejbContainerUtilImpl.addWork((Runnable)work);
        }
        catch (Exception ex) {
            this.addedASyncTask = false;
            _logger.log(Level.WARNING, "entitybean.container.add_cleanup_task_error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean passivateEJB(ComponentContext ctx) {
        if (this.containerState != 0) {
            return false;
        }
        EntityContextImpl context = (EntityContextImpl)ctx;
        if (!context.isInState(EJBContextImpl.BeanState.READY)) {
            return false;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "EntityContainer.passivateEJB(): context = (" + ctx + ")");
        }
        EntityBean ejb = (EntityBean)context.getEJB();
        EjbInvocation inv = super.createEjbInvocation((Object)ejb, (ComponentContext)context);
        inv.method = this.ejbPassivateMethod;
        Object pkey = context.getPrimaryKey();
        boolean wasPassivated = false;
        if (!context.isInState(EJBContextImpl.BeanState.READY)) {
            return false;
        }
        try {
            this.invocationManager.preInvoke((ComponentInvocation)inv);
            this.removeContextFromReadyStore(pkey, context);
            ejb.ejbPassivate();
            wasPassivated = true;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in passivateEJB()", ex);
            this.forceDestroyBean(context);
            boolean bl = false;
            return bl;
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)inv);
        }
        if (this.isRemote) {
            this.removeEJBObjectFromStore(pkey);
        }
        if (this.isLocal) {
            this.ejbLocalObjectStore.remove(pkey);
        }
        EntityContextImpl entityContextImpl = context;
        synchronized (entityContextImpl) {
            this.addPooledEJB(context);
        }
        return wasPassivated;
    }

    protected EJBLocalObjectImpl internalGetEJBLocalObjectImpl(Object primaryKey) {
        return this.internalGetEJBLocalObjectImpl(primaryKey, false, this.defaultCacheEJBO);
    }

    protected EJBLocalObjectImpl internalGetEJBLocalObjectImpl(Object primaryKey, boolean incrementRefCount) {
        return this.internalGetEJBLocalObjectImpl(primaryKey, incrementRefCount, this.defaultCacheEJBO);
    }

    protected EJBLocalObjectImpl internalGetEJBLocalObjectImpl(Object primaryKey, boolean incrementRefCount, boolean cacheEJBO) {
        try {
            EJBLocalObjectImpl localObjImpl = (EJBLocalObjectImpl)this.ejbLocalObjectStore.get(primaryKey, incrementRefCount);
            if (localObjImpl == null) {
                localObjImpl = this.instantiateEJBLocalObjectImpl(primaryKey);
                if (incrementRefCount || cacheEJBO) {
                    this.ejbLocalObjectStore.put(primaryKey, localObjImpl, incrementRefCount);
                }
            }
            return localObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "entitybean.container.get_ejb_local_object_exception", this.logParams);
            _logger.log(Level.SEVERE, "", ex);
            throw new EJBException(ex);
        }
    }

    EJBObject getEJBObjectStub(Object primaryKey, byte[] streamKey) {
        try {
            EJBObjectImpl ejbObjImpl = (EJBObjectImpl)this.ejbObjectStore.get(primaryKey);
            if (ejbObjImpl != null && ejbObjImpl.getStub() != null) {
                return (EJBObject)ejbObjImpl.getStub();
            }
            if (streamKey == null) {
                streamKey = EJBUtils.serializeObject((Object)primaryKey, (boolean)false);
            }
            EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(streamKey);
            return ejbStub;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "", ex);
            throw new EJBException(ex);
        }
    }

    private EJBObjectImpl internalGetEJBObjectImpl(Object primaryKey, byte[] streamKey) {
        return this.internalGetEJBObjectImpl(primaryKey, streamKey, false, this.defaultCacheEJBO);
    }

    private EJBObjectImpl internalGetEJBObjectImpl(Object primaryKey, byte[] streamKey, boolean incrementRefCount) {
        return this.internalGetEJBObjectImpl(primaryKey, streamKey, incrementRefCount, this.defaultCacheEJBO);
    }

    private EJBObjectImpl internalGetEJBObjectImpl(Object primaryKey, byte[] streamKey, boolean incrementRefCount, boolean cacheEJBO) {
        try {
            EJBObjectImpl ejbo1;
            EJBObjectImpl ejbObjImpl = (EJBObjectImpl)this.ejbObjectStore.get(primaryKey, incrementRefCount);
            if (ejbObjImpl != null && ejbObjImpl.getStub() != null) {
                return ejbObjImpl;
            }
            ejbObjImpl = (EJBObjectImpl)this.ejbServant.get();
            if (ejbObjImpl != null) {
                return ejbObjImpl;
            }
            this.ejbServant.set(ejbObjImpl);
            if (streamKey == null) {
                streamKey = EJBUtils.serializeObject((Object)primaryKey, (boolean)false);
            }
            EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(streamKey);
            ejbObjImpl = this.instantiateEJBObjectImpl(ejbStub, primaryKey);
            this.ejbServant.set(null);
            if ((incrementRefCount || cacheEJBO) && (ejbo1 = (EJBObjectImpl)this.ejbObjectStore.put(primaryKey, ejbObjImpl, incrementRefCount)) != null && ejbo1 != ejbObjImpl) {
                this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), (Remote)ejbObjImpl);
                ejbObjImpl = ejbo1;
            }
            return ejbObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "entitybean.container.get_ejb_context_exception", this.logParams);
            _logger.log(Level.FINE, "", ex);
            throw new EJBException(ex);
        }
    }

    protected EntityContextImpl getPooledEJB() {
        try {
            return (EntityContextImpl)this.entityCtxPool.getObject(true, null);
        }
        catch (PoolException inEx) {
            throw new EJBException((Exception)((Object)inEx));
        }
    }

    protected void addPooledEJB(EntityContextImpl context) {
        if (context.isInState(EJBContextImpl.BeanState.POOLED)) {
            return;
        }
        this.containerStateManager.clearContext((EJBContextImpl)context);
        context.setState(EJBContextImpl.BeanState.POOLED);
        context.clearCachedPrimaryKey();
        this.entityCtxPool.returnObject((Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivateAndPoolEJB(EntityContextImpl context) {
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED) || context.isInState(EJBContextImpl.BeanState.POOLED)) {
            return;
        }
        EntityBean ejb = (EntityBean)context.getEJB();
        EntityContextImpl entityContextImpl = context;
        synchronized (entityContextImpl) {
            EjbInvocation inv = super.createEjbInvocation((Object)ejb, (ComponentContext)context);
            inv.method = this.ejbPassivateMethod;
            this.invocationManager.preInvoke((ComponentInvocation)inv);
            try {
                ejb.ejbPassivate();
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception in passivateAndPoolEJB()", ex);
                this.forceDestroyBean(context);
                return;
            }
            finally {
                this.invocationManager.postInvoke((ComponentInvocation)inv);
            }
            Object primaryKey = context.getPrimaryKey();
            if (this.isRemote) {
                this.removeEJBObjectFromStore(primaryKey);
            }
            if (this.isLocal) {
                this.ejbLocalObjectStore.remove(primaryKey);
            }
            this.addPooledEJB(context);
        }
    }

    protected EntityContextImpl activateEJBFromPool(Object primaryKey, EjbInvocation inv) {
        EntityContextImpl context = null;
        context = this.getPooledEJB();
        if (inv.isLocal) {
            EJBLocalObjectImpl localObjImpl = this.internalGetEJBLocalObjectImpl(primaryKey, true);
            this.containerStateManager.attachObject(inv, (EJBContextImpl)context, null, localObjImpl);
        } else {
            EJBObjectImpl ejbObjImpl = this.internalGetEJBObjectImpl(primaryKey, null, true);
            this.containerStateManager.attachObject(inv, (EJBContextImpl)context, ejbObjImpl, null);
            if (this.isLocal) {
                this.containerStateManager.attachObject(inv, (EJBContextImpl)context, null, this.internalGetEJBLocalObjectImpl(primaryKey, true));
            }
        }
        context.setState(EJBContextImpl.BeanState.READY);
        EntityBean ejb = (EntityBean)context.getEJB();
        EjbInvocation inv2 = super.createEjbInvocation((Object)ejb, (ComponentContext)context);
        inv2.method = this.ejbActivateMethod;
        this.invocationManager.preInvoke((ComponentInvocation)inv2);
        try {
            ejb.ejbActivate();
        }
        catch (Exception ex) {
            this.forceDestroyBean(context);
            throw new EJBException(ex);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)inv2);
        }
        context.setNewlyActivated(true);
        this.afterNewlyActivated(context);
        return context;
    }

    private EntityContextImpl getEJBWithIncompleteTx(EjbInvocation inv) {
        JavaEETransaction current = null;
        try {
            current = (JavaEETransaction)this.transactionManager.getTransaction();
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        EntityContextImpl ctx = null;
        if (current != null) {
            ActiveTxCache activeTxCache = (ActiveTxCache)this.ejbContainerUtilImpl.getActiveTxCache((Transaction)current);
            ctx = activeTxCache == null ? null : activeTxCache.get(this, this.getInvocationKey(inv));
            inv.foundInTxCache = ctx != null;
        }
        return ctx;
    }

    private void addIncompleteTxEJB(EntityContextImpl context) {
        JavaEETransaction current = (JavaEETransaction)context.getTransaction();
        if (current == null) {
            return;
        }
        if (this.containerStateManager.isNullEJBObject((EJBContextImpl)context) && this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
            return;
        }
        ActiveTxCache activeTxCache = (ActiveTxCache)this.ejbContainerUtilImpl.getActiveTxCache((Transaction)current);
        if (activeTxCache == null) {
            activeTxCache = new ActiveTxCache(16);
            this.ejbContainerUtilImpl.setActiveTxCache((Transaction)current, (Object)activeTxCache);
        }
        activeTxCache.add(context);
        Vector beans = this.ejbContainerUtilImpl.getBeans((Transaction)current);
        beans.add(context);
    }

    protected void removeIncompleteTxEJB(EntityContextImpl context, boolean updateTxBeanTable) {
        JavaEETransaction current = (JavaEETransaction)context.getTransaction();
        if (current == null) {
            return;
        }
        if (this.containerStateManager.isNullEJBObject((EJBContextImpl)context) && this.containerStateManager.isNullEJBLocalObject((EJBContextImpl)context)) {
            return;
        }
        ActiveTxCache activeTxCache = (ActiveTxCache)this.ejbContainerUtilImpl.getActiveTxCache((Transaction)current);
        if (activeTxCache != null) {
            activeTxCache.remove(this, context.getPrimaryKey());
        }
        if (updateTxBeanTable) {
            Vector beans = this.ejbContainerUtilImpl.getBeans((Transaction)current);
            beans.remove(context);
        }
    }

    protected boolean isIdentical(EJBObjectImpl ejbObjImpl, EJBObject other) throws RemoteException {
        if (other == ejbObjImpl.getStub()) {
            return true;
        }
        try {
            if (!this.getProtocolManager().isIdentical((Remote)this.ejbHomeStub, (Remote)other.getEJBHome())) {
                return false;
            }
            return ejbObjImpl.getPrimaryKey().equals(other.getPrimaryKey());
        }
        catch (Exception ex) {
            _logger.log(Level.INFO, "entitybean.container.ejb_comparison_exception", this.logParams);
            _logger.log(Level.INFO, "", ex);
            throw new RemoteException("Exception in isIdentical()", ex);
        }
    }

    protected void callEJBLoad(EntityBean ejb, EntityContextImpl context, boolean activeTx) throws Exception {
        try {
            context.setInEjbLoad(true);
            ejb.ejbLoad();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            context.setInEjbLoad(false);
        }
    }

    protected void callEJBStore(EntityBean ejb, EntityContextImpl context) throws Exception {
        try {
            context.setInEjbStore(true);
            ejb.ejbStore();
        }
        finally {
            context.setInEjbStore(false);
            context.setDirty(false);
        }
    }

    protected void callEJBRemove(EntityBean ejb, EntityContextImpl context) throws Exception {
        try {
            ejb.ejbRemove();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            context.setDirty(false);
        }
    }

    protected void doTimerInvocationInit(EjbInvocation inv, Object primaryKey) throws Exception {
        if (this.isRemote) {
            inv.ejbObject = this.internalGetEJBObjectImpl(primaryKey, null);
            inv.isRemote = true;
        } else {
            inv.ejbObject = this.internalGetEJBLocalObjectImpl(primaryKey);
            inv.isLocal = true;
        }
        if (inv.ejbObject == null) {
            throw new Exception("Timed object identity (" + primaryKey + " ) no longer exists ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        String ejbName = this.ejbDescriptor.getName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EntityContainer]: Undeploying " + ejbName + " ...");
        }
        try {
            Iterator elements = this.ejbObjectStore.values();
            while (elements.hasNext()) {
                EJBObjectImpl ejbObjImpl = (EJBObjectImpl)elements.next();
                try {
                    if (!this.isRemote) continue;
                    this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Exception in undeploy()", ex);
                }
            }
            this.ejbObjectStore.destroy();
            this.ejbObjectStore = null;
            this.ejbLocalObjectStore.destroy();
            this.ejbLocalObjectStore = null;
            this.destroyReadyStoreOnUndeploy();
            this.entityCtxPool.close();
            this.poolProbeListener.unregister();
            if (this.cacheProbeListener != null) {
                this.cacheProbeListener.unregister();
            }
            if (this.idleBeansPassivator != null) {
                try {
                    this.idleBeansPassivator.cancel();
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "[EntityContainer] cancelTimerTask: ", e);
                }
                this.idleBeansPassivator.cache = null;
            }
            this.cancelTimerTasks();
        }
        finally {
            this.ejbObjectStore = null;
            this.ejbLocalObjectStore = null;
            this.passivationCandidates = null;
            this.readyStore = null;
            this.entityCtxPool = null;
            this.iased = null;
            this.beanCacheDes = null;
            this.beanPoolDes = null;
            this.ejbContainer = null;
            this.cacheProp = null;
            this.poolProp = null;
            this.asyncTaskSemaphore = null;
            this.idleBeansPassivator = null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " [EntityContainer]: Successfully Undeployed " + ejbName);
        }
    }

    protected void afterNewlyActivated(EntityContextImpl context) {
    }

    protected EntityContextImpl createEntityContextInstance(EntityBean ejb, EntityContainer entityContainer) {
        return new EntityContextImpl(ejb, entityContainer);
    }

    private void createCaches() throws Exception {
        this.cacheProp = new CacheProperties(this);
        int cacheSize = this.cacheProp.maxCacheSize;
        int numberOfVictimsToSelect = this.cacheProp.numberOfVictimsToSelect;
        float loadFactor = 0.75f;
        this.idleTimeout = (long)this.cacheProp.cacheIdleTimeoutInSeconds * 1000L;
        this.createReadyStore(cacheSize, numberOfVictimsToSelect, loadFactor, this.idleTimeout);
        this.createEJBObjectStores(cacheSize, numberOfVictimsToSelect, this.idleTimeout);
    }

    protected void createReadyStore(int cacheSize, int numberOfVictimsToSelect, float loadFactor, long idleTimeout) throws Exception {
        long l = idleTimeout = idleTimeout <= 0L ? -1L : idleTimeout;
        if (cacheSize <= 0 && idleTimeout <= 0L) {
            this.readyStore = new BaseCache();
            cacheSize = 8192;
            this.readyStore.init(cacheSize, loadFactor, null);
        } else {
            cacheSize = cacheSize <= 0 ? 8192 : cacheSize;
            LruCache lru = new LruCache(8192);
            if (numberOfVictimsToSelect >= 0) {
                loadFactor = (float)(1.0 - 1.0 * (double)numberOfVictimsToSelect / (double)cacheSize);
            }
            lru.init(cacheSize, idleTimeout, loadFactor, null);
            this.readyStore = lru;
            this.readyStore.addCacheListener((CacheListener)this);
        }
        if (idleTimeout > 0L) {
            this.idleBeansPassivator = this.setupIdleBeansPassivator(this.readyStore);
        }
    }

    protected void createEJBObjectStores(int cacheSize, int numberOfVictimsToSelect, long idleTimeout) throws Exception {
        Object lru = null;
        String ejbName = this.ejbDescriptor.getName();
        long l = idleTimeout = idleTimeout <= 0L ? -1L : idleTimeout;
        if (cacheSize <= 0 && idleTimeout <= 0L) {
            this.ejbObjectStore = new UnboundedEJBObjectCache(ejbName);
            this.ejbObjectStore.init(8192, numberOfVictimsToSelect, 0L, 1.0f, null);
            this.ejbLocalObjectStore = new UnboundedEJBObjectCache(ejbName);
            this.ejbLocalObjectStore.init(8192, numberOfVictimsToSelect, 0L, 1.0f, null);
        } else {
            cacheSize = cacheSize <= 0 ? 8192 : cacheSize;
            this.ejbObjectStore = new FIFOEJBObjectCache(ejbName);
            this.ejbObjectStore.init(cacheSize, numberOfVictimsToSelect, idleTimeout, 1.0f, null);
            this.ejbObjectStore.setEJBObjectCacheListener(new EJBObjectCacheVictimHandler());
            this.ejbLocalObjectStore = new FIFOEJBObjectCache(ejbName);
            this.ejbLocalObjectStore.init(cacheSize, numberOfVictimsToSelect, idleTimeout, 1.0f, null);
            this.ejbLocalObjectStore.setEJBObjectCacheListener(new LocalEJBObjectCacheVictimHandler());
        }
        if (idleTimeout > 0L) {
            this.idleEJBObjectPassivator = this.setupIdleBeansPassivator(this.ejbObjectStore);
            this.idleLocalEJBObjectPassivator = this.setupIdleBeansPassivator(this.ejbLocalObjectStore);
        }
    }

    protected EntityContextImpl getReadyEJB(EjbInvocation inv) {
        Object primaryKey = this.getInvocationKey(inv);
        EntityContextImpl context = null;
        context = (EntityContextImpl)this.readyStore.remove(primaryKey);
        if (context == null || !context.isInState(EJBContextImpl.BeanState.READY)) {
            context = this.activateEJBFromPool(primaryKey, inv);
        }
        return context;
    }

    protected void addReadyEJB(EntityContextImpl context) {
        Object primaryKey = context.getPrimaryKey();
        context.setState(EJBContextImpl.BeanState.READY);
        this.readyStore.add(primaryKey, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyReadyStoreOnUndeploy() {
        if (this.readyStore == null) {
            return;
        }
        Cache cache = this.readyStore;
        synchronized (cache) {
            Iterator beans = this.readyStore.values();
            while (beans.hasNext()) {
                EJBContextImpl ctx = (EJBContextImpl)beans.next();
                this.transactionManager.componentDestroyed((ResourceHandler)ctx);
            }
        }
        this.readyStore.destroy();
        this.readyStore = null;
    }

    protected void removeContextFromReadyStore(Object primaryKey, EntityContextImpl context) {
        this.readyStore.remove(primaryKey, (Object)context);
    }

    protected void addProxyInterfacesSetClass(Set proxyInterfacesSet, boolean local) {
        if (this.ejbDescriptor.getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
            if (local) {
                proxyInterfacesSet.add(ReadOnlyEJBLocalHome.class);
            } else {
                proxyInterfacesSet.add(ReadOnlyEJBHome.class);
            }
        }
    }

    protected void doFlush(EjbInvocation inv) {
        if (!inv.invocationInfo.flushEnabled || inv.exception != null) {
            return;
        }
        if (!this.isContainerManagedPers) {
            _logger.log(Level.WARNING, "Cannot turn on flush-enabled-at-end-of-method for a bean with Bean Managed Persistence");
            return;
        }
        InvocationInfo invInfo = inv.invocationInfo;
        EntityContextImpl context = (EntityContextImpl)inv.context;
        Transaction tx = context.getTransaction();
        if (tx == null) {
            return;
        }
        try {
            if (context.getRollbackOnly()) {
                return;
            }
        }
        catch (Throwable ex) {
            _logger.log(Level.WARNING, "Exception when calling getRollbackOnly", ex);
            return;
        }
        if (invInfo.isBusinessMethod) {
            try {
                this.storeAllBeansInTx(tx);
            }
            catch (Throwable ex) {
                inv.exception = ex;
                return;
            }
        }
        try {
            BeanStateSynchronization pmcontract = (BeanStateSynchronization)inv.ejb;
            pmcontract.ejb__flush();
        }
        catch (Throwable ex) {
            if (invInfo.startsWithCreate) {
                CreateException ejbEx = new CreateException();
                ejbEx.initCause(ex);
                inv.exception = ejbEx;
            } else if (invInfo.startsWithRemove) {
                RemoveException ejbEx = new RemoveException();
                ejbEx.initCause(ex);
                inv.exception = ejbEx;
            } else {
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(ex);
                inv.exception = ejbEx;
            }
            return;
        }
    }

    private void storeAllBeansInTx(Transaction tx) {
        Vector beans = this.ejbContainerUtilImpl.getBeans(tx);
        if (beans.isEmpty()) {
            return;
        }
        for (EntityContextImpl ctx : beans) {
            if (!ctx.isInState(EJBContextImpl.BeanState.INCOMPLETE_TX) || !ctx.isDirty()) continue;
            EntityContainer cont = (EntityContainer)ctx.getContainer();
            cont.enlistResourcesAndStore(ctx);
        }
    }

    static /* synthetic */ ClassLoader access$100(EntityContainer x0) {
        return x0.loader;
    }

    static /* synthetic */ ClassLoader access$1400(EntityContainer x0) {
        return x0.loader;
    }

    static {
        _logger.log(Level.FINE, " Loading Entitycontainer...");
    }

    class EntityCacheStatsProvider
    implements EjbCacheStatsProviderDelegate {
        private final BaseCache cache;
        private final int confMaxCacheSize;

        EntityCacheStatsProvider(BaseCache cache, int maxCacheSize) {
            this.cache = cache;
            this.confMaxCacheSize = maxCacheSize;
        }

        public int getCacheHits() {
            return (Integer)this.cache.getStatByName("cache.BaseCache.stat_hitCount");
        }

        public int getCacheMisses() {
            return (Integer)this.cache.getStatByName("cache.BaseCache.stat_missCount");
        }

        public int getNumBeansInCache() {
            return this.cache.getEntryCount();
        }

        public int getNumExpiredSessionsRemoved() {
            return 0;
        }

        public int getNumPassivationErrors() {
            return EntityContainer.this.totalPassivationErrors;
        }

        public int getNumPassivations() {
            return EntityContainer.this.totalPassivations;
        }

        public int getNumPassivationSuccess() {
            return EntityContainer.this.totalPassivations - EntityContainer.this.totalPassivationErrors;
        }

        public int getMaxCacheSize() {
            return this.confMaxCacheSize;
        }

        public void appendStats(StringBuilder sbuf) {
            sbuf.append("[Cache: ").append("Size=").append(this.getNumBeansInCache()).append("; ").append("HitCount=").append(this.getCacheHits()).append("; ").append("MissCount=").append(this.getCacheMisses()).append("; ").append("Passivations=").append(this.getNumPassivations()).append("; ]");
        }
    }

    protected class EJBObjectCacheVictimHandler
    extends LocalEJBObjectCacheVictimHandler {
        protected EJBObjectCacheVictimHandler() {
        }

        @Override
        protected void doCleanup(Object key) {
            EntityContainer.this.removeEJBObjectFromStore(key, false);
        }
    }

    protected class LocalEJBObjectCacheVictimHandler
    implements EJBObjectCacheListener,
    Runnable {
        protected Object lock = new Object();
        protected boolean addedTask = false;
        protected ArrayList keys = new ArrayList(16);

        protected LocalEJBObjectCacheVictimHandler() {
        }

        @Override
        public void handleOverflow(Object key) {
            this.doCleanup(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleBatchOverflow(ArrayList paramKeys) {
            int size = paramKeys.size();
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < size; ++i) {
                    this.keys.add(paramKeys.get(i));
                }
                if (this.addedTask) {
                    return;
                }
                this.addedTask = true;
            }
            try {
                EntityContainer.this.ejbContainerUtilImpl.addWork((Runnable)this);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "entitybean.container.entity_add_async_task", ex);
                Object object2 = this.lock;
                synchronized (object2) {
                    this.addedTask = false;
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void doCleanup(Object key) {
            EntityContainer.this.ejbLocalObjectStore.remove(key, false);
        }
    }

    private class EntityContextFactory
    implements ObjectFactory {
        private final EntityContainer entityContainer;

        public EntityContextFactory(EntityContainer entityContainer2) {
            this.entityContainer = entityContainer2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object create(Object param) {
            EntityContextImpl entityCtx;
            block5: {
                entityCtx = null;
                EjbInvocation ejbInv = null;
                try {
                    EntityBean ejb = (EntityBean)EntityContainer.this.ejbClass.newInstance();
                    entityCtx = EntityContainer.this.createEntityContextInstance(ejb, this.entityContainer);
                    ejbInv = this.entityContainer.createEjbInvocation(ejb, (ComponentContext)entityCtx);
                    EntityContainer.this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
                    ejb.setEntityContext((EntityContext)entityCtx);
                    if (ejbInv == null) break block5;
                }
                catch (Exception ex) {
                    try {
                        throw new EJBException("Could not create Entity EJB", ex);
                    }
                    catch (Throwable throwable) {
                        if (ejbInv != null) {
                            EntityContainer.this.invocationManager.postInvoke(ejbInv);
                        }
                        throw throwable;
                    }
                }
                EntityContainer.this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
            }
            entityCtx.touch();
            return entityCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(Object object) {
            block16: {
                if (object == null) {
                    return;
                }
                EntityContextImpl context = (EntityContextImpl)object;
                EntityBean ejb = (EntityBean)context.getEJB();
                if (!context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
                    EjbInvocation ci = this.entityContainer.createEjbInvocation(ejb, (ComponentContext)context);
                    EntityContainer.this.invocationManager.preInvoke((ComponentInvocation)ci);
                    try {
                        EntityContextImpl entityContextImpl = context;
                        synchronized (entityContextImpl) {
                            EntityContainer.this.containerStateManager.clearContext((EJBContextImpl)context);
                            context.setState(EJBContextImpl.BeanState.DESTROYED);
                            context.setInUnsetEntityContext(true);
                            try {
                                ejb.unsetEntityContext();
                            }
                            catch (Exception ex) {
                                _logger.log(Level.FINE, "Exception in ejb.unsetEntityContext()", ex);
                            }
                            EntityContainer.this.transactionManager.componentDestroyed((ResourceHandler)context);
                            break block16;
                        }
                    }
                    finally {
                        EntityContainer.this.invocationManager.postInvoke((ComponentInvocation)ci);
                    }
                }
                try {
                    EntityContextImpl ci = context;
                    synchronized (ci) {
                        EntityContainer.this.containerStateManager.clearContext((EJBContextImpl)context);
                        context.setState(EJBContextImpl.BeanState.DESTROYED);
                        Transaction tx = context.getTransaction();
                        if (tx != null && tx.getStatus() != 6) {
                            context.getTransaction().setRollbackOnly();
                        }
                        EntityContainer.this.transactionManager.componentDestroyed((ResourceHandler)context);
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Exception in destroy()", ex);
                }
            }
        }
    }

    private static class PoolProperties {
        int maxPoolSize;
        int poolIdleTimeoutInSeconds;
        int poolResizeQuantity;
        int steadyPoolSize;

        public PoolProperties(EntityContainer entityContainer) {
            this.maxPoolSize = Integer.parseInt(entityContainer.ejbContainer.getMaxPoolSize());
            this.poolIdleTimeoutInSeconds = Integer.parseInt(entityContainer.ejbContainer.getPoolIdleTimeoutInSeconds());
            this.poolResizeQuantity = Integer.parseInt(entityContainer.ejbContainer.getPoolResizeQuantity());
            this.steadyPoolSize = Integer.parseInt(entityContainer.ejbContainer.getSteadyPoolSize());
            if (entityContainer.beanPoolDes != null) {
                int temp = 0;
                temp = entityContainer.beanPoolDes.getMaxPoolSize();
                if (temp != -1) {
                    this.maxPoolSize = temp;
                }
                if ((temp = entityContainer.beanPoolDes.getPoolIdleTimeoutInSeconds()) != -1) {
                    this.poolIdleTimeoutInSeconds = temp;
                }
                if ((temp = entityContainer.beanPoolDes.getPoolResizeQuantity()) != -1) {
                    this.poolResizeQuantity = temp;
                }
                if ((temp = entityContainer.beanPoolDes.getSteadyPoolSize()) != -1) {
                    this.steadyPoolSize = temp;
                }
            }
        }
    }

    protected static class CacheProperties {
        int maxCacheSize;
        int numberOfVictimsToSelect;
        int cacheIdleTimeoutInSeconds;

        public CacheProperties(EntityContainer entityContainer) {
            this.numberOfVictimsToSelect = Integer.parseInt(entityContainer.ejbContainer.getCacheResizeQuantity());
            this.maxCacheSize = Integer.parseInt(entityContainer.ejbContainer.getMaxCacheSize());
            this.cacheIdleTimeoutInSeconds = Integer.parseInt(entityContainer.ejbContainer.getCacheIdleTimeoutInSeconds());
            if (entityContainer.beanCacheDes != null) {
                int temp = 0;
                temp = entityContainer.beanCacheDes.getResizeQuantity();
                if (temp != -1) {
                    this.numberOfVictimsToSelect = temp;
                }
                if ((temp = entityContainer.beanCacheDes.getMaxCacheSize()) != -1) {
                    this.maxCacheSize = temp;
                }
                if ((temp = entityContainer.beanCacheDes.getCacheIdleTimeoutInSeconds()) != -1) {
                    this.cacheIdleTimeoutInSeconds = temp;
                }
            }
        }
    }

    private static class EJBTxKey {
        Transaction tx;
        Object primaryKey;
        int pkHashCode;

        EJBTxKey(Object primaryKey, Transaction tx) {
            this.tx = tx;
            this.primaryKey = primaryKey;
            this.pkHashCode = primaryKey.hashCode();
        }

        public final int hashCode() {
            return this.pkHashCode;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof EJBTxKey)) {
                return false;
            }
            EJBTxKey other = (EJBTxKey)obj;
            try {
                if (this.primaryKey.equals(other.primaryKey)) {
                    if (this.tx == null && other.tx == null) {
                        return true;
                    }
                    return this.tx != null && other.tx != null && this.tx.equals(other.tx);
                }
                return false;
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception in equals()", ex);
                return false;
            }
        }
    }

    private class IdleBeansPassivator
    extends TimerTask {
        Cache cache;

        IdleBeansPassivator(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            if (EntityContainer.this.timerValid) {
                this.cache.trimExpiredEntries(Integer.MAX_VALUE);
            }
        }

        @Override
        public boolean cancel() {
            this.cache = null;
            return super.cancel();
        }
    }

    private class ASyncPassivator
    implements Runnable {
        private ASyncPassivator() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

