/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.admin.amx.config.AMXConfiguration;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationFactory;
import fish.payara.jmx.monitoring.JMXMonitoringFormatter;
import fish.payara.jmx.monitoring.JMXMonitoringJob;
import fish.payara.jmx.monitoring.configuration.MonitoredAttribute;
import fish.payara.jmx.monitoring.configuration.MonitoringServiceConfiguration;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.messaging.Topic;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-monitoring")
@RunLevel(value=10)
public class JMXMonitoringService
implements EventListener {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(JMXMonitoringService.class);
    private final String PREFIX = "payara-monitoring-service(";
    @Inject
    @Named(value="default-instance-name")
    @Optional
    MonitoringServiceConfiguration configuration;
    @Inject
    ServiceLocator habitat;
    @Inject
    private Events events;
    @Inject
    private Topic<PayaraNotification> notificationEventBus;
    @Inject
    private PayaraNotificationFactory notificationFactory;
    @Inject
    PayaraExecutorService executor;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private JMXMonitoringFormatter formatter;
    private boolean enabled;
    private int amxBootDelay = 10;
    private long monitoringDelay = this.amxBootDelay + 15;
    private final Set<String> enabledNotifiers = new LinkedHashSet<String>();
    private ScheduledFuture<?> monitoringFuture;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownMonitoringService();
        } else if (event.is(EventTypes.SERVER_READY) && this.configuration != null && Boolean.valueOf(this.configuration.getEnabled()).booleanValue()) {
            this.enabled = Boolean.valueOf(this.configuration.getEnabled());
            this.bootstrapMonitoringService();
        }
    }

    public void bootstrapMonitoringService() {
        if (this.configuration != null && this.configuration.getEnabled().equalsIgnoreCase("true")) {
            this.shutdownMonitoringService();
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.formatter = new JMXMonitoringFormatter(server, this.buildJobs(), this, this.notificationEventBus, this.notificationFactory, this.enabledNotifiers);
            Logger.getLogger(JMXMonitoringService.class.getName()).log(Level.INFO, "JMX Monitoring Service will startup");
            if (Boolean.valueOf(this.configuration.getAmx()).booleanValue()) {
                AMXConfiguration amxConfig = (AMXConfiguration)this.habitat.getService(AMXConfiguration.class, new Annotation[0]);
                try {
                    amxConfig.setEnabled(String.valueOf(this.configuration.getAmx()));
                    this.configuration.setAmx(null);
                }
                catch (PropertyVetoException ex) {
                    Logger.getLogger(JMXMonitoringService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.monitoringFuture = this.executor.scheduleAtFixedRate((Runnable)this.formatter, this.monitoringDelay * 1000L, TimeUnit.MILLISECONDS.convert(Long.valueOf(this.configuration.getLogFrequency()), TimeUnit.valueOf(this.configuration.getLogFrequencyUnit())), TimeUnit.MILLISECONDS);
            this.bootstrapNotifierList();
        }
    }

    public void bootstrapNotifierList() {
        this.enabledNotifiers.clear();
        if (this.configuration.getNotifierList() != null) {
            this.configuration.getNotifierList().forEach(this.enabledNotifiers::add);
        }
    }

    public Set<String> getEnabledNotifiers() {
        return this.enabledNotifiers;
    }

    private void shutdownMonitoringService() {
        if (this.monitoringFuture != null) {
            Logger.getLogger(JMXMonitoringService.class.getName()).log(Level.INFO, "JMX Monitoring Service will shutdown");
            this.monitoringFuture.cancel(false);
            this.monitoringFuture = null;
        }
    }

    public void setEnabled(Boolean enabled) {
        this.amxBootDelay = 0;
        this.monitoringDelay = this.amxBootDelay + 5;
        if (enabled.booleanValue()) {
            this.enabled = enabled;
            this.bootstrapMonitoringService();
        } else if (this.enabled && !enabled.booleanValue()) {
            this.enabled = enabled;
            this.shutdownMonitoringService();
        }
    }

    private List<JMXMonitoringJob> buildJobs() {
        LinkedList<JMXMonitoringJob> jobs = new LinkedList<JMXMonitoringJob>();
        for (MonitoredAttribute mbean : this.configuration.getMonitoredAttributes()) {
            boolean exists = false;
            for (JMXMonitoringJob job : jobs) {
                if (!job.getMBean().getCanonicalKeyPropertyListString().equals(mbean.getObjectName())) continue;
                job.addAttribute(mbean.getAttributeName());
                exists = true;
                break;
            }
            if (exists) continue;
            try {
                ObjectName name = new ObjectName(mbean.getObjectName());
                LinkedList<String> list = new LinkedList<String>();
                list.add(mbean.getAttributeName());
                jobs.add(new JMXMonitoringJob(name, list));
            }
            catch (MalformedObjectNameException ex) {
                Logger.getLogger(JMXMonitoringService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return jobs;
    }

    public LocalStringManagerImpl getLocalStringManager() {
        return strings;
    }
}

