/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheBase;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.transport.connection.Connection;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ConnectionCacheNonBlockingBase<C extends Connection>
extends ConnectionCacheBase<C> {
    protected final AtomicInteger totalBusy = new AtomicInteger();
    protected final AtomicInteger totalIdle = new AtomicInteger();

    ConnectionCacheNonBlockingBase(String cacheType, int highWaterMark, int numberToReclaim, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim);
        this.reclaimableConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue(ttl);
    }

    @Override
    public long numberOfConnections() {
        return this.totalIdle.get() + this.totalBusy.get();
    }

    @Override
    public long numberOfIdleConnections() {
        return this.totalIdle.get();
    }

    @Override
    public long numberOfBusyConnections() {
        return this.totalBusy.get();
    }

    @Override
    public long numberOfReclaimableConnections() {
        return this.reclaimableConnections.size();
    }
}

