/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.servicecontext;

import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.encoding.OutputStreamFactory;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.IOException;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class ServiceContextBase {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private byte[] data;
    protected InputStream in = null;

    protected ServiceContextBase() {
    }

    protected ServiceContextBase(InputStream s) {
        this.in = s;
    }

    public abstract int getId();

    public boolean isStale() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(OutputStream s, GIOPVersion gv) throws SystemException {
        boolean isStale = this.isStale();
        if (this.data == null || isStale) {
            EncapsOutputStream os = OutputStreamFactory.newEncapsOutputStream((ORB)s.orb(), gv);
            try {
                os.putEndian();
                this.writeData(os);
                this.data = os.toByteArray();
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    wrapper.ioexceptionDuringStreamClose(e);
                }
            }
        }
        try {
            s.write_long(this.getId());
            s.write_long(this.data.length);
            s.write_octet_array(this.data, 0, this.data.length);
        }
        finally {
            if (isStale) {
                this.data = null;
            }
        }
    }

    protected abstract void writeData(OutputStream var1);

    public String toString() {
        return "ServiceContext[ id=" + this.getId() + " ]";
    }
}

