/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.TranslatedConfigView;

public class GAVConvertor {
    private static final Logger logger = Logger.getLogger("PayaraMicro");

    public Map.Entry<String, URL> getArtefactMapEntry(String GAV, List<URL> repositoryURLs) throws MalformedURLException {
        Map<String, String> GAVMap = this.splitGAV(GAV);
        AbstractMap.SimpleEntry<String, URL> artefactMapEntry = null;
        String relativeURLString = this.constructRelativeURLString(GAVMap);
        URL artefactURL = this.findArtefactURL(repositoryURLs, relativeURLString);
        artefactMapEntry = new AbstractMap.SimpleEntry<String, URL>(GAVMap.get("artefactId"), artefactURL);
        return artefactMapEntry;
    }

    public Map.Entry<String, URL> getArtefactMapEntry(String GAV, Collection<String> repositoryURLs) throws MalformedURLException {
        LinkedList<URL> repoURLs = new LinkedList<URL>();
        for (String url : repositoryURLs) {
            String convertedURL = TranslatedConfigView.expandValue((String)url);
            if (!convertedURL.endsWith("/")) {
                convertedURL = convertedURL + "/";
            }
            repoURLs.add(new URL(convertedURL));
        }
        return this.getArtefactMapEntry(GAV, (List<URL>)repoURLs);
    }

    private Map<String, String> splitGAV(String GAV) throws MalformedURLException {
        String[] splitGAV = GAV.split(",|:");
        HashMap<String, String> GAVMap = new HashMap<String, String>();
        try {
            GAVMap.put("groupId", splitGAV[0].replace('.', '/'));
            GAVMap.put("artefactId", splitGAV[1]);
            GAVMap.put("versionNumber", splitGAV[2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.log(Level.WARNING, "Error converting String \"{0}\" to GAV, make sure it takes the form of groupId,artifactId,version", GAV);
            throw new MalformedURLException(ex.toString() + "\nGAV does not appear to be in the correct format");
        }
        return GAVMap;
    }

    private String constructRelativeURLString(Map<String, String> GAVMap) throws MalformedURLException {
        String artefactFileName = GAVMap.get("artefactId") + "-" + GAVMap.get("versionNumber");
        String relativeURLString = GAVMap.get("groupId") + "/" + GAVMap.get("artefactId") + "/" + GAVMap.get("versionNumber") + "/" + artefactFileName;
        return relativeURLString;
    }

    private URL findArtefactURL(List<URL> repositoryURLs, String relativeURLString) throws MalformedURLException {
        String[] archiveTypes = new String[]{".jar", ".war", ".ear", ".rar"};
        boolean validURLFound = false;
        URL artefactURL = null;
        for (URL repositoryURL : repositoryURLs) {
            for (String archiveType : archiveTypes) {
                try {
                    artefactURL = new URL(repositoryURL, relativeURLString + archiveType);
                    HttpURLConnection httpConnection = (HttpURLConnection)artefactURL.openConnection();
                    String auth = artefactURL.getUserInfo();
                    if (auth != null) {
                        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                        httpConnection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                    }
                    httpConnection.setRequestMethod("HEAD");
                    if (httpConnection.getResponseCode() == 200) {
                        validURLFound = true;
                        break;
                    }
                    logger.log(Level.FINE, "Artefact not found at URL: {0}", artefactURL.toString());
                }
                catch (MalformedURLException ex) {
                    Object[] errorParameters = new String[]{repositoryURL.toString(), relativeURLString, archiveType};
                    logger.log(Level.WARNING, "Error creating URL from repository URL, {0}, relative URL, {1}, and archive type, {2}", errorParameters);
                }
                catch (ProtocolException ex) {
                    logger.log(Level.WARNING, "Error setting request method to \"HEAD\"");
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Error getting HTTP connection response code");
                }
            }
            if (!validURLFound) continue;
            break;
        }
        if (!validURLFound) {
            throw new MalformedURLException("No artefact can be found for relative URL: " + relativeURLString);
        }
        return artefactURL;
    }
}

