/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.CompareFilterCriteria;
import com.sun.data.provider.impl.TableRowDataProvider;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public class ValueExpressionFilterCriteria
extends FilterCriteria {
    private static final long serialVersionUID = 8984072154367845774L;
    protected Locale compareLocale;
    protected boolean matchEqualTo = true;
    protected boolean matchLessThan = false;
    protected boolean matchGreaterThan = false;
    private String valueExpression;
    private Object compareValue;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueExpressionFilterCriteria() {
    }

    public ValueExpressionFilterCriteria(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public ValueExpressionFilterCriteria(Object compareValue) {
        this.compareValue = compareValue;
    }

    public ValueExpressionFilterCriteria(String valueExpression, Object compareValue) {
        this.valueExpression = valueExpression;
        this.compareValue = compareValue;
    }

    public ValueExpressionFilterCriteria(String valueExpression, Object compareValue, boolean matchLessThan, boolean matchEqualTo, boolean matchGreaterThan) {
        this.valueExpression = valueExpression;
        this.compareValue = compareValue;
        this.matchLessThan = matchLessThan;
        this.matchEqualTo = matchEqualTo;
        this.matchGreaterThan = matchGreaterThan;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        Object val = this.getCompareValue();
        StringBuffer sb = new StringBuffer();
        sb.append(this.isInclude() ? "Include [" : "Exclude [");
        sb.append(this.valueExpression != null ? this.valueExpression : "<no value expression>");
        sb.append("] ");
        boolean anyMatches = false;
        if (this.matchLessThan) {
            anyMatches = true;
            sb.append("is less than ");
        }
        if (this.matchEqualTo) {
            if (anyMatches) {
                sb.append("OR ");
            }
            anyMatches = true;
            sb.append("is equal to ");
        }
        if (this.matchGreaterThan) {
            if (anyMatches) {
                sb.append("OR ");
            }
            sb.append("is greater than ");
        }
        sb.append("[" + val + "]");
        return sb.toString();
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String requestMapKey) {
        this.requestMapKey = requestMapKey;
    }

    public void setCompareValue(Object value) {
        this.compareValue = value;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public void setCompareLocale(Locale compareLocale) {
        this.compareLocale = compareLocale;
    }

    public Locale getCompareLocale() {
        return this.compareLocale;
    }

    public void setMatchEqualTo(boolean matchEqualTo) {
        this.matchEqualTo = matchEqualTo;
    }

    public boolean isMatchEqualTo() {
        return this.matchEqualTo;
    }

    public void setMatchLessThan(boolean matchLessThan) {
        this.matchLessThan = matchLessThan;
    }

    public boolean isMatchLessThan() {
        return this.matchLessThan;
    }

    public void setMatchGreaterThan(boolean matchGreaterThan) {
        this.matchGreaterThan = matchGreaterThan;
    }

    public boolean isMatchGreaterThan() {
        return this.matchGreaterThan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(TableDataProvider provider, RowKey row) {
        if (this.valueExpression == null || "".equals(this.valueExpression)) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueExpression valueBinding = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), this.valueExpression, Object.class);
        if (valueBinding == null) {
            return true;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = null;
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = valueBinding.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        int compare = CompareFilterCriteria.compare((Object)value, (Object)this.compareValue, (Locale)this.compareLocale);
        switch (compare) {
            case -1: {
                return this.matchLessThan;
            }
            case 0: {
                return this.matchEqualTo;
            }
            case 1: {
                return this.matchGreaterThan;
            }
        }
        return false;
    }
}

