/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.DB2JDBCConstants;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DB2PersistenceManager
extends JBatchJDBCPersistenceManager
implements DB2JDBCConstants {
    private static final String CLASSNAME = JBatchJDBCPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createDB2Strings;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        this.prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        this.suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException((Throwable)e);
        }
        this.tableNames = this.getSharedTableMap();
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException((Throwable)e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException((Throwable)e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isSchemaValid() throws SQLException {
        boolean result = false;
        logger.entering(CLASSNAME, "isDB2SchemaValid");
        try (Connection conn = this.getConnectionToDefaultSchema();){
            DatabaseMetaData dbmd = conn.getMetaData();
            try (ResultSet rs = dbmd.getSchemas();){
                while (rs.next()) {
                    String schemaname = rs.getString("TABLE_SCHEM");
                    if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                    logger.exiting(CLASSNAME, "isSchemaValid", true);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "isDB2SchemaValid", false);
        return result;
    }

    @Override
    protected void checkTables() throws SQLException {
        logger.entering(CLASSNAME, "checkDB2Tables");
        this.setCreateDB2StringsMap(this.tableNames);
        this.createTableIfNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createDB2Strings.get("DB2__CREATE_TABLE_CHECKPOINTDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_JOBSTATUS"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkDB2Tables");
    }

    @Override
    public boolean checkIfTableExists(DataSource dSource, String tableName, String schemaName) {
        this.dataSource = dSource;
        boolean result = true;
        try (Connection connection = this.dataSource.getConnection();){
            this.schema = schemaName;
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            try (Statement statement = connection.createStatement(1004, 1007);){
                String query = "select name from sysibm.systables where name ='" + tableName.toUpperCase() + "'and type = 'T'";
                try (ResultSet resultSet = statement.executeQuery(query);){
                    int rowcount = this.getTableRowCount(resultSet);
                    if (rowcount == 0 && !resultSet.next()) {
                        result = false;
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.log(Level.FINEST, "Entering {0}.setSchemaOnConnection()", CLASSNAME);
        try (PreparedStatement preparedStatement = connection.prepareStatement("SET SCHEMA ?");){
            preparedStatement.setString(1, this.schema);
            preparedStatement.executeUpdate();
        }
        finally {
            logger.finest("Exiting " + CLASSNAME + ".setSchemaOnConnection()");
        }
    }

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        this.queryStrings = super.getSharedQueryMap(batchConfig);
        this.queryStrings.put("Q_SET_SCHEMA", "SET SCHEMA ?");
        return this.queryStrings;
    }

    private Map<String, String> setCreateDB2StringsMap(Map<String, String> tableNames) {
        this.createDB2Strings = new HashMap<String, String>();
        this.createDB2Strings.put("DB2__CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + tableNames.get("CHECKPOINT_TABLE_KEY") + " (id VARCHAR(512),obj BLOB)");
        this.createDB2Strings.put("DB2_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBINSTANCE_PK PRIMARY KEY,name VARCHAR(512), apptag VARCHAR(512))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBEXECUTION_PK PRIMARY KEY,jobinstanceid BIGINT,createtime\tTIMESTAMP,starttime\tTIMESTAMP,endtime\tTIMESTAMP,updatetime\tTIMESTAMP,parameters\tBLOB,batchstatus VARCHAR(512),exitstatus\t\tVARCHAR(512),CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT STEPEXECUTION_PK PRIMARY KEY,jobexecid\tBIGINT,batchstatus VARCHAR(512),exitstatus\tVARCHAR(512),stepname\tVARCHAR(512),readcount\tINTEGER,writecount\tINTEGER,commitcount INTEGER,rollbackcount INTEGER,readskipcount\tINTEGER,processskipcount INTEGER,filtercount INTEGER,writeskipcount\tINTEGER,startTime TIMESTAMP,endTime TIMESTAMP,persistentData\tBLOB,CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + tableNames.get("JOB_STATUS_TABLE_KEY") + " (id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY NOT NULL,obj BLOB,CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createDB2Strings.put("DB2_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + tableNames.get("STEP_STATUS_TABLE_KEY") + "(id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY NOT NULL,obj BLOB,CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid) ON DELETE CASCADE)");
        this.createDB2Strings.put("chk_index", "CREATE INDEX CHK_INDEX ON " + tableNames.get("CHECKPOINT_TABLE_KEY") + "(id)");
        return this.createDB2Strings;
    }
}

