/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.MySQLJDBCConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class MySqlPersistenceManager
extends JBatchJDBCPersistenceManager
implements MySQLJDBCConstants {
    private static final String CLASSNAME = MySqlPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createMySQLStrings;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        this.prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        this.suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException((Throwable)e);
        }
        this.tableNames = this.getSharedTableMap();
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException((Throwable)e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException((Throwable)e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    @Override
    protected boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isMySQLSchemaValid");
        boolean result = false;
        try (Connection conn = this.getConnectionToDefaultSchema();
             PreparedStatement ps = conn.prepareStatement("SHOW DATABASES like ?");){
            ps.setString(1, this.schema);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = true;
                }
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "isMySQLSchemaValid", false);
        return result;
    }

    @Override
    protected void checkTables() throws SQLException {
        logger.entering(CLASSNAME, "checkMySQLTables");
        this.setCreateMySQLStringsMap(this.tableNames);
        this.createTableIfNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_CHECKPOINTDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_JOBSTATUS"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createMySQLStrings.get("MYSQL_CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkMySQLTables");
    }

    @Override
    public boolean checkIfTableExists(DataSource dSource, String tableName, String schemaName) {
        this.dataSource = dSource;
        boolean result = true;
        try (Connection connection = this.dataSource.getConnection();){
            this.schema = schemaName;
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            try (Statement statement = connection.createStatement(1004, 1007);){
                String query = "select lower(table_schema),lower(table_name) FROM information_schema.tables where lower(table_schema)= '" + this.schema + "' and lower(table_name)= '" + tableName.toLowerCase() + "'";
                try (ResultSet resultSet = statement.executeQuery(query);){
                    int rowcount = this.getTableRowCount(resultSet);
                    if (rowcount == 0 && !resultSet.next()) {
                        result = false;
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        Map<String, String> result = super.getSharedQueryMap(batchConfig);
        if (this.schema.equals("") || this.schema.length() == 0) {
            this.schema = this.setDefaultSchema();
        }
        result.put("Q_SET_SCHEMA", "USE " + this.schema);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.log(Level.FINEST, "Entering {0}.setSchemaOnConnection()", CLASSNAME);
        try (PreparedStatement preparedStatement = connection.prepareStatement("USE " + this.schema);){
            preparedStatement.executeUpdate();
        }
        finally {
            logger.log(Level.FINEST, "Exiting {0}.setSchemaOnConnection()", CLASSNAME);
        }
    }

    private Map<String, String> setCreateMySQLStringsMap(Map<String, String> tableNames) {
        this.createMySQLStrings = new HashMap<String, String>();
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + tableNames.get("CHECKPOINT_TABLE_KEY") + " (id VARCHAR(512),obj BLOB)");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,name VARCHAR(512), apptag VARCHAR(512))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,jobinstanceid BIGINT,createtime TIMESTAMP NULL,starttime TIMESTAMP NULL,endtime TIMESTAMP NULL,updatetime TIMESTAMP NULL,parameters BLOB,batchstatus VARCHAR(512),exitstatus VARCHAR(512),CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,jobexecid BIGINT,batchstatus VARCHAR(512),exitstatus VARCHAR(512),stepname VARCHAR(512),readcount INT,writecount INT,commitcount INT,rollbackcount INT,readskipcount INT,processskipcount INT,filtercount INT,writeskipcount INT,startTime TIMESTAMP NULL,endTime TIMESTAMP NULL,persistentData BLOB,CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + tableNames.get("JOB_STATUS_TABLE_KEY") + "(id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,obj BLOB,CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createMySQLStrings.put("MYSQL_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + tableNames.get("STEP_STATUS_TABLE_KEY") + "(id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,obj BLOB,CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid) ON DELETE CASCADE)");
        return this.createMySQLStrings;
    }
}

