/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.OracleJDBCConstants;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;

public class OraclePersistenceManager
extends JBatchJDBCPersistenceManager
implements OracleJDBCConstants {
    private static final String CLASSNAME = OraclePersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createOracleTableStrings;
    protected Map<String, String> createOracleIndexStrings;
    protected Map<String, String> oracleObjectNames;

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        Map<String, String> result = super.getSharedQueryMap(batchConfig);
        result.put("MOST_RECENT_STEPS_FOR_JOB", "select A.* from " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
        result.put("JOB_OPERATOR_GET_JOB_EXECUTION", "select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
        result.put("JOB_OPERATOR_GET_JOB_EXECUTIONS", "select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
        result.put("GET_JOB_STATUS_FROM_EXECUTIONS", "select A.obj from " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B on A.id = B.jobinstanceid where B.jobexecid = ?");
        return result;
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        this.prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        this.suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException((Throwable)e);
        }
        this.tableNames = this.getSharedTableMap();
        this.oracleObjectNames = this.getOracleObjectsMap();
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException((Throwable)e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkOracleTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException((Throwable)e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isOracleSchemaValid");
        boolean result = false;
        try (Connection conn = this.getConnectionToDefaultSchema();){
            DatabaseMetaData dbmd = conn.getMetaData();
            try (ResultSet rs = dbmd.getSchemas();){
                while (rs.next()) {
                    String schemaname = rs.getString("TABLE_SCHEM");
                    if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                    logger.exiting(CLASSNAME, "isSchemaValid", true);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "isOracleSchemaValid", false);
        return result;
    }

    private void checkOracleTables() throws SQLException {
        this.setOracleTableMap();
        this.setOracleIndexMap();
        logger.entering(CLASSNAME, "checkOracleTables");
        this.createOracleTableNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_CHECKPOINTDATA"));
        if (!this.checkOracleIndexExists(this.oracleObjectNames.get("chk_index"), "chk_index", (String)this.tableNames.get("CHECKPOINT_TABLE_KEY"))) {
            this.executeStatement(this.createOracleIndexStrings.get("CREATE_CHECKPOINTDATA_INDEX"));
        }
        this.createOracleTableNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_JOBINSTANCEDATA"));
        this.createTableIfNotExists(this.oracleObjectNames.get("JOBINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_JOBINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("JOBINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_JOBINSTANCEDATA_TRG"), "JOBINSTANCEDATA_TRG", (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createTableIfNotExists(this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_EXECUTIONINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("EXECUTIONINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_EXECUTIONINSTANCEDATA_TRG"), "EXECUTIONINSTANCEDATA_TRG", (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_STEPINSTANCEDATA"));
        this.createTableIfNotExists(this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_STEPINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_STEPINSTANCEDATA_TRG"), "STEPEXECUTIONINSTANCEDATA_TRG", (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_JOBSTATUS"));
        this.createOracleTableNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkOracleTables");
    }

    @Override
    public void createTables(DataSource dataSource, BatchRuntimeConfiguration batchRuntimeConfiguration) {
        this.dataSource = dataSource;
        this.prefix = batchRuntimeConfiguration.getTablePrefix();
        this.suffix = batchRuntimeConfiguration.getTableSuffix();
        this.schema = batchRuntimeConfiguration.getSchemaName();
        this.tableNames = this.getSharedTableMap();
        this.oracleObjectNames = this.getOracleObjectsMap();
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkOracleTables();
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
    }

    protected void createOracleTableNotExists(String tableName, String createTableStatement) throws SQLException {
        block50: {
            logger.entering(CLASSNAME, "createOracleTableNotExists", new Object[]{tableName, createTableStatement});
            try (Connection conn = this.getConnection();
                 Statement stmt = conn.createStatement(1004, 1007);){
                String query = "SELECT lower(owner),lower(table_name) FROM all_tables where lower(owner) =  '" + this.schema.toLowerCase() + "' and lower(table_name)= '" + tableName.toLowerCase() + "'";
                try (ResultSet rs = stmt.executeQuery(query);){
                    int rowcount = this.getTableRowCount(rs);
                    if (rowcount != 0 || rs.next()) break block50;
                    logger.log(Level.INFO, tableName + " table does not exists. Trying to create it.");
                    try (PreparedStatement ps = conn.prepareStatement(createTableStatement);){
                        ps.executeUpdate();
                    }
                }
            }
            catch (SQLException e) {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
        }
        logger.exiting(CLASSNAME, "createOracleTableNotExists");
    }

    @Override
    public boolean checkIfTableExists(DataSource dSource, String tableName, String schemaName) {
        this.dataSource = dSource;
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();){
            this.schema = schemaName;
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            String query = "select lower(sequence_name) from user_sequences where lower(sequence_name)='" + tableName.toLowerCase() + "'";
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                if (resultSet.next()) {
                    result = true;
                }
            }
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    public void createOracleTriggerNotExists(String triggername, String trgstmt, String defaultTriggername, String tablename) throws SQLException {
        block51: {
            logger.entering(CLASSNAME, "createOracleTableNotExists", new Object[]{triggername, trgstmt, defaultTriggername, tablename});
            boolean triggerexists = false;
            try (Connection conn = this.getConnection();
                 Statement stmt = conn.createStatement();){
                String query = "select lower(trigger_name) from user_triggers  where lower(table_owner)='" + this.schema.toLowerCase() + "' and lower(trigger_name) in ('" + triggername.toLowerCase() + "','" + defaultTriggername.toLowerCase() + "') and lower(table_name)='" + tablename.toLowerCase() + "'";
                try (ResultSet results = stmt.executeQuery(query);){
                    triggerexists = results.next();
                }
                if (triggerexists) break block51;
                var12_17 = null;
                try (Statement ps = conn.createStatement();){
                    ps.executeUpdate(trgstmt);
                }
                catch (Throwable throwable) {
                    var12_17 = throwable;
                    throw throwable;
                }
            }
        }
        logger.exiting(CLASSNAME, "createOracleTriggerNotExists");
    }

    public boolean checkOracleIndexExists(String indexname, String defaultIndexname, String tablename) throws SQLException {
        logger.entering(CLASSNAME, "createOracleIndexNotExists", new Object[]{indexname, defaultIndexname, tablename});
        boolean indexexists = false;
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            String query = "select lower(index_name) from user_indexes where lower(table_owner)='" + this.schema.toLowerCase() + "' and lower(index_name) in ('" + indexname.toLowerCase() + "','" + defaultIndexname.toLowerCase() + "') and lower(table_name)='" + tablename.toLowerCase() + "'";
            try (ResultSet results = stmt.executeQuery(query);){
                indexexists = results.next();
            }
        }
        logger.exiting(CLASSNAME, "createOracleIndexNotExists");
        return indexexists;
    }

    private Map<String, String> setOracleTableMap() {
        this.createOracleTableStrings = new HashMap<String, String>();
        this.createOracleTableStrings.put("CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id VARCHAR(512),obj BLOB)");
        this.createOracleTableStrings.put("CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid NUMBER(19,0) PRIMARY KEY,name VARCHAR2(512), apptag VARCHAR(512))");
        this.createOracleTableStrings.put("CREATE_JOBINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("JOBINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_JOBINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("JOBINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("JOBINSTANCE_SEQ") + ".nextval INTO :new.jobinstanceid FROM dual; END;");
        this.createOracleTableStrings.put("CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid NUMBER(19,0) PRIMARY KEY, jobinstanceid NUMBER(19,0), createtime TIMESTAMP, starttime TIMESTAMP, endtime TIMESTAMP, updatetime TIMESTAMP, parameters BLOB, batchstatus VARCHAR2(512), exitstatus VARCHAR2(512),CONSTRAINT " + this.prefix + "JOBINST_JOBEXEC_FK" + this.suffix + " FOREIGN KEY (jobinstanceid) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createOracleTableStrings.put("CREATE_EXECUTIONINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_EXECUTIONINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("EXECUTIONINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ") + ".nextval INTO :new.jobexecid FROM dual;END;");
        this.createOracleTableStrings.put("CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid NUMBER(19,0) PRIMARY KEY, jobexecid NUMBER(19,0),batchstatus VARCHAR2(512), exitstatus VARCHAR2(512), stepname VARCHAR(512), readcount NUMBER(11, 0), writecount NUMBER(11, 0), commitcount NUMBER(11, 0),rollbackcount NUMBER(11, 0), readskipcount NUMBER(11, 0), processskipcount NUMBER(11, 0), filtercount NUMBER(11, 0), writeskipcount NUMBER(11, 0), startTime TIMESTAMP, endTime TIMESTAMP, persistentData BLOB, CONSTRAINT " + this.prefix + "JOBEXEC_STEPEXEC_FK" + this.suffix + " FOREIGN KEY (jobexecid) REFERENCES " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createOracleTableStrings.put("CREATE_STEPINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_STEPINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ") + ".nextval INTO :new.stepexecid FROM dual;END;");
        this.createOracleTableStrings.put("CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + "(id NUMBER(19,0) PRIMARY KEY,obj BLOB,CONSTRAINT " + this.prefix + "JOBSTATUS_JOBINST_FK" + this.suffix + " FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createOracleTableStrings.put("CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + (String)this.tableNames.get("STEP_STATUS_TABLE_KEY") + "(id NUMBER(19,0) PRIMARY KEY,obj BLOB,CONSTRAINT " + this.prefix + "STEPSTATUS_STEPEXEC_FK" + this.suffix + " FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid) ON DELETE CASCADE)");
        return this.createOracleTableStrings;
    }

    private Map<String, String> setOracleIndexMap() {
        this.createOracleIndexStrings = new HashMap<String, String>();
        this.createOracleIndexStrings.put("CREATE_CHECKPOINTDATA_INDEX", "create index " + this.oracleObjectNames.get("chk_index") + " on " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id)");
        return this.createOracleIndexStrings;
    }

    protected Map<String, String> getOracleObjectsMap() {
        HashMap<String, String> result = new HashMap<String, String>(7);
        result.put("JOBINSTANCE_SEQ", this.prefix + "JOBINSTANCE_SEQ" + this.suffix);
        result.put("EXECUTIONINSTANCE_SEQ", this.prefix + "EXECUTIONINSTANCE_SEQ" + this.suffix);
        result.put("STEPEXECUTIONINSTANCE_SEQ", this.prefix + "STEPEXECUTIONINSTANCE_SEQ" + this.suffix);
        result.put("JOBINSTANCE_TRG", this.prefix + "JOBINSTANCE_TRG" + this.suffix);
        result.put("EXECUTIONINSTANCE_TRG", this.prefix + "EXECUTIONINSTANCE_TRG" + this.suffix);
        result.put("STEPEXECUTIONINSTANCE_TRG", this.prefix + "STEPEXECUTIONINSTANCE_TRG" + this.suffix);
        result.put("chk_index", this.prefix + "chk_index" + this.suffix);
        return result;
    }
}

