/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.PostgresJDBCConstants;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class PostgresPersistenceManager
extends JBatchJDBCPersistenceManager
implements PostgresJDBCConstants {
    private static final String CLASSNAME = PostgresPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createPostgresStrings;

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        Map<String, String> result = super.getSharedQueryMap(batchConfig);
        if (this.schema.equals("") || this.schema.length() == 0) {
            this.schema = this.setDefaultSchema();
        }
        result.put("Q_SET_SCHEMA", "set search_path to " + this.schema);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.log(Level.FINEST, "Entering {0}.setSchemaOnConnection()", CLASSNAME);
        try (PreparedStatement preparedStatement = connection.prepareStatement("set search_path to " + this.schema);){
            preparedStatement.executeUpdate();
        }
        finally {
            logger.log(Level.FINEST, "Exiting {0}.setSchemaOnConnection()", CLASSNAME);
        }
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        this.prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        this.suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException((Throwable)e);
        }
        this.tableNames = this.getSharedTableMap();
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException((Throwable)e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException((Throwable)e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isSchemaValid() throws SQLException {
        boolean result = false;
        try (Connection conn = this.getConnectionToDefaultSchema();){
            logger.entering(CLASSNAME, "isPostgresSchemaValid");
            DatabaseMetaData dbmd = conn.getMetaData();
            try (ResultSet rs = dbmd.getSchemas();){
                while (rs.next()) {
                    String schemaname = rs.getString("TABLE_SCHEM");
                    if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                    logger.exiting(CLASSNAME, "isSchemaValid", true);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "isPostgresSchemaValid", false);
        return result;
    }

    @Override
    protected void checkTables() throws SQLException {
        logger.entering(CLASSNAME, "checkPostgresTables Postgres");
        this.setCreatePostgresStringsMap(this.tableNames);
        this.createTableIfNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_CHECKPOINTDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createTableIfNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_JOBSTATUS"));
        this.createTableIfNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createPostgresStrings.get("POSTGRES_CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkAllTables Postgres");
    }

    @Override
    public boolean checkIfTableExists(DataSource dSource, String tableName, String schemaName) {
        this.dataSource = dSource;
        boolean result = true;
        try (Connection connection = this.dataSource.getConnection();){
            this.schema = schemaName;
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            try (Statement statement = connection.createStatement(1004, 1007);){
                String query = "select lower(table_schema),lower(table_name) FROM information_schema.tables where lower(table_schema)= '" + this.schema + "' and lower(table_name)= '" + tableName.toLowerCase() + "'";
                try (ResultSet resultSet = statement.executeQuery(query);){
                    int rowcount = this.getTableRowCount(resultSet);
                    if (rowcount == 0 && !resultSet.next()) {
                        result = false;
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    private Map<String, String> setCreatePostgresStringsMap(Map<String, String> tableNames) {
        this.createPostgresStrings = new HashMap<String, String>();
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + tableNames.get("CHECKPOINT_TABLE_KEY") + "(id character varying (512),obj bytea)");
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid serial not null PRIMARY KEY,name character varying (512),apptag VARCHAR(512))");
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid serial not null PRIMARY KEY,jobinstanceid bigint not null REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid),createtime timestamp,starttime timestamp,endtime\ttimestamp,updatetime timestamp,parameters bytea,batchstatus character varying (512),exitstatus character varying (512))");
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid\tserial not null PRIMARY KEY,jobexecid\tbigint not null REFERENCES " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid),batchstatus character varying (512),exitstatus\tcharacter varying (512),stepname\tcharacter varying (512),readcount\tinteger,writecount\tinteger,commitcount integer,rollbackcount integer,readskipcount integer,processskipcount integer,filtercount integer,writeskipcount integer,startTime timestamp,endTime timestamp,persistentData\tbytea)");
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + tableNames.get("JOB_STATUS_TABLE_KEY") + "(id\tbigint not null REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid),obj\tbytea)");
        this.createPostgresStrings.put("POSTGRES_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + tableNames.get("STEP_STATUS_TABLE_KEY") + "(id\tbigint not null REFERENCES " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid), obj bytea)");
        return this.createPostgresStrings;
    }

    @Override
    public JobInstance createSubJobInstance(String name, String apptag) {
        JobInstanceImpl jobInstance = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement((String)this.queryStrings.get("CREATE_SUB_JOB_INSTANCE"), 1);){
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long jobInstanceID = rs.getLong(1);
                    jobInstance = new JobInstanceImpl(jobInstanceID);
                    jobInstance.setJobName(name);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return jobInstance;
    }

    @Override
    public JobInstance createJobInstance(String name, String apptag, String jobXml) {
        JobInstanceImpl jobInstance = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement((String)this.queryStrings.get("CREATE_JOB_INSTANCE"), 1);){
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long jobInstanceID = rs.getLong(1);
                    jobInstance = new JobInstanceImpl(jobInstanceID, jobXml);
                    jobInstance.setJobName(name);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return jobInstance;
    }

    @Override
    protected long createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp timestamp) {
        long newJobExecutionId = 0L;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement((String)this.queryStrings.get("CREATE_JOB_EXECUTION_ENTRY"), 1);){
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, timestamp);
            statement.setTimestamp(3, timestamp);
            statement.setString(4, batchStatus.name());
            statement.setObject(5, this.serializeObject(jobParameters));
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    newJobExecutionId = rs.getLong(1);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return newJobExecutionId;
    }

    @Override
    protected StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "createStepExecution", new Object[]{rootJobExecId, batchStatus, exitStatus == null ? "<null>" : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? "<null>" : startTime, endTime == null ? "<null>" : endTime, persistentData == null ? "<null>" : persistentData});
        StepExecutionImpl stepExecution = null;
        String query = (String)this.queryStrings.get("CREATE_STEP_EXECUTION");
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query, 1);){
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, this.serializeObject(persistentData));
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long stepExecutionId = rs.getLong(1);
                    stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                    stepExecution.setStepName(stepName);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "createStepExecution");
        return stepExecution;
    }

    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        logger.entering(CLASSNAME, "markJobStarted", new Object[]{key, startTS});
        int retryMax = Integer.getInteger("fish.payara.jbatch.pg.mjsretrymax", 500);
        int retryDelay = Integer.getInteger("fish.payara.jbatch.pg.mjsretrydelay", 10);
        logger.log(Level.FINER, "fish.payara.jbatch.pg.mjsretrymax = {0}, fish.payara.jbatch.pg.mjsretrydelay = {1} ms", new Object[]{retryMax, retryDelay});
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement((String)this.queryStrings.get("MARK_JOB_STARTED"));){
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setTimestamp(2, startTS);
            statement.setTimestamp(3, startTS);
            statement.setLong(4, key);
            int retryCount = 0;
            while (statement.executeUpdate() < 1 && retryCount++ <= retryMax) {
                PostgresPersistenceManager.sleep(retryDelay);
            }
            logger.log(Level.FINER, "Marking job as started required {0} retries", retryCount);
            if (retryCount >= retryMax) {
                logger.log(Level.WARNING, "Failed to mark job as started after {0} attempts", retryCount);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "markJobStarted");
    }

    private static void sleep(int duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException ie) {
            logger.warning("Thread interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

