/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.File;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ContainerActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;

public class DirectoryActionImpl
extends ContainerActionImpl {
    public DirectoryActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.DIRECTORY;
    }

    @Override
    public String getName() {
        return "Directory Action";
    }

    @Override
    public boolean useStreams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean accept(String resourceName, File resourceFile) {
        return resourceFile != null && resourceFile.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String inputPath, File inputFile, File outputFile) throws TransformException {
        this.startRecording(inputPath);
        try {
            this.setResourceNames(inputPath, inputPath);
            this.transform(".", inputFile, outputFile);
        }
        finally {
            this.stopRecording(inputPath);
        }
    }

    protected void transform(String inputPath, File inputFile, File outputFile) throws TransformException {
        inputPath = inputPath + '/' + inputFile.getName();
        if (inputFile.isDirectory()) {
            if (!outputFile.exists()) {
                outputFile.mkdir();
            }
            for (File childInputFile : inputFile.listFiles()) {
                File childOutputFile = new File(outputFile, childInputFile.getName());
                this.transform(inputPath, childInputFile, childOutputFile);
            }
        } else {
            ActionImpl selectedAction = this.acceptAction(inputPath, inputFile);
            if (selectedAction == null) {
                this.recordUnaccepted(inputPath);
            } else if (!this.select(inputPath)) {
                this.recordUnselected(selectedAction, inputPath);
            } else {
                selectedAction.apply(inputPath, inputFile, outputFile);
                this.recordTransform(selectedAction, inputPath);
            }
        }
    }
}

