/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.ServiceLoaderConfigChangesImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;

public class ServiceLoaderConfigActionImpl
extends ActionImpl {
    public static final String META_INF = "META-INF/";
    public static final String META_INF_SERVICES = "META-INF/services/";

    public ServiceLoaderConfigActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getName() {
        return "Service Config Action";
    }

    @Override
    public ActionType getActionType() {
        return ActionType.SERVICE_LOADER_CONFIG;
    }

    @Override
    protected ServiceLoaderConfigChangesImpl newChanges() {
        return new ServiceLoaderConfigChangesImpl();
    }

    @Override
    public ServiceLoaderConfigChangesImpl getLastActiveChanges() {
        return (ServiceLoaderConfigChangesImpl)super.getLastActiveChanges();
    }

    @Override
    public ServiceLoaderConfigChangesImpl getActiveChanges() {
        return (ServiceLoaderConfigChangesImpl)super.getActiveChanges();
    }

    protected void addUnchangedProvider() {
        this.getActiveChanges().addUnchangedProvider();
    }

    protected void addChangedProvider() {
        this.getActiveChanges().addChangedProvider();
    }

    @Override
    public String getAcceptExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean accept(String resourceName, File resourceFile) {
        return resourceName.contains(META_INF_SERVICES);
    }

    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        String outputName = this.renameInput(inputName);
        if (outputName == null) {
            outputName = inputName;
        } else {
            this.verbose("Service name  [ {} ] -> [ {} ]", inputName, outputName);
        }
        this.setResourceNames(inputName, outputName);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBytes, 0, inputLength);
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(inputReader);
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputLength);
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        BufferedWriter writer = new BufferedWriter(outputWriter);
        try {
            this.transform(reader, writer);
        }
        catch (IOException e) {
            this.error("Failed to transform [ {} ]", e, inputName);
            return null;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            this.error("Failed to flush [ {} ]", e, inputName);
            return null;
        }
        if (!this.hasNonResourceNameChanges()) {
            return null;
        }
        byte[] outputBytes = outputStream.toByteArray();
        return new ByteData(inputName, outputBytes, 0, outputBytes.length);
    }

    protected void transform(BufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine;
            String outputPackageName;
            int dotLocation;
            int poundLocation = inputLine.indexOf(35);
            String inputPackageName = poundLocation != -1 ? inputLine.substring(0, poundLocation) : inputLine;
            if ((inputPackageName = inputPackageName.trim()).isEmpty()) {
                dotLocation = -1;
                outputPackageName = null;
            } else {
                dotLocation = inputPackageName.lastIndexOf(46);
                if (dotLocation == -1) {
                    outputPackageName = null;
                } else if (dotLocation == 0) {
                    outputPackageName = null;
                } else {
                    inputPackageName = inputPackageName.substring(0, dotLocation);
                    outputPackageName = this.replacePackage(inputPackageName);
                }
            }
            if (outputPackageName == null) {
                outputLine = inputLine;
                this.addUnchangedProvider();
            } else {
                int inputPackageStart = inputLine.indexOf(inputPackageName);
                int inputPackageEnd = inputPackageStart + dotLocation;
                outputLine = inputLine.substring(0, inputPackageStart) + outputPackageName + inputLine.substring(inputPackageEnd);
                this.addChangedProvider();
            }
            writer.write(outputLine);
            writer.newLine();
        }
    }

    protected String renameInput(String inputName) {
        String serviceQualifiedName;
        String inputPrefix;
        int lastSlash = inputName.lastIndexOf(47);
        if (lastSlash == -1) {
            inputPrefix = null;
            serviceQualifiedName = inputName;
        } else {
            inputPrefix = inputName.substring(0, lastSlash + 1);
            serviceQualifiedName = inputName.substring(lastSlash + 1);
        }
        int classStart = serviceQualifiedName.lastIndexOf(46);
        if (classStart == -1) {
            return null;
        }
        String packageName = serviceQualifiedName.substring(0, classStart);
        if (packageName.isEmpty()) {
            return null;
        }
        String className = serviceQualifiedName.substring(classStart);
        String outputName = this.replacePackage(packageName);
        if (outputName == null) {
            return null;
        }
        if (inputPrefix == null) {
            return outputName + className;
        }
        return inputPrefix + outputName + className;
    }
}

