/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.transformer.action.impl.ChangesImpl;

public class ServiceLoaderConfigChangesImpl
extends ChangesImpl {
    private int changedProviders;
    private int unchangedProviders;

    public ServiceLoaderConfigChangesImpl() {
        this.clearChanges();
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.changedProviders > 0;
    }

    @Override
    public void clearChanges() {
        this.changedProviders = 0;
        this.unchangedProviders = 0;
        super.clearChanges();
    }

    public void addChangedProvider() {
        ++this.changedProviders;
    }

    public int getChangedProviders() {
        return this.changedProviders;
    }

    public void addUnchangedProvider() {
        ++this.unchangedProviders;
    }

    public int getUnchangedProviders() {
        return this.unchangedProviders;
    }

    @Override
    public void displayVerbose(PrintStream printStream, String inputPath, String outputPath) {
        printStream.printf("Input  [ %s ] as [ %s ]\n", this.getInputResourceName(), inputPath);
        printStream.printf("Output [ %s ] as [ %s ]\n", this.getOutputResourceName(), outputPath);
        printStream.printf("Replacements [ %s ]\n", this.getChangedProviders());
    }

    @Override
    public void displayVerbose(Logger logger, String inputPath, String outputPath) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        logger.log(Level.INFO, "Input  [ {} ] as [ {} ]", new Object[]{this.getInputResourceName(), inputPath});
        logger.log(Level.INFO, "Output [ {} ] as [ {} ]", new Object[]{this.getOutputResourceName(), outputPath});
        logger.log(Level.INFO, "Replacements [ {} ]", new Object[]{this.getChangedProviders()});
    }
}

