/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancerTimer;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.FilterEnhancer;
import com.sun.jdo.api.persistence.enhancer.Resource;
import com.sun.jdo.api.persistence.enhancer.URLClassPath;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataTimer;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.security.tools.PathList;

public class EnhancerClassLoader
extends URLClassLoader {
    public static final String DO_SIMPLE_TIMING = "ByteCodeEnhancer.doSimpleTiming";
    public static final String VERBOSE_LEVEL = "ByteCodeEnhancer.verboseLevel";
    public static final String VERBOSE_LEVEL_QUIET = "quiet";
    public static final String VERBOSE_LEVEL_WARN = "warn";
    public static final String VERBOSE_LEVEL_VERBOSE = "verbose";
    public static final String VERBOSE_LEVEL_DEBUG = "debug";
    private boolean debug = true;
    private boolean doTiming = false;
    private PrintWriter out = new PrintWriter(System.out, true);
    private ByteCodeEnhancer enhancer;
    private JDOMetaData metaData;
    private Properties settings;
    private WeakReference outByteCodeRef;
    private final URLClassPath ucp;
    private final AccessControlContext acc = AccessController.getContext();

    private final void message() {
        if (this.debug) {
            this.out.println();
        }
    }

    private final void message(String s) {
        if (this.debug) {
            this.out.println(s);
        }
    }

    private final void message(Exception e) {
        if (this.debug) {
            String msg = "Exception caught: " + e;
            this.out.println(msg);
            e.printStackTrace(this.out);
        }
    }

    protected EnhancerClassLoader(URL[] urls) {
        super(urls);
        this.ucp = new URLClassPath(urls, null);
        this.checkUCP(urls);
    }

    protected EnhancerClassLoader(URL[] urls, ClassLoader loader) {
        super(urls, loader);
        this.ucp = new URLClassPath(urls, null);
        this.checkUCP(urls);
    }

    public EnhancerClassLoader(String classpath, Properties settings, PrintWriter out) {
        this(PathList.pathToURLs(classpath));
        JDOMetaDataModelImpl metaData = new JDOMetaDataModelImpl(Model.ENHANCER, out);
        this.init(metaData, settings, out);
    }

    public EnhancerClassLoader(URL[] urls, Properties settings, PrintWriter out) {
        this(urls);
        JDOMetaDataModelImpl metaData = new JDOMetaDataModelImpl(Model.ENHANCER, out);
        this.init(metaData, settings, out);
    }

    public EnhancerClassLoader(String classpath, JDOMetaData metaData, Properties settings, PrintWriter out) {
        this(PathList.pathToURLs(classpath));
        this.init(metaData, settings, out);
    }

    public EnhancerClassLoader(URL[] urls, JDOMetaData metaData, Properties settings, PrintWriter out) {
        this(urls);
        this.init(metaData, settings, out);
    }

    @Override
    protected void addURL(URL url) {
        throw new UnsupportedOperationException("Not implemented yet: EnhancerClassLoader.addURL(URL)");
    }

    private void checkUCP(URL[] urls) {
        if (null == urls) {
            throw new IllegalArgumentException("urls == null");
        }
        if (urls.length == 0) {
            throw new IllegalArgumentException("urls.length == 0");
        }
        for (int i = 0; i < urls.length; ++i) {
            super.addURL(urls[i]);
        }
    }

    private void init(JDOMetaData metaData, Properties settings, PrintWriter out) {
        this.out = out;
        String verboseLevel = settings == null ? null : settings.getProperty(VERBOSE_LEVEL);
        this.debug = VERBOSE_LEVEL_DEBUG.equals(verboseLevel);
        this.settings = settings;
        this.metaData = metaData;
        this.enhancer = null;
        if (settings != null) {
            String timing = settings.getProperty(DO_SIMPLE_TIMING);
            this.doTiming = Boolean.valueOf(timing);
        }
        if (this.doTiming) {
            this.metaData = new JDOMetaDataTimer(metaData);
        }
        this.message("EnhancerClassLoader: UCP = {");
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            this.message("    " + urls[i]);
        }
        this.message("}");
        this.message("EnhancerClassLoader: jdoMetaData = " + metaData);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.message();
        this.message("EnhancerClassLoader: loading class: " + name);
        try {
            Class c = null;
            String classPath = name.replace('.', '/');
            if (classPath.startsWith("java/") || classPath.startsWith("javax/sql/") || classPath.startsWith("javax/transaction/") || classPath.startsWith("com/sun/jdo/")) {
                this.message("EnhancerClassLoader: bootstrap class, using parent loader for class: " + name);
                return super.loadClass(name, resolve);
            }
            if (c == null && (c = this.findLoadedClass(name)) != null) {
                this.message("EnhancerClassLoader: class already loaded: " + name);
            }
            if (c == null) {
                c = this.findAndEnhanceClass(name);
            }
            if (c == null) {
                this.message("EnhancerClassLoader: class not found, using parent loader for class: " + name);
                return super.loadClass(name, resolve);
            }
            this.message();
            this.message("EnhancerClassLoader: loaded class: " + name);
            if (resolve) {
                this.resolveClass(c);
            }
            this.message();
            this.message("EnhancerClassLoader: loaded+resolved class: " + name);
            return c;
        }
        catch (RuntimeException e) {
            this.message();
            this.message("EnhancerClassLoader: EXCEPTION SEEN: " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.message();
            this.message("EnhancerClassLoader: EXCEPTION SEEN: " + e);
            throw e;
        }
    }

    private Class findAndEnhanceClass(final String name) throws ClassNotFoundException {
        try {
            if (this.doTiming) {
                Support.timer.push("EnhancerClassLoader.findAndEnhanceClass(String)", "EnhancerClassLoader.findAndEnhanceClass(" + name + ")");
            }
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    Resource res = EnhancerClassLoader.this.ucp.getResource(path, false);
                    if (res != null) {
                        try {
                            return EnhancerClassLoader.this.defineClass(name, res);
                        }
                        catch (IOException e) {
                            String msg = "Exception caught while loading class '" + name + "' : " + e;
                            throw new ClassNotFoundException(msg, e);
                        }
                    }
                    return null;
                }
            }, this.acc);
            return clazz;
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
        finally {
            if (this.doTiming) {
                Support.timer.pop();
            }
        }
    }

    private Class defineClass(String name, Resource res) throws IOException, ClassNotFoundException {
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = res.getManifest();
            if (pkg != null) {
                boolean ok;
                if (pkg.isSealed()) {
                    ok = pkg.isSealed(url);
                } else {
                    boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                }
                if (!ok) {
                    throw new SecurityException("sealing violation");
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        byte[] b = res.getBytes();
        Certificate[] certs = res.getCertificates();
        CodeSource cs = new CodeSource(url, certs);
        String classPath = name.replace('.', '/');
        if (!this.metaData.isTransientClass(classPath)) {
            b = this.enhance(name, b, 0, b.length);
        }
        return this.defineClass(name, b, 0, b.length, cs);
    }

    private byte[] enhance(String name, byte[] data, int off, int len) throws ClassNotFoundException {
        byte[] result;
        try {
            ByteArrayOutputStream outByteCode;
            if (null == this.enhancer) {
                this.enhancer = new FilterEnhancer(this.metaData, this.settings, this.out, null);
                if (this.doTiming) {
                    this.enhancer = new ByteCodeEnhancerTimer(this.enhancer);
                }
            }
            ByteArrayInputStream inByteCode = new ByteArrayInputStream(data, off, len);
            ByteArrayOutputStream byteArrayOutputStream = outByteCode = null == this.outByteCodeRef ? null : (ByteArrayOutputStream)this.outByteCodeRef.get();
            if (null == outByteCode) {
                outByteCode = new ByteArrayOutputStream(10000);
                this.outByteCodeRef = new WeakReference<ByteArrayOutputStream>(outByteCode);
            }
            outByteCode.reset();
            boolean changed = this.enhancer.enhanceClassFile((InputStream)inByteCode, outByteCode);
            result = changed ? outByteCode.toByteArray() : data;
        }
        catch (EnhancerUserException e) {
            this.message(e);
            String msg = "Exception caught while loading class '" + name + "' : " + e;
            throw new ClassNotFoundException(msg, e);
        }
        catch (EnhancerFatalError e) {
            this.message(e);
            String msg = "Exception caught while loading class '" + name + "' : " + e;
            this.enhancer = null;
            throw new ClassNotFoundException(msg, e);
        }
        return result;
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }
}

