/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.requesttracing.jaxrs.client;

import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;

public class SpanPropagator {
    private static final SpanPropagator INSTANCE = new SpanPropagator();
    private static final ThreadLocal<SpanContext> PROPAGATED_CONTEXT = new ThreadLocal();

    SpanPropagator() {
    }

    private SpanContext internalActiveContext() {
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        Tracer tracer = payaraTracingServices.getActiveTracer();
        if (tracer == null) {
            return null;
        }
        Span activeSpan = tracer.activeSpan();
        return activeSpan == null ? null : activeSpan.context();
    }

    public static SpanContext activeContext() {
        return INSTANCE.internalActiveContext();
    }

    public static SpanContext propagateContext(SpanContext context) {
        SpanContext previous = PROPAGATED_CONTEXT.get();
        PROPAGATED_CONTEXT.set(context);
        return previous;
    }

    public static SpanContext propagatedContext() {
        return PROPAGATED_CONTEXT.get();
    }

    public static void clearPropagatedContext() {
        SpanPropagator.propagateContext(null);
    }
}

