/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

public enum HealthCheckType {
    READINESS("/ready", (AnnotationLiteral)new AnnotationLiteral<Readiness>(){}),
    LIVENESS("/live", (AnnotationLiteral)new AnnotationLiteral<Liveness>(){}),
    HEALTH(null, (AnnotationLiteral)new AnnotationLiteral<Health>(){});

    String path;
    AnnotationLiteral literal;

    private HealthCheckType(String path, AnnotationLiteral literal) {
        this.path = path;
        this.literal = literal;
    }

    public AnnotationLiteral getLiteral() {
        return this.literal;
    }

    public static HealthCheckType fromPath(String path) {
        for (HealthCheckType value : HealthCheckType.values()) {
            if (value.path == null || !value.path.equals(path)) continue;
            return value;
        }
        return HEALTH;
    }

    public static HealthCheckType fromQualifiers(Set<Annotation> qualifiers) {
        for (HealthCheckType value : HealthCheckType.values()) {
            if (qualifiers == null || !qualifiers.contains(value.literal)) continue;
            return value;
        }
        throw new IllegalStateException("HealthCheckType not found for : " + qualifiers);
    }
}

