/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.servlet;

import fish.payara.microprofile.healthcheck.HealthCheckService;
import fish.payara.microprofile.healthcheck.HealthCheckType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.internal.api.Globals;

public class HealthCheckServlet
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HealthCheckService healthCheckService = (HealthCheckService)Globals.getDefaultBaseServiceLocator().getService(HealthCheckService.class, new Annotation[0]);
        if (healthCheckService == null) {
            throw new ServletException("Could not find Health Check Service");
        }
        if (!healthCheckService.isEnabled()) {
            response.sendError(403, "MicroProfile Health Check Service is disabled");
            return;
        }
        healthCheckService.performHealthChecks(response, HealthCheckType.fromPath(request.getPathInfo()), request.getParameter("pretty"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "HealthCheck Endpoint";
    }
}

