/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.servlet;

import fish.payara.microprofile.healthcheck.HealthCheckService;
import fish.payara.microprofile.healthcheck.HealthCheckType;
import fish.payara.microprofile.healthcheck.config.MetricsHealthCheckConfiguration;
import fish.payara.microprofile.healthcheck.servlet.HealthCheckServlet;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.microprofile.health.HealthCheck;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.common.util.StringHelper;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;

public class HealthCheckServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckServletContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (ctx.getContextPath().isEmpty()) {
            ServletRegistration reg2;
            Map registrations = ctx.getServletRegistrations();
            MetricsHealthCheckConfiguration configuration = (MetricsHealthCheckConfiguration)Globals.getDefaultHabitat().getService(MetricsHealthCheckConfiguration.class, new Annotation[0]);
            if (!Boolean.parseBoolean(configuration.getEnabled())) {
                return;
            }
            for (ServletRegistration reg2 : registrations.values()) {
                if (!reg2.getClass().equals(HealthCheckServlet.class) && !reg2.getMappings().contains("/" + configuration.getEndpoint())) continue;
                return;
            }
            String virtualServers = configuration.getVirtualServers();
            if (!StringHelper.isEmpty((String)virtualServers) && !Arrays.asList(virtualServers.split(",")).contains(ctx.getVirtualServerName())) {
                return;
            }
            reg2 = ctx.addServlet("microprofile-healthcheck-servlet", HealthCheckServlet.class);
            reg2.addMapping(new String[]{"/" + configuration.getEndpoint() + "/*"});
            if (Boolean.parseBoolean(configuration.getSecurityEnabled())) {
                String[] roles = configuration.getRoles().split(",");
                reg2.setServletSecurity(new ServletSecurityElement(new HttpConstraintElement(ServletSecurity.TransportGuarantee.CONFIDENTIAL, roles)));
                ctx.declareRoles(roles);
            }
        }
        Collection<BeanManager> beanManagers = this.getBeanManagers();
        for (BeanManager beanManager : beanManagers) {
            ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
            HealthCheckService healthCheckService = (HealthCheckService)serviceLocator.getService(HealthCheckService.class, new Annotation[0]);
            InvocationManager invocationManager = (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
            String appName = invocationManager.getCurrentInvocation().getAppName();
            HashSet beans = new HashSet();
            beans.addAll(beanManager.getBeans(HealthCheck.class, new Annotation[]{HealthCheckType.READINESS.getLiteral()}));
            beans.addAll(beanManager.getBeans(HealthCheck.class, new Annotation[]{HealthCheckType.LIVENESS.getLiteral()}));
            beans.addAll(beanManager.getBeans(HealthCheck.class, new Annotation[]{HealthCheckType.HEALTH.getLiteral()}));
            for (Bean bean : beans) {
                HealthCheck healthCheck = (HealthCheck)beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean));
                healthCheckService.registerHealthCheck(appName, healthCheck, HealthCheckType.fromQualifiers(bean.getQualifiers()));
                healthCheckService.registerClassLoader(appName, healthCheck.getClass().getClassLoader());
                LOGGER.log(Level.INFO, "Registered {0} as a HealthCheck for app: {1}", new Object[]{bean.getBeanClass().getCanonicalName(), appName});
            }
        }
    }

    private Collection<BeanManager> getBeanManagers() {
        HashSet<BeanManager> beanManagers = new HashSet<BeanManager>();
        try {
            Map beanDeploymentArchives = Container.instance().beanDeploymentArchives();
            for (Map.Entry entry : beanDeploymentArchives.entrySet()) {
                RootBeanDeploymentArchive rootBeanDeploymentArchive;
                ClassLoader moduleClassLoaderForBDA;
                BeanDeploymentArchive beanDeploymentArchive = (BeanDeploymentArchive)entry.getKey();
                if (!(beanDeploymentArchive instanceof RootBeanDeploymentArchive) || !(moduleClassLoaderForBDA = (rootBeanDeploymentArchive = (RootBeanDeploymentArchive)beanDeploymentArchive).getModuleClassLoaderForBDA()).equals(Thread.currentThread().getContextClassLoader())) continue;
                beanManagers.add((BeanManager)entry.getValue());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return beanManagers;
    }
}

