/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class ConfigConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private final String configurationName;

    public ConfigConfigSource(String configurationName) {
        this.configurationName = configurationName;
    }

    public Map<String, String> getProperties() {
        Config config = this.domainConfiguration.getConfigNamed(this.configurationName);
        HashMap<String, String> result = new HashMap<String, String>();
        if (config != null) {
            List properties = config.getProperty();
            for (Property property : properties) {
                if (!property.getName().startsWith("payara.microprofile.")) continue;
                result.put(property.getName().substring("payara.microprofile.".length()), property.getValue());
            }
        }
        return result;
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getConfigOrdinality());
    }

    public String getValue(String propertyName) {
        String result = null;
        Config config = this.domainConfiguration.getConfigs().getConfigByName(this.configurationName);
        if (config != null) {
            result = config.getPropertyValue("payara.microprofile." + propertyName);
        }
        return result;
    }

    public String getName() {
        return "ServerConfig";
    }

    public boolean setValue(final String propertyName, final String propertyValue) throws TransactionFailure {
        boolean success = false;
        Config config = this.domainConfiguration.getConfigs().getConfigByName(this.configurationName);
        if (config != null) {
            Property p = config.getProperty("payara.microprofile." + propertyName);
            if (p == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                    public Object run(Config config) throws TransactionFailure, PropertyVetoException {
                        Property prop = (Property)config.createChild(Property.class);
                        prop.setName("payara.microprofile." + propertyName);
                        prop.setValue(propertyValue);
                        config.getProperty().add(prop);
                        return null;
                    }
                }, (ConfigBeanProxy)config);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                    public Object run(Property config) throws TransactionFailure, PropertyVetoException {
                        config.setValue(propertyValue);
                        return null;
                    }
                }, (ConfigBeanProxy)p);
            }
            success = true;
        }
        return success;
    }

    public boolean deleteValue(String propertyName) throws TransactionFailure {
        boolean result = false;
        Config config = this.domainConfiguration.getConfigs().getConfigByName(this.configurationName);
        if (config != null) {
            for (Property object : config.getProperty()) {
                if (!("payara.microprofile." + propertyName).equals(object.getName())) continue;
                ConfigSupport.deleteChild((ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)config)), (ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)object)));
                result = true;
            }
        }
        return result;
    }
}

