/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Module;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class ModuleConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private final String configurationName;
    private final String moduleName;

    public ModuleConfigSource(String configurationName, String moduleName) {
        this.configurationName = configurationName;
        this.moduleName = moduleName;
    }

    public Map<String, String> getProperties() {
        Module module;
        Application config = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        HashMap<String, String> result = new HashMap<String, String>();
        if (config != null && (module = config.getModule(this.moduleName)) != null) {
            List properties = module.getProperty();
            for (Property property : properties) {
                if (!property.getName().startsWith("payara.microprofile.")) continue;
                result.put(property.getName().substring("payara.microprofile.".length()), property.getValue());
            }
        }
        return result;
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getModuleOrdinality());
    }

    public String getValue(String propertyName) {
        Module m;
        String result = null;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null && (m = app.getModule(this.moduleName)) != null) {
            result = m.getPropertyValue("payara.microprofile." + propertyName);
        }
        return result;
    }

    public String getName() {
        return "Module";
    }

    public boolean setValue(final String propertyName, final String propertyValue) throws TransactionFailure {
        Module m;
        boolean result = false;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null && (m = app.getModule(this.moduleName)) != null) {
            Property p = m.getProperty("payara.microprofile." + propertyName);
            if (p == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Module>(){

                    public Object run(Module config) throws TransactionFailure, PropertyVetoException {
                        Property prop = (Property)config.createChild(Property.class);
                        prop.setName("payara.microprofile." + propertyName);
                        prop.setValue(propertyValue);
                        config.getProperty().add(prop);
                        return null;
                    }
                }, (ConfigBeanProxy)m);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                    public Object run(Property config) throws TransactionFailure, PropertyVetoException {
                        config.setValue(propertyValue);
                        return null;
                    }
                }, (ConfigBeanProxy)p);
            }
            result = true;
        }
        return result;
    }

    public boolean deleteValue(String propertyName) throws TransactionFailure {
        boolean result = false;
        Application app = this.domainConfiguration.getApplications().getApplication(this.configurationName);
        if (app != null) {
            Module m = app.getModule(this.moduleName);
            for (Property object : m.getProperty()) {
                if (!("payara.microprofile." + propertyName).equals(object.getName())) continue;
                ConfigSupport.deleteChild((ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)m)), (ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)object)));
                result = true;
            }
        }
        return result;
    }
}

