/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.Globals;

public class PasswordAliasConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private final DomainScopedPasswordAliasStore store = Globals.getDefaultHabitat().getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
    private static final String ALIAS_TOKEN = "ALIAS";

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getPasswordOrdinality());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.store != null) {
            Iterator keys = this.store.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                properties.put(key, new String(this.store.get(key)));
            }
        }
        return properties;
    }

    public String getValue(String name) {
        if (name == null || this.store == null) {
            return null;
        }
        String value = null;
        if (this.store.containsKey(name)) {
            value = new String(this.store.get(name));
        } else if (TranslatedConfigView.getAlias((String)name, (String)ALIAS_TOKEN) != null) {
            try {
                value = TranslatedConfigView.getRealPasswordFromAlias((String)name);
            }
            catch (IllegalArgumentException iae) {
                Logger.getLogger(PasswordAliasConfigSource.class.getName()).log(Level.FINEST, iae.getMessage());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
                Logger.getLogger(PasswordAliasConfigSource.class.getName()).log(Level.FINE, "Exception caught reading from Password Alias store", exception);
            }
        }
        return value;
    }

    public String getName() {
        return "Password Alias";
    }
}

