/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SecretsDirConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private Path secretsDir;
    private ConcurrentHashMap<String, String> properties;
    private ConcurrentHashMap<String, FileTime> storedModifiedTimes;

    public SecretsDirConfigSource() {
        this.findFile();
        this.loadProperties();
    }

    SecretsDirConfigSource(Path directory) {
        super(true);
        this.secretsDir = directory;
        this.loadProperties();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getSecretDirOrdinality());
    }

    public String getValue(String property) {
        String result = this.properties.get(property);
        if (result != null) {
            try {
                FileTime ft = this.storedModifiedTimes.get(property);
                Path path = Paths.get(this.secretsDir.toString(), property);
                if (Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).compareTo(ft) > 0) {
                    result = this.readFile(property);
                    this.storedModifiedTimes.put(property, Files.getLastModifiedTime(path, new LinkOption[0]));
                    this.properties.put(property, result);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SecretsDirConfigSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Path path = Paths.get(this.secretsDir.toString(), property);
            if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
                try {
                    result = this.readFile(property);
                    this.storedModifiedTimes.put(property, Files.getLastModifiedTime(path, new LinkOption[0]));
                    this.properties.put(property, result);
                }
                catch (IOException ex) {
                    Logger.getLogger(SecretsDirConfigSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return result;
    }

    public String getName() {
        return "Secrets Directory";
    }

    private void findFile() {
        String instancePath;
        Path test;
        this.secretsDir = Paths.get(this.configService.getMPConfig().getSecretDir(), new String[0]);
        if ((!Files.exists(this.secretsDir, new LinkOption[0]) || !Files.isDirectory(this.secretsDir, new LinkOption[0]) || !Files.isReadable(this.secretsDir)) && Files.exists(test = Paths.get(instancePath = System.getProperty("com.sun.aas.instanceRoot"), this.secretsDir.toString()), new LinkOption[0]) && Files.isDirectory(test, new LinkOption[0]) && Files.isReadable(test)) {
            this.secretsDir = test;
        }
    }

    private String readFile(String name) {
        String result = null;
        if (Files.exists(this.secretsDir, new LinkOption[0]) && Files.isDirectory(this.secretsDir, new LinkOption[0]) && Files.isReadable(this.secretsDir)) {
            try {
                Path file = Paths.get(this.secretsDir.toString(), name);
                if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
                    StringBuilder collector = new StringBuilder();
                    for (String line : Files.readAllLines(file)) {
                        collector.append(line);
                    }
                    result = collector.toString();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SecretsDirConfigSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    private void loadProperties() {
        this.properties = new ConcurrentHashMap();
        this.storedModifiedTimes = new ConcurrentHashMap();
        if (Files.exists(this.secretsDir, new LinkOption[0]) && Files.isDirectory(this.secretsDir, new LinkOption[0]) && Files.isReadable(this.secretsDir)) {
            File[] files;
            for (File file : files = this.secretsDir.toFile().listFiles()) {
                try {
                    if (!file.isFile() || !file.canRead()) continue;
                    this.properties.put(file.getName(), this.readFile(file.getName()));
                    this.storedModifiedTimes.put(file.getName(), Files.getLastModifiedTime(file.toPath(), new LinkOption[0]));
                }
                catch (IOException ex) {
                    Logger.getLogger(SecretsDirConfigSource.class.getName()).log(Level.SEVERE, "Unable to read file in the directory", ex);
                }
            }
        }
    }
}

