/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.converters.BooleanConverter;
import fish.payara.nucleus.microprofile.config.converters.CharacterConverter;
import fish.payara.nucleus.microprofile.config.converters.ClassConverter;
import fish.payara.nucleus.microprofile.config.converters.DoubleConverter;
import fish.payara.nucleus.microprofile.config.converters.FloatConverter;
import fish.payara.nucleus.microprofile.config.converters.InetAddressConverter;
import fish.payara.nucleus.microprofile.config.converters.IntegerConverter;
import fish.payara.nucleus.microprofile.config.converters.LongConverter;
import fish.payara.nucleus.microprofile.config.converters.ShortConverter;
import fish.payara.nucleus.microprofile.config.converters.StringConverter;
import fish.payara.nucleus.microprofile.config.source.ApplicationConfigSource;
import fish.payara.nucleus.microprofile.config.source.ClusterConfigSource;
import fish.payara.nucleus.microprofile.config.source.ConfigConfigSource;
import fish.payara.nucleus.microprofile.config.source.DomainConfigSource;
import fish.payara.nucleus.microprofile.config.source.EnvironmentConfigSource;
import fish.payara.nucleus.microprofile.config.source.JDBCConfigSource;
import fish.payara.nucleus.microprofile.config.source.JNDIConfigSource;
import fish.payara.nucleus.microprofile.config.source.ModuleConfigSource;
import fish.payara.nucleus.microprofile.config.source.PasswordAliasConfigSource;
import fish.payara.nucleus.microprofile.config.source.PayaraExpressionConfigSource;
import fish.payara.nucleus.microprofile.config.source.PayaraServerProperties;
import fish.payara.nucleus.microprofile.config.source.PropertiesConfigSource;
import fish.payara.nucleus.microprofile.config.source.SecretsDirConfigSource;
import fish.payara.nucleus.microprofile.config.source.ServerConfigSource;
import fish.payara.nucleus.microprofile.config.source.SystemPropertyConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSourceService;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="microprofile-config-provider")
@ContractsProvided(value={ConfigProviderResolver.class, ConfigProviderResolverImpl.class})
@RunLevel(value=9)
public class ConfigProviderResolverImpl
extends ConfigProviderResolver {
    private static final String MP_CONFIG_CACHE_DURATION = "mp.config.cache.duration";
    private static final Logger LOG = Logger.getLogger(ConfigProviderResolverImpl.class.getName());
    private static final String METADATA_KEY = "MICROPROFILE_APP_CONFIG";
    private static final String CUSTOM_SOURCES_KEY = "MICROPROFILE_CUSTOM_SOURCES";
    private static final String CUSTOM_CONVERTERS_KEY = "MICROPROFILE_CUSTOM_CONVERTERS";
    private static final String APP_METADATA_KEY = "payara.microprofile.config";
    private static final String APP_EXPRESSION_METADATA_KEY = "payara.microprofile.config.expression";
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ServerContext context;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private MicroprofileConfigConfiguration configuration;
    private Config serverLevelConfig;
    @Inject
    private ExtensionConfigSourceService extensionService;

    public ConfigProviderResolverImpl() {
        LOG.finest("ConfigProviderResolverImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void postConstruct() {
        Class<ConfigProviderResolver> clazz = ConfigProviderResolver.class;
        synchronized (ConfigProviderResolver.class) {
            LOG.log(Level.CONFIG, "Setting global ConfigProviderResolver instance to {0}", (Object)this);
            ConfigProviderResolver.setInstance((ConfigProviderResolver)this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public MicroprofileConfigConfiguration getMPConfig() {
        if (this.configuration == null) {
            LOG.config("getMPConfig() - initialization of the configuration field (not set by @Inject annotation).");
            this.configuration = (MicroprofileConfigConfiguration)this.context.getConfigBean().getConfig().getExtensionByType(MicroprofileConfigConfiguration.class);
        }
        return this.configuration;
    }

    int getCacheDurationSeconds() {
        java.util.Optional cacheDuration;
        if (this.serverLevelConfig != null && (cacheDuration = this.serverLevelConfig.getOptionalValue(MP_CONFIG_CACHE_DURATION, Integer.class)).isPresent()) {
            return (Integer)cacheDuration.get();
        }
        return Integer.parseInt(this.getMPConfig().getCacheDurationSeconds());
    }

    public Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    ApplicationInfo getAppInfo(ClassLoader loader) {
        ApplicationInfo appInfo = null;
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            Set allApplicationNames = this.applicationRegistry.getAllApplicationNames();
            for (String allApplicationName : allApplicationNames) {
                ApplicationInfo testInfo = this.applicationRegistry.get(allApplicationName);
                if (loader.equals(testInfo.getAppClassLoader())) {
                    appInfo = testInfo;
                    return appInfo;
                }
                for (ModuleInfo mi : testInfo.getModuleInfos()) {
                    if (!loader.equals(mi.getModuleClassLoader())) continue;
                    return testInfo;
                }
            }
        } else {
            String appName = currentInvocation.getAppName();
            appInfo = this.applicationRegistry.get(appName);
        }
        if (appInfo != null && loader.equals(appInfo.getAppClassLoader())) {
            return appInfo;
        }
        if (appInfo != null) {
            for (ModuleInfo mInfo : appInfo.getModuleInfos()) {
                if (!loader.equals(mInfo.getModuleClassLoader())) continue;
                return appInfo;
            }
        }
        for (String name : this.applicationRegistry.getAllApplicationNames()) {
            ApplicationInfo testInfo = this.applicationRegistry.get(name);
            if (!testInfo.getClassLoaders().contains(loader) && (testInfo.getAppClassLoader() == null || !testInfo.getAppClassLoader().equals(loader))) continue;
            return testInfo;
        }
        return appInfo;
    }

    Config getConfig(ApplicationInfo appInfo) {
        Config result;
        LOG.log(Level.FINEST, "getConfig(appInfo={0})", appInfo);
        if (appInfo == null) {
            result = this.serverLevelConfig;
            if (result == null) {
                LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
                HashMap converters = new HashMap();
                sources.addAll(this.getDefaultSources());
                sources.addAll(this.extensionService.getExtensionSources());
                converters.putAll(this.getDefaultConverters());
                result = this.serverLevelConfig = new PayaraConfig(sources, converters, TimeUnit.SECONDS.toMillis(this.getCacheDurationSeconds()));
            }
        } else {
            result = (Config)appInfo.getTransientAppMetaData(METADATA_KEY, Config.class);
            if (result == null) {
                ConfigProviderResolverImpl.initialiseApplicationConfig(appInfo);
                LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
                HashMap converters = new HashMap();
                sources.addAll(this.getDefaultSources(appInfo));
                sources.addAll(this.extensionService.getExtensionSources());
                sources.addAll(this.getDiscoveredSources(appInfo));
                converters.putAll(this.getDefaultConverters());
                converters.putAll(this.getDiscoveredConverters(appInfo));
                result = new PayaraConfig(sources, converters, TimeUnit.SECONDS.toMillis(this.getCacheDurationSeconds()));
                appInfo.addTransientAppMetaData(METADATA_KEY, (Object)result);
            }
        }
        return result;
    }

    public Config getConfig(ClassLoader loader) {
        return this.getConfig(this.getAppInfo(loader));
    }

    public ConfigBuilder getBuilder() {
        return new PayaraConfigBuilder(this);
    }

    Config getNamedConfig(String applicationName) {
        Config result = null;
        ApplicationInfo info = this.applicationRegistry.get(applicationName);
        if (info != null && (result = (Config)info.getTransientAppMetaData(METADATA_KEY, Config.class)) == null) {
            result = this.getConfig(info);
        }
        return result;
    }

    private List<ConfigSource> getDefaultSources(String appName, String moduleName) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        String serverName = this.context.getInstanceName();
        String configName = this.context.getConfigBean().getConfig().getName();
        sources.add(new DomainConfigSource());
        sources.add(new ClusterConfigSource());
        sources.add(new ConfigConfigSource(configName));
        sources.add(new ServerConfigSource(serverName));
        sources.add(new EnvironmentConfigSource());
        sources.add(new SystemPropertyConfigSource());
        sources.add(new JNDIConfigSource());
        sources.add(new PayaraServerProperties());
        sources.add(new SecretsDirConfigSource());
        sources.add(new PasswordAliasConfigSource());
        sources.add(new JDBCConfigSource());
        if (appName != null) {
            sources.add(new ApplicationConfigSource(appName));
            sources.add(new ModuleConfigSource(appName, moduleName));
            for (Properties props : this.getDeployedApplicationProperties(appName)) {
                sources.add(new PropertiesConfigSource(props));
            }
            for (Properties props : this.getDeployedApplicationPayaraExpressionConfigProperties(appName)) {
                sources.add(new PayaraExpressionConfigSource(props));
            }
        }
        return sources;
    }

    List<ConfigSource> getDefaultSources() {
        return this.getDefaultSources(null);
    }

    private List<ConfigSource> getDefaultSources(ApplicationInfo appInfo) {
        String appName = null;
        String moduleName = null;
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            if (appInfo == null) {
                appInfo = this.getAppInfo(Thread.currentThread().getContextClassLoader());
            }
            if (appInfo != null) {
                moduleName = appName = appInfo.getName();
            }
        } else {
            appName = currentInvocation.getAppName();
            moduleName = currentInvocation.getModuleName();
        }
        return this.getDefaultSources(appName, moduleName);
    }

    public void registerConfig(Config config, ClassLoader classLoader) {
        ApplicationInfo appInfo = this.getAppInfo(classLoader);
        appInfo.addTransientAppMetaData(METADATA_KEY, (Object)config);
    }

    public void releaseConfig(Config config) {
        ApplicationInfo appInfo = this.getAppInfo(Thread.currentThread().getContextClassLoader());
        appInfo.removeTransientAppMetaData(METADATA_KEY);
    }

    public List<Properties> getDeployedApplicationProperties(String applicationName) {
        List transientAppMetaData;
        ApplicationInfo info = this.applicationRegistry.get(applicationName);
        List result = Collections.emptyList();
        if (info != null && (transientAppMetaData = (List)info.getTransientAppMetaData(APP_METADATA_KEY, LinkedList.class)) != null) {
            result = transientAppMetaData;
        }
        return result;
    }

    public String getDeployedApplicationProperty(String applicationName, String name) {
        String result;
        block1: {
            Properties properties;
            LinkedList metadata;
            result = null;
            ApplicationInfo info = this.applicationRegistry.get(applicationName);
            if (info == null || (metadata = (LinkedList)info.getTransientAppMetaData(APP_METADATA_KEY, LinkedList.class)) == null) break block1;
            Iterator iterator = metadata.iterator();
            while (iterator.hasNext() && (result = (properties = (Properties)iterator.next()).getProperty(name)) == null) {
            }
        }
        return result;
    }

    public List<Properties> getDeployedApplicationPayaraExpressionConfigProperties(String applicationName) {
        List transientAppMetaData;
        ApplicationInfo info = this.applicationRegistry.get(applicationName);
        List result = Collections.emptyList();
        if (info != null && (transientAppMetaData = (List)info.getTransientAppMetaData(APP_EXPRESSION_METADATA_KEY, LinkedList.class)) != null) {
            result = transientAppMetaData;
        }
        return result;
    }

    List<ConfigSource> getDiscoveredSources(ApplicationInfo appInfo) {
        LinkedList<ConfigSource> sources = (LinkedList<ConfigSource>)appInfo.getTransientAppMetaData(CUSTOM_SOURCES_KEY, LinkedList.class);
        if (sources == null) {
            sources = new LinkedList<ConfigSource>();
            ServiceLoader<ConfigSource> serviceLoader = ServiceLoader.load(ConfigSource.class, appInfo.getAppClassLoader());
            for (ConfigSource configSource : serviceLoader) {
                sources.add(configSource);
            }
            ServiceLoader<ConfigSourceProvider> serviceProvideLoader = ServiceLoader.load(ConfigSourceProvider.class, appInfo.getAppClassLoader());
            for (ConfigSourceProvider configSourceProvider : serviceProvideLoader) {
                Iterable configSources = configSourceProvider.getConfigSources(appInfo.getAppClassLoader());
                for (ConfigSource configSource : configSources) {
                    sources.add(configSource);
                }
            }
            appInfo.addTransientAppMetaData(CUSTOM_SOURCES_KEY, sources);
        }
        return sources;
    }

    Map<Class<?>, Converter<?>> getDefaultConverters() {
        HashMap result = new HashMap();
        result.put(Boolean.class, new BooleanConverter());
        result.put(Integer.class, new IntegerConverter());
        result.put(Long.class, new LongConverter());
        result.put(Float.class, new FloatConverter());
        result.put(Double.class, new DoubleConverter());
        result.put(InetAddress.class, new InetAddressConverter());
        result.put(Class.class, new ClassConverter());
        result.put(String.class, new StringConverter());
        result.put(Character.class, new CharacterConverter());
        result.put(Short.class, new ShortConverter());
        return result;
    }

    Map<Class<?>, Converter<?>> getDiscoveredConverters(ApplicationInfo appInfo) {
        HashMap converters = (HashMap)appInfo.getTransientAppMetaData(CUSTOM_CONVERTERS_KEY, Map.class);
        if (converters == null) {
            converters = new HashMap();
            ServiceLoader<Converter> serviceLoader = ServiceLoader.load(Converter.class, appInfo.getAppClassLoader());
            for (Converter converter : serviceLoader) {
                Class<?> type = PayaraConfigBuilder.getTypeForConverter(converter);
                if (type == null) continue;
                converters.put(type, converter);
            }
            appInfo.addTransientAppMetaData(CUSTOM_CONVERTERS_KEY, converters);
        }
        return converters;
    }

    private static void initialiseApplicationConfig(ApplicationInfo info) {
        LinkedList<Properties> appConfigProperties = new LinkedList<Properties>();
        info.addTransientAppMetaData(APP_METADATA_KEY, appConfigProperties);
        try {
            appConfigProperties.addAll(ConfigProviderResolverImpl.getPropertiesFromFile(info.getAppClassLoader(), "META-INF/microprofile-config.properties"));
            appConfigProperties.addAll(ConfigProviderResolverImpl.getPropertiesFromFile(info.getAppClassLoader(), "../../META-INF/microprofile-config.properties"));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        LinkedList<Properties> appPayaraExpressionConfigProperties = new LinkedList<Properties>();
        info.addTransientAppMetaData(APP_EXPRESSION_METADATA_KEY, appPayaraExpressionConfigProperties);
        try {
            appPayaraExpressionConfigProperties.addAll(ConfigProviderResolverImpl.getPropertiesFromFile(info.getAppClassLoader(), "META-INF/payara-expression-config.properties"));
            appPayaraExpressionConfigProperties.addAll(ConfigProviderResolverImpl.getPropertiesFromFile(info.getAppClassLoader(), "../../META-INF/payara-expression-config.properties"));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static List<Properties> getPropertiesFromFile(ClassLoader appClassLoader, String fileName) throws IOException {
        ArrayList<Properties> props = new ArrayList<Properties>();
        Enumeration<URL> resources = appClassLoader.getResources(fileName);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Properties p = new Properties();
            try (InputStream is = url.openStream();){
                p.load(is);
            }
            props.add(p);
        }
        return props;
    }
}

