/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.glassfish.admin.mejb.ListenerRegistry;

public final class MEJBUtility {
    private final MBeanServer mServer = ManagementFactory.getPlatformMBeanServer();
    private final ListenerRegistry listenerRegistry = MEJBUtility._getListenerRegistry();
    private Management mMEJB;
    private static final MEJBUtility INSTANCE = new MEJBUtility();
    public static final String MEJB_NAME_PROP = "mejb.name";
    public static final String MEJB_DEFAULT_NAME = "ejb/mgmt/MEJB";

    private MEJBUtility() {
    }

    public static MEJBUtility getInstance() {
        return INSTANCE;
    }

    public synchronized Management getMEJB() throws RemoteException {
        if (this.mMEJB == null) {
            try {
                InitialContext ic = new InitialContext();
                String ejbName = System.getProperty(MEJB_NAME_PROP, MEJB_DEFAULT_NAME);
                Object objref = ic.lookup(ejbName);
                ManagementHome home = (ManagementHome)PortableRemoteObject.narrow((Object)objref, ManagementHome.class);
                this.mMEJB = home.create();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.mMEJB;
    }

    public MBeanServer getMBeanServer() {
        return this.mServer;
    }

    public ListenerRegistration getListenerRegistry() {
        return this.listenerRegistry;
    }

    private static ListenerRegistry _getListenerRegistry() {
        ListenerRegistry reg = null;
        try {
            reg = new ListenerRegistry(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            reg = new ListenerRegistry(MEJBUtility.class.getName());
        }
        return reg;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, RemoteException {
        if (!this.mServer.isRegistered(name)) {
            System.out.println("addNotificationListener: NOT REGISTERED: " + name);
        } else {
            System.out.println("addNotificationListener: REGISTERED: " + name);
        }
        this.mServer.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        this.mServer.removeNotificationListener(name, listener);
    }
}

