/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DummyRequest;
import org.apache.catalina.core.DummyResponse;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.web.valve.GlassFishValve;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper {
    private static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    private final RequestTracingService requestTracing;
    private final OpenTracingService openTracing;
    private static final ThreadLocal<Boolean> isInSuppressFFNFThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private long available;
    private NotificationBroadcasterSupport broadcaster = null;
    private final AtomicInteger countAllocated = new AtomicInteger(0);
    private int debug;
    private final StandardWrapperFacade facade = new StandardWrapperFacade(this);
    private static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    private volatile Servlet instance;
    protected volatile boolean instanceInitialized;
    private final InstanceSupport instanceSupport = new InstanceSupport(this);
    private String jspFile;
    private int loadOnStartup = -1;
    private final ArrayList<String> mappings = new ArrayList();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final HashMap<String, String> references = new HashMap();
    private String runAs;
    private long sequenceNumber;
    private String servletClassName;
    private Class<? extends Servlet> servletClass;
    private volatile boolean singleThreadModel;
    private boolean unloading;
    private int maxInstances = 20;
    private int nInstances;
    private Stack<Servlet> instancePool;
    protected long unloadDelay = 2000L;
    private boolean isJspServlet;
    private ObjectName jspMonitorON;
    private final StandardWrapperValve swValve = new StandardWrapperValve();
    private long loadTime;
    private int classLoadTime;
    private String description;
    private boolean isAsyncSupported = false;
    private static final Class<?>[] classType = new Class[]{ServletConfig.class};
    private static final Class<?>[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
    private boolean multipartConfigured;
    private String multipartLocation;
    private long multipartMaxFileSize = -1L;
    private long multipartMaxRequestSize = -1L;
    private int multipartFileSizeThreshold = 10240;
    private boolean osgi;

    public StandardWrapper() {
        this.pipeline.setBasic(this.swValve);
        this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        this.openTracing = (OpenTracingService)Globals.getDefaultHabitat().getService(OpenTracingService.class, new Annotation[0]);
        Logger jspLog = Logger.getLogger("org.apache.jasper.servlet.JspServlet");
        if (!(jspLog.getFilter() instanceof NotFoundErrorSupressionFilter)) {
            jspLog.setFilter(new NotFoundErrorSupressionFilter(jspLog.getFilter()));
        }
    }

    @Override
    public long getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", oldAvailable, this.available);
    }

    public int getCountAllocated() {
        return this.countAllocated.get();
    }

    @Override
    public int getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    public String getEngineName() {
        return ((StandardContext)this.getParent()).getEngineName();
    }

    @Override
    public String getInfo() {
        return info;
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    @Override
    public String getJspFile() {
        return this.jspFile;
    }

    @Override
    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
        this.isJspServlet = true;
    }

    @Override
    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup < 0) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", (Object)oldLoadOnStartup, (Object)this.loadOnStartup);
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.support.firePropertyChange("maxInstances", oldMaxInstances, this.maxInstances);
    }

    @Override
    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(this.createMsg("AS-WEB-CORE-00257", new Object[0]));
        }
        if (container instanceof StandardContext) {
            this.unloadDelay = ((StandardContext)container).getUnloadDelay();
            this.notifyContainerListeners = ((StandardContext)container).isNotifyContainerListeners();
        }
        super.setParent(container);
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    @Override
    public void setIsAsyncSupported(boolean isAsyncSupported) {
        this.isAsyncSupported = isAsyncSupported;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    @Override
    public String getServletClassName() {
        return this.servletClassName;
    }

    @Override
    public void setServletClassName(String className) {
        if (className == null) {
            throw new NullPointerException("Null servlet class name");
        }
        if (this.servletClassName != null) {
            throw new IllegalStateException("Wrapper already initialized with servlet instance, class, or name");
        }
        this.servletClassName = className;
        this.support.firePropertyChange("servletClassName", null, this.servletClassName);
        if ("org.apache.jasper.servlet.JspServlet".equals(this.servletClassName)) {
            this.isJspServlet = true;
        }
    }

    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    @Override
    public void setServletClass(Class<? extends Servlet> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Null servlet class");
        }
        if (this.servletClass != null || this.servletClassName != null && !this.servletClassName.equals(clazz.getName())) {
            throw new IllegalStateException("Wrapper already initialized with servlet instance, class, or name");
        }
        this.servletClass = clazz;
        this.servletClassName = clazz.getName();
        if ("org.apache.jasper.servlet.JspServlet".equals(this.servletClassName)) {
            this.isJspServlet = true;
        }
    }

    public Servlet getServlet() {
        return this.instance;
    }

    public void setServlet(Servlet instance) {
        if (instance == null) {
            throw new NullPointerException("Null servlet instance");
        }
        if (this.servletClassName != null) {
            throw new IllegalStateException("Wrapper already initialized with servlet instance, class, or name");
        }
        this.instance = instance;
        this.servletClass = instance.getClass();
        this.servletClassName = this.servletClass.getName();
        if ("org.apache.jasper.servlet.JspServlet".equals(this.servletClassName)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    @Override
    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    @Override
    public String[] getServletMethods() throws ServletException {
        this.loadServletClass();
        if (!HttpServlet.class.isAssignableFrom(this.servletClass)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> allow = new HashSet<String>();
        allow.add("TRACE");
        allow.add("OPTIONS");
        Method[] methods = this.getAllDeclaredMethods(this.servletClass);
        block12: for (int i = 0; methods != null && i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 2 || params[0] != HttpServletRequest.class || params[1] != HttpServletResponse.class) continue;
            switch (method.getName()) {
                case "doGet": {
                    allow.add("GET");
                    allow.add("HEAD");
                    continue block12;
                }
                case "doPost": {
                    allow.add("POST");
                    continue block12;
                }
                case "doPut": {
                    allow.add("PUT");
                    continue block12;
                }
                case "doDelete": {
                    allow.add("DELETE");
                    continue block12;
                }
            }
        }
        return allow.toArray(new String[allow.size()]);
    }

    public boolean isMultipartConfigured() {
        return this.multipartConfigured;
    }

    @Override
    public void setMultipartLocation(String location) {
        this.multipartConfigured = true;
        this.multipartLocation = location;
    }

    @Override
    public String getMultipartLocation() {
        return this.multipartLocation;
    }

    @Override
    public void setMultipartMaxFileSize(long maxFileSize) {
        this.multipartConfigured = true;
        this.multipartMaxFileSize = maxFileSize;
    }

    @Override
    public long getMultipartMaxFileSize() {
        return this.multipartMaxFileSize;
    }

    @Override
    public void setMultipartMaxRequestSize(long maxRequestSize) {
        this.multipartConfigured = true;
        this.multipartMaxRequestSize = maxRequestSize;
    }

    @Override
    public long getMultipartMaxRequestSize() {
        return this.multipartMaxRequestSize;
    }

    @Override
    public void setMultipartFileSizeThreshold(int fileSizeThreshold) {
        this.multipartConfigured = true;
        this.multipartFileSizeThreshold = fileSizeThreshold;
    }

    @Override
    public int getMultipartFileSizeThreshold() {
        return this.multipartFileSizeThreshold;
    }

    protected boolean isOSGi() {
        return this.osgi;
    }

    protected void setOSGi(boolean osgi) {
        this.osgi = osgi;
    }

    @Override
    public synchronized void addValve(GlassFishValve valve) {
        throw new UnsupportedOperationException("Adding valves to wrappers not supported");
    }

    public static Throwable getRootCause(ServletException e) {
        Throwable rootCauseCheck;
        Throwable rootCause = e;
        int loops = 0;
        do {
            ++loops;
            rootCauseCheck = rootCause.getCause();
            if (rootCauseCheck == null) continue;
            rootCause = rootCauseCheck;
        } while (rootCauseCheck != null && loops < 20);
        return rootCause;
    }

    @Override
    public void addChild(Container child) {
        throw new IllegalStateException(this.createMsg("AS-WEB-CORE-00258", new Object[0]));
    }

    @Override
    public void addInitParameter(String name, String value) {
        this.setInitParameter(name, value, true);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInitParameter", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInitParameter(String name, String value, boolean override) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Null servlet init parameter name or value");
        }
        Map<String, String> map = this.parameters;
        synchronized (map) {
            if (override || !this.parameters.containsKey(name)) {
                this.parameters.put(name, value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (initParameters == null) {
            throw new IllegalArgumentException("Null init parameters");
        }
        Map<String, String> map = this.parameters;
        synchronized (map) {
            HashSet<String> conflicts = null;
            for (Map.Entry<String, String> e : initParameters.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) {
                    throw new IllegalArgumentException("Null parameter name or value");
                }
                if (!this.parameters.containsKey(e.getKey())) continue;
                if (conflicts == null) {
                    conflicts = new HashSet<String>();
                }
                conflicts.add(e.getKey());
            }
            if (conflicts != null) {
                return conflicts;
            }
            for (Map.Entry<String, String> e : initParameters.entrySet()) {
                this.setInitParameter(e.getKey(), e.getValue(), true);
            }
            return Collections.emptySet();
        }
    }

    @Override
    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapping(String mapping) {
        ArrayList<String> arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.add(mapping);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMapping", mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getMappings() {
        ArrayList<String> arrayList = this.mappings;
        synchronized (arrayList) {
            return Collections.unmodifiableList(this.mappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecurityReference(String name, String link) {
        HashMap<String, String> hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(name, link);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addSecurityReference", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Servlet allocate() throws ServletException {
        if (this.unloading) {
            throw new ServletException(this.createMsg("AS-WEB-CORE-00259", this.getName()));
        }
        if (!this.singleThreadModel) {
            if (this.instance == null) {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Allocating non-STM instance");
                    }
                    this.instance = this.loadServlet();
                    this.initServlet(this.instance);
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ServletException(this.createMsg("AS-WEB-CORE-00260", new Object[0]), e);
                }
            } else if (!this.instanceInitialized) {
                this.initServlet(this.instance);
            }
            if (!this.singleThreadModel) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Returning non-STM instance");
                }
                this.countAllocated.incrementAndGet();
                return this.instance;
            }
        }
        Stack<Servlet> stack = this.instancePool;
        synchronized (stack) {
            while (this.countAllocated.get() >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        Servlet servlet = this.loadServlet();
                        this.initServlet(servlet);
                        this.instancePool.push(servlet);
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(this.createMsg("AS-WEB-CORE-00260", new Object[0]), e);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Returning allocated STM instance");
            }
            this.countAllocated.incrementAndGet();
            return this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            this.countAllocated.decrementAndGet();
            return;
        }
        Stack<Servlet> stack = this.instancePool;
        synchronized (stack) {
            this.countAllocated.decrementAndGet();
            this.instancePool.push(servlet);
            this.instancePool.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findInitParameter(String name) {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findInitParameters() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return this.parameters.keySet().toArray(new String[this.parameters.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMappings() {
        ArrayList<String> arrayList = this.mappings;
        synchronized (arrayList) {
            return this.mappings.toArray(new String[this.mappings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findSecurityReference(String name) {
        HashMap<String, String> hashMap = this.references;
        synchronized (hashMap) {
            return this.references.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findSecurityReferences() {
        HashMap<String, String> hashMap = this.references;
        synchronized (hashMap) {
            return this.references.keySet().toArray(new String[this.references.size()]);
        }
    }

    public Wrapper findMappingObject() {
        return (Wrapper)this.getMappingObject();
    }

    @Override
    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
        this.initServlet(this.instance);
    }

    private synchronized Servlet loadServlet() throws ServletException {
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        long t1 = System.currentTimeMillis();
        this.loadServletClass();
        Servlet servlet = null;
        try {
            servlet = ((StandardContext)this.getParent()).createServletInstance(this.servletClass);
        }
        catch (ClassCastException e) {
            this.unavailable(null);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00261", this.servletClass.getName()), e);
        }
        catch (Throwable e) {
            this.unavailable(null);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00262", this.servletClass.getName()), e);
        }
        if (!this.isServletAllowed(servlet)) {
            throw new SecurityException(this.createMsg("AS-WEB-CORE-00263", this.servletClass.getName()));
        }
        if (servlet instanceof ContainerServlet && (this.isContainerProvidedServlet(this.servletClass.getName()) || ((Context)this.getParent()).getPrivileged())) {
            ((ContainerServlet)((Object)servlet)).setWrapper(this);
        }
        this.classLoadTime = (int)(System.currentTimeMillis() - t1);
        this.singleThreadModel = servlet instanceof SingleThreadModel;
        if (this.singleThreadModel && this.instancePool == null) {
            this.instancePool = new Stack();
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("load", this);
        }
        this.loadTime = System.currentTimeMillis() - t1;
        return servlet;
    }

    private String createMsg(String key, Object ... arguments) {
        return MessageFormat.format(rb.getString(key), arguments);
    }

    private synchronized void loadServletClass() throws ServletException {
        Loader loader;
        Wrapper jspWrapper;
        if (this.servletClass != null) {
            return;
        }
        String actualClass = this.servletClassName;
        if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
            actualClass = jspWrapper.getServletClassName();
            for (String paramName : jspWrapper.findInitParameters()) {
                if (this.parameters.get(paramName) != null) continue;
                this.parameters.put(paramName, jspWrapper.findInitParameter(paramName));
            }
        }
        if (actualClass == null) {
            this.unavailable(null);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00264", this.getName()));
        }
        if (this.isJspServlet) {
            this.parameters.putIfAbsent("compilerTargetVM", "1.8");
            this.parameters.putIfAbsent("compilerSourceVM", "1.8");
        }
        if ((loader = this.getLoader()) == null) {
            this.unavailable(null);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00265", this.getName()));
        }
        ClassLoader classLoader = loader.getClassLoader();
        if (this.isContainerProvidedServlet(actualClass) && !((Context)this.getParent()).getPrivileged()) {
            classLoader = this.getClass().getClassLoader();
        }
        Class<Object> clazz = null;
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final ClassLoader fclassLoader = classLoader;
                final String factualClass = actualClass;
                try {
                    clazz = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                        @Override
                        public Class run() throws Exception {
                            if (fclassLoader != null) {
                                return fclassLoader.loadClass(factualClass);
                            }
                            return Class.forName(factualClass);
                        }
                    });
                }
                catch (PrivilegedActionException pax) {
                    Exception ex = pax.getException();
                    if (ex instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)ex;
                    }
                    this.getServletContext().log(this.createMsg("AS-WEB-CORE-00273", fclassLoader, factualClass), ex);
                }
            } else {
                clazz = classLoader != null ? classLoader.loadClass(actualClass) : Class.forName(actualClass);
            }
        }
        catch (ClassNotFoundException e) {
            this.unavailable(null);
            this.getServletContext().log(this.createMsg("AS-WEB-CORE-00273", classLoader, actualClass), e);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00266", actualClass), e);
        }
        if (clazz == null) {
            this.unavailable(null);
            throw new ServletException(this.createMsg("AS-WEB-CORE-00266", actualClass));
        }
        this.servletClass = this.castToServletClass(clazz);
    }

    private Class<? extends Servlet> castToServletClass(Class<?> clazz) {
        return clazz;
    }

    private void initServlet(Servlet servlet) throws ServletException {
        if (this.instanceInitialized && !this.singleThreadModel) {
            return;
        }
        try {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.BEFORE_INIT_EVENT, servlet);
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                Object[] initType = new Object[]{this.facade};
                SecurityUtil.doAsPrivilege("init", servlet, classType, initType);
                initType = null;
            } else {
                servlet.init(this.facade);
            }
            this.instanceInitialized = true;
            if (this.loadOnStartup >= 0 && this.jspFile != null) {
                String[] allowedMethod;
                DummyRequest req = new DummyRequest();
                req.setServletPath(this.jspFile);
                req.setQueryString("jsp_precompile=true");
                String allowedMethods = this.parameters.get("httpMethods");
                if (allowedMethods != null && allowedMethods.length() > 0 && (allowedMethod = allowedMethods.split(",")).length > 0) {
                    req.setMethod(allowedMethod[0].trim());
                }
                DummyResponse res = new DummyResponse();
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    Object[] serviceType = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", servlet, classTypeUsedInService, serviceType);
                } else {
                    servlet.service(req, res);
                }
            }
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet);
        }
        catch (UnavailableException f) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, (Throwable)f);
            this.unavailable(f);
            throw f;
        }
        catch (ServletException f) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, (Throwable)f);
            throw f;
        }
        catch (Throwable f) {
            this.getServletContext().log("StandardWrapper.Throwable", f);
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet, f);
            throw new ServletException(MessageFormat.format(rb.getString("AS-WEB-CORE-00267"), this.getName()), f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service(ServletRequest request, ServletResponse response, Servlet servlet) throws IOException, ServletException {
        InstanceSupport supp = this.getInstanceSupport();
        try {
            RequestFacadeHelper reqFacHelper;
            supp.fireInstanceEvent(InstanceEvent.EventType.BEFORE_SERVICE_EVENT, servlet, request, response);
            if (!this.isAsyncSupported() && (reqFacHelper = RequestFacadeHelper.getInstance(request)) != null) {
                reqFacHelper.disableAsyncSupport();
            }
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] serviceType = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", servlet, classTypeUsedInService, serviceType, principal);
                } else {
                    RequestTraceSpan span = null;
                    if (this.requestTracing.isRequestTracingEnabled()) {
                        if (servlet instanceof ServletContainer) {
                            span = this.constructWebServiceRequestSpan((HttpServletRequest)request);
                        } else if (servlet instanceof Servlet) {
                            span = this.constructServletRequestSpan((HttpServletRequest)request, servlet);
                        }
                    }
                    try {
                        if (this.isJspServlet) {
                            isInSuppressFFNFThread.set(true);
                        }
                        servlet.service((HttpServletRequest)request, (HttpServletResponse)response);
                    }
                    finally {
                        String applicationName = this.openTracing.getApplicationName((InvocationManager)Globals.getDefaultBaseServiceLocator().getService(InvocationManager.class, new Annotation[0]));
                        if (this.openTracing.getTracer(applicationName).activeSpan() != null) {
                            this.openTracing.getTracer(applicationName).activeSpan().setTag(Tags.HTTP_STATUS.getKey(), Integer.toString(((HttpServletResponse)response).getStatus()));
                            this.openTracing.getTracer(applicationName).activeSpan().finish();
                        }
                        if (this.requestTracing.isRequestTracingEnabled() && span != null) {
                            span.addSpanTag("ResponseStatus", Integer.toString(((HttpServletResponse)response).getStatus()));
                            this.requestTracing.traceSpan(span);
                        }
                        isInSuppressFFNFThread.set(false);
                    }
                }
            } else {
                servlet.service(request, response);
            }
            supp.fireInstanceEvent(InstanceEvent.EventType.AFTER_SERVICE_EVENT, servlet, request, response);
        }
        catch (IOException | Error | RuntimeException | ServletException e) {
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).setStatus(500);
            }
            supp.fireInstanceEvent(InstanceEvent.EventType.AFTER_SERVICE_EVENT, servlet, request, response, e);
            throw e;
        }
        catch (Throwable e) {
            ((HttpServletResponse)response).setStatus(500);
            supp.fireInstanceEvent(InstanceEvent.EventType.AFTER_SERVICE_EVENT, servlet, request, response, e);
            throw new ServletException(rb.getString("AS-WEB-CORE-00268"), e);
        }
    }

    private RequestTraceSpan constructWebServiceRequestSpan(HttpServletRequest httpServletRequest) {
        RequestTraceSpan span = new RequestTraceSpan("processWebserviceRequest");
        span.addSpanTag("URL", httpServletRequest.getRequestURL().toString());
        Enumeration<String> headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            span.addSpanTag(headerName, Collections.list(httpServletRequest.getHeaders(headerName)).toString());
        }
        span.addSpanTag("Method", httpServletRequest.getMethod());
        return span;
    }

    private RequestTraceSpan constructServletRequestSpan(HttpServletRequest httpServletRequest, Servlet serv) {
        RequestTraceSpan span = new RequestTraceSpan("processServletRequest");
        span.addSpanTag("URL", httpServletRequest.getRequestURL().toString());
        Enumeration<String> headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            span.addSpanTag(headerName, Collections.list(httpServletRequest.getHeaders(headerName)).toString());
        }
        span.addSpanTag("Method", httpServletRequest.getMethod());
        span.addSpanTag("QueryString", httpServletRequest.getQueryString());
        span.addSpanTag("Class", serv.getClass().getCanonicalName());
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInitParameter(String name) {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            this.parameters.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeInitParameter", name);
        }
    }

    @Override
    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMapping(String mapping) {
        ArrayList<String> arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.remove(mapping);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMapping", mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSecurityReference(String name) {
        HashMap<String, String> hashMap = this.references;
        synchronized (hashMap) {
            this.references.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeSecurityReference", name);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString()).append(".");
        }
        return sb.append("StandardWrapper[").append(this.getName()).append("]").toString();
    }

    @Override
    public void unavailable(UnavailableException unavailable) {
        this.getServletContext().log(this.createMsg("AS-WEB-CORE-00269", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    @Override
    public synchronized void unload() throws ServletException {
        if (!this.singleThreadModel && this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated.get() > 0) {
            long delay = this.unloadDelay / 20L;
            for (int nRetries = 0; nRetries < 21 && this.countAllocated.get() > 0; ++nRetries) {
                if (nRetries % 10 == 0 && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00270", new Object[]{this.countAllocated.toString(), this.instance.getClass().getName()});
                }
                try {
                    this.wait(delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.instance.getClass().getClassLoader();
        try {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.BEFORE_DESTROY_EVENT, this.instance);
            Thread.currentThread().setContextClassLoader(classLoader);
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                SecurityUtil.doAsPrivilege("destroy", this.instance);
                SecurityUtil.remove(this.instance);
            } else {
                this.instance.destroy();
            }
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_DESTROY_EVENT, this.instance);
        }
        catch (Throwable t) {
            this.instanceSupport.fireInstanceEvent(InstanceEvent.EventType.AFTER_DESTROY_EVENT, this.instance, t);
            this.instance = null;
            this.instancePool = null;
            this.nInstances = 0;
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("unload", this);
            }
            this.unloading = false;
            throw new ServletException(this.createMsg("AS-WEB-CORE-00271", this.getName()), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                while (!this.instancePool.isEmpty()) {
                    if (SecurityUtil.executeUnderSubjectDoAs()) {
                        SecurityUtil.doAsPrivilege("destroy", this.instancePool.pop());
                        SecurityUtil.remove(this.instance);
                        continue;
                    }
                    this.instancePool.pop().destroy();
                }
            }
            catch (Throwable t) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                if (this.notifyContainerListeners) {
                    this.fireContainerEvent("unload", this);
                }
                throw new ServletException(this.createMsg("AS-WEB-CORE-00271", this.getName()), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.singleThreadModel = false;
        this.unloading = false;
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("unload", this);
        }
    }

    @Override
    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInitParameters() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return Collections.unmodifiableMap(this.parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> getInitParameterNames() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return new Enumerator<String>(this.parameters.keySet());
        }
    }

    @Override
    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    @Override
    public String getServletName() {
        return this.getName();
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    private boolean isContainerProvidedServlet(String classname) {
        if (classname.startsWith("org.apache.catalina.")) {
            return true;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
            return ContainerServlet.class.isAssignableFrom(clazz);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isServletAllowed(Object servlet) {
        if (servlet instanceof ContainerServlet) {
            return ((Context)this.getParent()).getPrivileged() || servlet.getClass().getName().equals("org.apache.catalina.servlets.InvokerServlet");
        }
        return true;
    }

    @Override
    protected String logName() {
        StringBuilder sb = new StringBuilder("StandardWrapper[");
        if (this.getParent() != null) {
            sb.append(this.getParent().getName());
        } else {
            sb.append("null");
        }
        return sb.append(':').append(this.getName()).append(']').toString();
    }

    private Method[] getAllDeclaredMethods(Class<?> c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (thisMethods.length == 0) {
            return parentMethods;
        }
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    @Override
    public void start() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        super.start();
        if (this.oname != null) {
            this.registerJMX((StandardContext)this.getParent());
        }
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.getServletContext().log(this.createMsg("AS-WEB-CORE-00272", this.getName()), e);
        }
        super.stop();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        if (this.oname != null) {
            notification = new Notification("j2ee.object.deleted", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
    }

    protected void registerJMX(StandardContext ctx) {
        block8: {
            String onameStr;
            String webMod;
            String domain;
            block7: {
                String parentName = ctx.getEncodedPath();
                parentName = "".equals(parentName) ? "/" : parentName;
                String hostName = ctx.getParent().getName();
                hostName = hostName == null ? "DEFAULT" : hostName;
                domain = ctx.getDomain();
                webMod = "//" + hostName + parentName;
                onameStr = domain + ":j2eeType=Servlet,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
                if (this.isOSGi()) {
                    onameStr = onameStr + ",osgi=true";
                }
                try {
                    this.controller = this.oname = new ObjectName(onameStr);
                    if (this.getObjectName() != null) {
                        Notification notification = new Notification("j2ee.object.created", this, this.sequenceNumber++);
                        this.sendNotification(notification);
                    }
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block7;
                    log.log(Level.INFO, "Error registering servlet with jmx " + this, ex);
                }
            }
            if (this.isJspServlet) {
                onameStr = domain + ":type=JspMonitor,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
                try {
                    this.jspMonitorON = new ObjectName(onameStr);
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block8;
                    log.log(Level.INFO, "Error registering JSP monitoring with jmx " + this.instance, ex);
                }
            }
        }
    }

    public void sendNotification(Notification notification) {
        if (this.broadcaster == null) {
            this.broadcaster = ((StandardEngine)this.getParent().getParent().getParent()).getService().getBroadcaster();
        }
        if (this.broadcaster != null) {
            this.broadcaster.sendNotification(notification);
        }
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    private static class NotFoundErrorSupressionFilter
    implements Filter {
        private final Filter oldFilter;

        public NotFoundErrorSupressionFilter(Filter oldFilter) {
            this.oldFilter = oldFilter;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            boolean rv = true;
            if (((Boolean)isInSuppressFFNFThread.get()).booleanValue()) {
                boolean bl = rv = !record.getMessage().startsWith("PWC6117: File");
            }
            if (this.oldFilter != null) {
                rv &= this.oldFilter.isLoggable(record);
            }
            return rv;
        }
    }
}

