/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DnsDiscoveryService
implements DiscoveryService {
    private static final String DEFAULT_PORT = "4900";
    private static final String A_RECORD = "A";
    private static final Logger LOGGER = Logger.getLogger(DnsDiscoveryService.class.getName());
    private final String[] settings;

    public DnsDiscoveryService(String[] settings) {
        this.settings = settings;
    }

    public void start() {
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        LOGGER.log(Level.FINER, "Starting Domain Node Discovery");
        LinkedList<DiscoveryNode> nodes = new LinkedList<DiscoveryNode>();
        for (String host : this.settings) {
            String port;
            String hostname;
            int colon = host.indexOf(58);
            if (colon == -1) {
                hostname = host;
                port = DEFAULT_PORT;
            } else {
                hostname = host.substring(0, colon);
                port = host.substring(colon + 1);
            }
            try {
                InetAddress[] addresses;
                for (InetAddress inetAddress : addresses = InetAddress.getAllByName(hostname)) {
                    if (inetAddress.isLoopbackAddress()) continue;
                    LOGGER.log(Level.FINE, "Adding Node {0}", inetAddress);
                    nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(inetAddress.getHostAddress(), Integer.valueOf(port).intValue())));
                }
            }
            catch (UnknownHostException ex) {
                LOGGER.log(Level.FINEST, ex.getMessage());
                try {
                    InitialDirContext urlContext = new InitialDirContext();
                    Attributes attributes = urlContext.getAttributes("dns:/" + hostname, new String[]{A_RECORD});
                    NamingEnumeration<?> record = attributes.get(A_RECORD).getAll();
                    while (record.hasMore()) {
                        String string = record.next().toString();
                        LOGGER.log(Level.FINE, "Adding Node {0}", string);
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(string, Integer.valueOf(port).intValue())));
                    }
                }
                catch (UnknownHostException | NamingException ex1) {
                    LOGGER.log(Level.WARNING, "Unable to find DNS record for {0}", hostname);
                }
            }
        }
        return nodes;
    }

    public void destroy() {
    }

    public Map<String, Object> discoverLocalMetadata() {
        return Collections.emptyMap();
    }
}

