/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.spi.MemberAddressProvider;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;

public class MemberAddressPicker
implements MemberAddressProvider {
    private final ServerEnvironment env;
    private final HazelcastRuntimeConfiguration config;
    private final HazelcastConfigSpecificConfiguration localConfig;
    private InetSocketAddress bindAddress;
    private InetSocketAddress publicAddress;
    private static final Logger logger = Logger.getLogger(MemberAddressPicker.class.getName());

    MemberAddressPicker(ServerEnvironment env, HazelcastRuntimeConfiguration config, HazelcastConfigSpecificConfiguration localConfig) {
        this.env = env;
        this.config = config;
        this.localConfig = localConfig;
        this.findAppropriateInterfaces();
    }

    public InetSocketAddress getBindAddress(EndpointQualifier endpointQualifier) {
        return this.getBindAddress();
    }

    public InetSocketAddress getPublicAddress(EndpointQualifier endpointQualifier) {
        return this.getPublicAddress();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public InetSocketAddress getPublicAddress() {
        if (this.publicAddress != null) {
            return this.publicAddress;
        }
        return this.bindAddress;
    }

    private void findAppropriateInterfaces() {
        NetworkInterface intf;
        if (this.localConfig.getPublicAddress() != null && !this.localConfig.getPublicAddress().isEmpty()) {
            String[] address = this.localConfig.getPublicAddress().split(":");
            this.publicAddress = address.length > 1 ? new InetSocketAddress(address[0], Integer.parseInt(address[1])) : new InetSocketAddress(address[0], Integer.parseInt(this.config.getStartPort()));
        }
        logger.fine("Finding an appropriate address for Hazelcast to use");
        int port = 0;
        if (this.env.isDas() && !this.env.isMicro()) {
            port = new Integer(this.config.getDasPort());
            if (this.config.getDASPublicAddress() != null && !this.config.getDASPublicAddress().isEmpty()) {
                this.publicAddress = new InetSocketAddress(this.config.getDASPublicAddress(), port);
            }
            if (this.config.getDASBindAddress() != null && !this.config.getDASBindAddress().isEmpty()) {
                this.bindAddress = new InetSocketAddress(this.config.getDASBindAddress(), port);
                logger.log(Level.FINE, "Bind address is specified in the configuration so we will use that {0}", this.bindAddress);
                return;
            }
        }
        HashSet<NetworkInterface> possibleInterfaces = new HashSet<NetworkInterface>();
        try {
            logger.fine("No address in configuration so let's find one");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                intf = interfaces.nextElement();
                logger.log(Level.FINE, "Found Network Interface {0}", new Object[]{intf.getName()});
                if (!(!intf.isUp() || intf.isLoopback() || intf.isVirtual() || intf.getName().contains("docker0") || intf.getDisplayName().contains("Teredo") || intf.getInterfaceAddresses().size() <= 0)) {
                    logger.log(Level.FINE, "Adding interface {0} as a possible interface", intf.getName());
                    possibleInterfaces.add(intf);
                    continue;
                }
                logger.fine("Ignoring down, docker or loopback interface " + intf.getName());
            }
        }
        catch (SocketException socketException) {
            logger.log(Level.WARNING, "There was a problem determining the network interfaces on this machine", socketException);
        }
        if (possibleInterfaces.size() >= 1) {
            InetAddress chosenAddress = null;
            intf = (NetworkInterface)possibleInterfaces.iterator().next();
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses.hasMoreElements() && !((chosenAddress = addresses.nextElement()) instanceof Inet4Address)) {
            }
            logger.log(Level.FINE, "Picked address {0}", chosenAddress);
            this.bindAddress = new InetSocketAddress(chosenAddress, port);
        }
        if (this.bindAddress == null) {
            try {
                logger.log(Level.FINE, "Could not find an appropriate address by searching falling back to local host");
                this.bindAddress = new InetSocketAddress(InetAddress.getLocalHost(), port);
            }
            catch (UnknownHostException ex) {
                logger.log(Level.FINE, "Could not find local host, falling back to loop back address");
                this.bindAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            }
        }
    }
}

