/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.internal.serialization.impl.JavaDefaultSerializers;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import org.glassfish.internal.api.JavaEEContextUtil;

public class PayaraHazelcastSerializer
implements StreamSerializer<Object> {
    private final JavaEEContextUtil ctxUtil;
    private final StreamSerializer<Object> delegate;

    public PayaraHazelcastSerializer(JavaEEContextUtil ctxUtil, StreamSerializer<?> delegate) {
        this.ctxUtil = ctxUtil;
        this.delegate = delegate != null ? delegate : new JavaDefaultSerializers.JavaSerializer(true, false, null);
    }

    public void write(ObjectDataOutput out, Object object) throws IOException {
        this.delegate.write(out, (Object)this.ctxUtil.getInvocationComponentId());
        this.delegate.write(out, object);
    }

    public Object read(ObjectDataInput in) throws IOException {
        String componentId = (String)this.delegate.read(in);
        this.ctxUtil.setInstanceComponentId(componentId);
        try (JavaEEContextUtil.Context ctx = this.ctxUtil.setApplicationClassLoader();){
            Object object = this.delegate.read(in);
            return object;
        }
    }

    public int getTypeId() {
        return 1;
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

