/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.internal.deployment.DeploymentTargetResolver;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-hazelcast-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.hazelcast.configuration")
@TargetType(value={CommandTarget.CONFIG, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-hazelcast-configuration", description="Set Hazelcast Configuration")})
public class SetHazelcastConfiguration
implements AdminCommand,
DeploymentTargetResolver {
    @Inject
    protected Logger logger;
    @Inject
    protected HazelcastCore hazelcast;
    @Inject
    private Domain domain;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="domain")
    String target;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="hazelcastConfigurationFile", shortName="f", optional=true)
    private String configFile;
    @Param(name="startPort", optional=true)
    private String startPort;
    @Param(name="publicAddress", optional=true)
    private String publicAddress;
    @Param(name="dasPublicAddress", optional=true)
    private String dasPublicAddress;
    @Param(name="dasBindAddress", optional=true)
    private String dasBindAddress;
    @Param(name="dasPort", optional=true)
    private String dasPort;
    @Param(name="clusterMode", optional=true, acceptableValues="domain,multicast,tcpip,dns,kubernetes")
    private String clusterMode;
    @Param(name="tcpIpMembers", optional=true)
    private String tcpipMembers;
    @Param(name="dnsMembers", optional=true)
    private String dnsMembers;
    @Param(name="interfaces", optional=true)
    private String interfaces;
    @Param(name="multicastGroup", shortName="g", optional=true)
    private String multiCastGroup;
    @Param(name="multicastPort", optional=true)
    private String multicastPort;
    @Param(name="clusterName", optional=true)
    private String hzClusterName;
    @Param(name="clusterPassword", optional=true)
    private String hzClusterPassword;
    @Param(name="jndiName", shortName="j", optional=true)
    private String jndiName;
    @Param(name="cacheManagerJndiName", optional=true)
    private String cacheManagerJndiName;
    @Param(name="cachingProviderJndiName", optional=true)
    private String cachingProviderJndiName;
    @Param(name="executorPoolSize", optional=true)
    private String executorPoolSize;
    @Param(name="executorQueueCapacity", optional=true)
    private String executorQueueCapacity;
    @Param(name="scheduledExecutorPoolSize", optional=true)
    private String scheduledExecutorPoolSize;
    @Param(name="scheduledExecutorQueueCapacity", optional=true)
    private String scheduledExecutorQueueCapacity;
    @Param(name="licenseKey", shortName="lk", optional=true)
    private String licenseKey;
    @Param(name="lite", optional=true)
    private Boolean lite;
    @Param(name="hostawarePartitioning", optional=true)
    private Boolean hostawarePartitioning;
    @Param(name="memberName", optional=true)
    private String memberName;
    @Param(name="memberGroup", optional=true)
    private String memberGroup;
    @Param(name="kubernetesNamespace", optional=true, alias="kubernetesnamespace")
    private String kubernetesNamespace;
    @Param(name="kubernetesServiceName", optional=true, alias="kubernetesservicename")
    private String kubernetesServiceName;
    @Param(name="autoIncrementPort", optional=true)
    private Boolean autoIncrementPort;
    @Param(name="configSpecificDataGridStartPort", optional=true, alias="configspecificdatagridstartport")
    private String configSpecificDataGridStartPort;
    @Param(name="encryptDatagrid", optional=true, alias="encryptdatagrid")
    private Boolean encryptDatagrid;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (!this.validate(actionReport)) {
            return;
        }
        HazelcastRuntimeConfiguration hazelcastRuntimeConfiguration = (HazelcastRuntimeConfiguration)this.domain.getExtensionByType(HazelcastRuntimeConfiguration.class);
        if (hazelcastRuntimeConfiguration != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastRuntimeConfiguration>(){

                    public Object run(HazelcastRuntimeConfiguration hazelcastRuntimeConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (SetHazelcastConfiguration.this.startPort != null) {
                            hazelcastRuntimeConfigurationProxy.setStartPort(SetHazelcastConfiguration.this.startPort);
                        }
                        if (SetHazelcastConfiguration.this.multiCastGroup != null) {
                            hazelcastRuntimeConfigurationProxy.setMulticastGroup(SetHazelcastConfiguration.this.multiCastGroup);
                        }
                        if (SetHazelcastConfiguration.this.multicastPort != null) {
                            hazelcastRuntimeConfigurationProxy.setMulticastPort(SetHazelcastConfiguration.this.multicastPort);
                        }
                        if (SetHazelcastConfiguration.this.configFile != null) {
                            hazelcastRuntimeConfigurationProxy.setHazelcastConfigurationFile(SetHazelcastConfiguration.this.configFile);
                        }
                        if (SetHazelcastConfiguration.this.hostawarePartitioning != null) {
                            hazelcastRuntimeConfigurationProxy.setHostAwarePartitioning(SetHazelcastConfiguration.this.hostawarePartitioning.toString());
                        }
                        if (SetHazelcastConfiguration.this.hzClusterName != null) {
                            hazelcastRuntimeConfigurationProxy.setClusterGroupName(SetHazelcastConfiguration.this.hzClusterName);
                        }
                        if (SetHazelcastConfiguration.this.hzClusterPassword != null) {
                            hazelcastRuntimeConfigurationProxy.setClusterGroupPassword(SetHazelcastConfiguration.this.hzClusterPassword);
                        }
                        if (SetHazelcastConfiguration.this.licenseKey != null) {
                            hazelcastRuntimeConfigurationProxy.setLicenseKey(SetHazelcastConfiguration.this.licenseKey);
                        }
                        if (SetHazelcastConfiguration.this.dasPublicAddress != null) {
                            hazelcastRuntimeConfigurationProxy.setDASPublicAddress(SetHazelcastConfiguration.this.dasPublicAddress);
                        }
                        if (SetHazelcastConfiguration.this.dasBindAddress != null) {
                            hazelcastRuntimeConfigurationProxy.setDASBindAddress(SetHazelcastConfiguration.this.dasBindAddress);
                        }
                        if (SetHazelcastConfiguration.this.dasPort != null) {
                            hazelcastRuntimeConfigurationProxy.setDasPort(SetHazelcastConfiguration.this.dasPort);
                        }
                        if (SetHazelcastConfiguration.this.clusterMode != null) {
                            hazelcastRuntimeConfigurationProxy.setDiscoveryMode(SetHazelcastConfiguration.this.clusterMode);
                        }
                        if (SetHazelcastConfiguration.this.tcpipMembers != null) {
                            hazelcastRuntimeConfigurationProxy.setTcpipMembers(SetHazelcastConfiguration.this.tcpipMembers);
                        }
                        if (SetHazelcastConfiguration.this.dnsMembers != null) {
                            hazelcastRuntimeConfigurationProxy.setDnsMembers(SetHazelcastConfiguration.this.dnsMembers);
                        }
                        if (SetHazelcastConfiguration.this.interfaces != null) {
                            hazelcastRuntimeConfigurationProxy.setInterface(SetHazelcastConfiguration.this.interfaces);
                        }
                        if (SetHazelcastConfiguration.this.kubernetesNamespace != null) {
                            hazelcastRuntimeConfigurationProxy.setKubernetesNamespace(SetHazelcastConfiguration.this.kubernetesNamespace);
                        }
                        if (SetHazelcastConfiguration.this.kubernetesServiceName != null) {
                            hazelcastRuntimeConfigurationProxy.setKubernetesServiceName(SetHazelcastConfiguration.this.kubernetesServiceName);
                        }
                        if (SetHazelcastConfiguration.this.autoIncrementPort != null) {
                            hazelcastRuntimeConfigurationProxy.setAutoIncrementPort(SetHazelcastConfiguration.this.autoIncrementPort.toString());
                        }
                        if (SetHazelcastConfiguration.this.encryptDatagrid != null) {
                            hazelcastRuntimeConfigurationProxy.setDatagridEncryptionEnabled(SetHazelcastConfiguration.this.encryptDatagrid.toString());
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return null;
                    }
                }, (ConfigBeanProxy)hazelcastRuntimeConfiguration);
                Config config = this.targetUtil.getConfig(this.target);
                ArrayList<Config> configsToApply = new ArrayList<Config>(5);
                if (config == null && this.target.equals("domain")) {
                    configsToApply.addAll(this.domain.getConfigs().getConfig());
                } else if (config != null) {
                    configsToApply.add(config);
                }
                for (final Config configToApply : configsToApply) {
                    HazelcastConfigSpecificConfiguration nodeConfiguration = (HazelcastConfigSpecificConfiguration)configToApply.getExtensionByType(HazelcastConfigSpecificConfiguration.class);
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastConfigSpecificConfiguration>(){

                        public Object run(HazelcastConfigSpecificConfiguration hazelcastRuntimeConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                            if (SetHazelcastConfiguration.this.jndiName != null) {
                                hazelcastRuntimeConfigurationProxy.setJNDIName(SetHazelcastConfiguration.this.jndiName);
                            }
                            if (SetHazelcastConfiguration.this.enabled != null) {
                                hazelcastRuntimeConfigurationProxy.setEnabled(SetHazelcastConfiguration.this.enabled.toString());
                            }
                            if (SetHazelcastConfiguration.this.lite != null) {
                                hazelcastRuntimeConfigurationProxy.setLite(SetHazelcastConfiguration.this.lite.toString());
                            }
                            if (SetHazelcastConfiguration.this.cacheManagerJndiName != null) {
                                hazelcastRuntimeConfigurationProxy.setCacheManagerJNDIName(SetHazelcastConfiguration.this.cacheManagerJndiName);
                            }
                            if (SetHazelcastConfiguration.this.cachingProviderJndiName != null) {
                                hazelcastRuntimeConfigurationProxy.setCachingProviderJNDIName(SetHazelcastConfiguration.this.cachingProviderJndiName);
                            }
                            if (SetHazelcastConfiguration.this.executorPoolSize != null) {
                                hazelcastRuntimeConfigurationProxy.setExecutorPoolSize(SetHazelcastConfiguration.this.executorPoolSize);
                            }
                            if (SetHazelcastConfiguration.this.executorQueueCapacity != null) {
                                hazelcastRuntimeConfigurationProxy.setExecutorQueueCapacity(SetHazelcastConfiguration.this.executorQueueCapacity);
                            }
                            if (SetHazelcastConfiguration.this.scheduledExecutorPoolSize != null) {
                                hazelcastRuntimeConfigurationProxy.setScheduledExecutorPoolSize(SetHazelcastConfiguration.this.scheduledExecutorPoolSize);
                            }
                            if (SetHazelcastConfiguration.this.scheduledExecutorQueueCapacity != null) {
                                hazelcastRuntimeConfigurationProxy.setScheduledExecutorQueueCapacity(SetHazelcastConfiguration.this.scheduledExecutorQueueCapacity);
                            }
                            if (SetHazelcastConfiguration.this.memberName != null) {
                                hazelcastRuntimeConfigurationProxy.setMemberName(SetHazelcastConfiguration.this.memberName);
                            }
                            if (SetHazelcastConfiguration.this.memberGroup != null) {
                                hazelcastRuntimeConfigurationProxy.setMemberGroup(SetHazelcastConfiguration.this.memberGroup);
                            }
                            if (SetHazelcastConfiguration.this.publicAddress != null) {
                                hazelcastRuntimeConfigurationProxy.setPublicAddress(SetHazelcastConfiguration.this.publicAddress);
                            }
                            if (SetHazelcastConfiguration.this.configSpecificDataGridStartPort != null && !configToApply.isDas()) {
                                hazelcastRuntimeConfigurationProxy.setConfigSpecificDataGridStartPort(SetHazelcastConfiguration.this.configSpecificDataGridStartPort);
                            }
                            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                            return null;
                        }
                    }, (ConfigBeanProxy)nodeConfiguration);
                }
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                Throwable cause = ex.getCause();
                if (cause != null) {
                    actionReport.setMessage(ex.getCause().getMessage());
                } else {
                    actionReport.setMessage(ex.getMessage());
                }
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.dynamic.booleanValue()) {
                boolean isEnabled = false;
                isEnabled = this.enabled != null ? this.enabled.booleanValue() : this.hazelcast.isEnabled();
                if ("domain".equals(this.target)) {
                    this.hazelcast.setEnabled(isEnabled);
                } else {
                    for (Server targetServer : this.targetUtil.getInstances(this.target)) {
                        if (!this.server.getInstanceName().equals(targetServer.getName())) continue;
                        this.hazelcast.setEnabled(isEnabled);
                    }
                }
            }
            if (this.encryptDatagrid != null && this.encryptDatagrid.booleanValue()) {
                this.checkForDatagridKey(actionReport);
            }
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation inv = runner.getCommandInvocation("restart-hazelcast", subReport, context.getSubject());
        List serversAffected = this.targetUtil.getInstances(this.target);
        for (Server server : serversAffected) {
            ParameterMap params = new ParameterMap();
            params.add((Object)"target", (Object)server.getName());
            inv.parameters(params);
            inv.execute();
            if (!subReport.hasWarnings()) continue;
            subReport.setMessage("");
        }
    }

    private boolean validate(ActionReport actionReport) {
        int port;
        boolean result = false;
        if (this.startPort != null) {
            try {
                port = Integer.parseInt(this.startPort);
                if (port < 0 || port > 65534) {
                    actionReport.failure(this.logger, "start port must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "startPort is not a valid integer", (Throwable)nfe);
                return result;
            }
        }
        if (this.multicastPort != null) {
            try {
                port = Integer.parseInt(this.multicastPort);
                if (port < 0 || port > 65534) {
                    actionReport.failure(this.logger, "multicast port must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "multicast is not a valid integer", (Throwable)nfe);
                return result;
            }
        }
        if (this.multiCastGroup != null) {
            try {
                InetAddress address = InetAddress.getByName(this.multiCastGroup);
                if (!address.isMulticastAddress()) {
                    actionReport.failure(this.logger, this.multiCastGroup + " is not a valid multicast address ");
                    return result;
                }
            }
            catch (UnknownHostException ex) {
                actionReport.failure(this.logger, this.multiCastGroup + " is not a valid multicast address ", (Throwable)ex);
                return result;
            }
        }
        return true;
    }

    public String getTarget(ParameterMap pm) {
        String result = (String)pm.getOne((Object)"target");
        if (result == null) {
            result = this.target;
        }
        return result;
    }

    private void checkForDatagridKey(ActionReport actionReport) {
        File datagridKey = new File(this.server.getConfigDirPath().getPath() + File.separator + "datagrid-key");
        if (!datagridKey.exists()) {
            actionReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            actionReport.appendMessage("Could not find datagrid-key in domain config directory. Please ensure that you generate one before restarting the domain.");
        }
    }
}

