/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.encryption;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.IOUtil;
import com.sun.enterprise.security.ssl.impl.MasterPasswordImpl;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.Globals;

public class HazelcastSymmetricEncryptor {
    private static final String DATAGRID_KEY_FILE = "datagrid-key";
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String PBKDF_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String AES = "AES";
    private static final int ITERATION_COUNT = 65556;
    private static final int KEYSIZE = 256;
    private static Random random = new SecureRandom();
    private static SecretKey secretKey;

    public static byte[] encode(byte[] value) {
        byte[] saltBytes = new byte[20];
        random.nextBytes(saltBytes);
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, secretKey);
            AlgorithmParameters params = cipher.getParameters();
            byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] encryptedTextBytes = cipher.doFinal(value);
            byte[] buffer = new byte[saltBytes.length + ivBytes.length + encryptedTextBytes.length];
            System.arraycopy(saltBytes, 0, buffer, 0, saltBytes.length);
            System.arraycopy(ivBytes, 0, buffer, saltBytes.length, ivBytes.length);
            System.arraycopy(encryptedTextBytes, 0, buffer, saltBytes.length + ivBytes.length, encryptedTextBytes.length);
            return buffer;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new HazelcastException((Throwable)exception);
        }
    }

    public static byte[] decode(byte[] encryptedTextBytes) {
        byte[] decryptedTextBytes;
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            ByteBuffer buffer = ByteBuffer.wrap(encryptedTextBytes);
            byte[] saltBytes = new byte[20];
            buffer.get(saltBytes, 0, saltBytes.length);
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            buffer.get(ivBytes, 0, ivBytes.length);
            encryptedTextBytes = new byte[buffer.capacity() - saltBytes.length - ivBytes.length];
            buffer.get(encryptedTextBytes);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(ivBytes));
            decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
        }
        catch (BadPaddingException exception) {
            throw new HazelcastException("BadPaddingException caught decoding data, this can be caused by an incorrect or changed key: ", (Throwable)exception);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new HazelcastException((Throwable)exception);
        }
        return decryptedTextBytes;
    }

    private static SecretKey readAndDecryptSecretKey() {
        ServerEnvironment serverEnvironment = (ServerEnvironment)Globals.getDefaultBaseServiceLocator().getService(ServerEnvironment.class, new Annotation[0]);
        char[] masterPassword = ((MasterPasswordImpl)Globals.getDefaultBaseServiceLocator().getService(MasterPasswordImpl.class, new Annotation[0])).getMasterPassword();
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = Files.readAllBytes(new File(serverEnvironment.getConfigDirPath() + File.separator + DATAGRID_KEY_FILE).toPath());
        }
        catch (IOException ioe) {
            Logger.getLogger(HazelcastSymmetricEncryptor.class.getName()).log(Level.SEVERE, "Error reading datagrid key, please check if it's accessible at expected location: " + serverEnvironment.getConfigDirPath() + File.separator + DATAGRID_KEY_FILE);
            throw new HazelcastException("Error reading encrypted key", (Throwable)ioe);
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            ByteBuffer buffer = ByteBuffer.wrap(encryptedBytes);
            byte[] saltBytes = new byte[20];
            buffer.get(saltBytes, 0, saltBytes.length);
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            buffer.get(ivBytes, 0, ivBytes.length);
            byte[] encryptedTextBytes = new byte[buffer.capacity() - saltBytes.length - ivBytes.length];
            buffer.get(encryptedTextBytes);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(masterPassword, saltBytes, 65556, 256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), AES);
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(ivBytes));
            return new SecretKeySpec(cipher.doFinal(encryptedTextBytes), AES);
        }
        catch (BadPaddingException bpe) {
            throw new HazelcastException("BadPaddingException caught decrypting data grid key - likely caused by an incorrect or changed master password", (Throwable)bpe);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new HazelcastException((Throwable)exception);
        }
    }

    public static byte[] objectToByteArray(Object object) {
        byte[] bytes = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(object);
            bytes = bos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bytes == null) {
            throw new HazelcastException("Error converting Object to Byte Array");
        }
        return bytes;
    }

    public static Object byteArrayToObject(byte[] bytes) {
        Object object;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            object = IOUtil.newObjectInputStream((ClassLoader)Thread.currentThread().getContextClassLoader(), null, (InputStream)bis).readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new HazelcastException("Error converting Byte Array to Object", (Throwable)exception);
        }
        return object;
    }

    static {
        try {
            secretKey = HazelcastSymmetricEncryptor.readAndDecryptSecretKey();
            Logger.getLogger(HazelcastSymmetricEncryptor.class.getName()).log(Level.FINE, "Data grid encryption key successfully read and decrypted");
        }
        catch (Exception exception) {
            Logger.getLogger(HazelcastSymmetricEncryptor.class.getName()).log(Level.SEVERE, "Error starting Hazelcast due to exception reading encryption key", exception);
            ((HazelcastCore)Globals.get(HazelcastCore.class)).getInstance().shutdown();
        }
    }
}

