/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.CompareUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.TypeCast;

public final class MapUtil {
    private MapUtil() {
    }

    public static <K, V> V getWithDefault(Map<K, V> m, K key, V defaultValue) {
        return m.getOrDefault(key, defaultValue);
    }

    public static Object[] getKeyObjects(Map<?, ?> m) {
        Object[] keys = new Object[m.keySet().size()];
        m.keySet().toArray(keys);
        return keys;
    }

    public static String[] getKeyStrings(Map<?, ?> m) {
        return SetUtil.toSortedStringArray(m.keySet());
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <V> Map<String, V> newMap(String key, V value) {
        HashMap<String, V> map = new HashMap<String, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> m1, Map<K, V> m2) {
        HashMap<K, V> newMap = new HashMap<K, V>();
        if (m1 != null) {
            newMap.putAll(m1);
        }
        if (m2 != null) {
            newMap.putAll(m2);
        }
        return newMap;
    }

    public static <K, V> Map<K, V> toMap(Object[] params, Class<K> keyClass, Class<V> valueClass) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < params.length; i += 2) {
            Object key = params[i];
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (!keyClass.isAssignableFrom(key.getClass())) {
                throw new IllegalArgumentException("Key of class " + key.getClass().getName() + " not assignable to " + keyClass.getName());
            }
            Object value = params[i + 1];
            if (value != null && !valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Value of class " + value.getClass().getName() + " not assignable to " + valueClass.getName());
            }
            map.put(keyClass.cast(key), valueClass.cast(value));
        }
        return map;
    }

    public static <T> Map<T, T> newMap(T ... mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings must have even length");
        }
        HashMap<T, T> m = new HashMap<T, T>();
        for (int i = 0; i < mappings.length; i += 2) {
            m.put(mappings[i], mappings[i + 1]);
        }
        return m;
    }

    public static Map<String, String> newMap(String ... mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings must have even length");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < mappings.length; i += 2) {
            map.put(mappings[i], mappings[i + 1]);
        }
        return map;
    }

    public static <T> void removeAll(Map<T, ?> map, T[] keys) {
        for (T key : keys) {
            map.remove(key);
        }
    }

    public static boolean mapsEqual(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == map2) {
            return true;
        }
        boolean equal = false;
        if (map1.size() == map2.size() && map1.keySet().equals(map2.keySet())) {
            equal = true;
            for (Map.Entry<?, ?> me : map1.entrySet()) {
                Object value2;
                Object key = me.getKey();
                Object value1 = me.getValue();
                if (CompareUtil.objectsEqual(value1, value2 = map2.get(key))) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static <K, V> Map<K, V> newMapNoNullValues(Map<K, V> map) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> me : map.entrySet()) {
            V value = me.getValue();
            if (value == null) continue;
            result.put(me.getKey(), value);
        }
        return result;
    }

    public static String toString(Map<?, ?> m) {
        return MapUtil.toString(m, ",");
    }

    public static String toString(Map<?, ?> map, String separator) {
        String[] keyStrings;
        if (map == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (String key : keyStrings = MapUtil.getKeyStrings(map)) {
            Object value = map.get(key);
            buf.append(key);
            buf.append("=");
            buf.append(StringUtil.toString(value));
            buf.append(separator);
        }
        if (buf.length() != 0) {
            buf.setLength(buf.length() - separator.length());
        }
        return buf.toString();
    }

    public static <K> Set<K> getNullValueKeys(Map<K, ?> map) {
        HashSet<K> s = new HashSet<K>();
        for (Map.Entry<K, ?> me : map.entrySet()) {
            if (me.getValue() != null) continue;
            s.add(me.getKey());
        }
        return s;
    }

    public static <K, V> Map<K, V> toMap(Properties props, Class<K> kClass, Class<V> vClass) {
        return TypeCast.checkMap(props, kClass, vClass);
    }

    public static <K> void removeAll(Map<K, ?> map, Set<K> keySet) {
        for (K key : keySet) {
            map.remove(key);
        }
    }

    public static boolean isAllStrings(Map<?, ?> map) {
        return map != null && CollectionUtil.isAllStrings(map.keySet()) && CollectionUtil.isAllStrings(map.values());
    }

    public static Map<String, String> toStringStringMap(Map<?, ?> map) {
        Map<String, String> result;
        if (map == null) {
            return null;
        }
        if (MapUtil.isAllStrings(map)) {
            result = TypeCast.asMap(map);
        } else {
            result = new HashMap();
            for (Map.Entry<?, ?> me : map.entrySet()) {
                Object key = me.getKey();
                Object value = me.getValue();
                if (key instanceof String && value instanceof String) {
                    result.put((String)key, (String)value);
                    continue;
                }
                result.put("" + key, "" + value);
            }
        }
        return result;
    }
}

