/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.KubernetesClientException;
import com.hazelcast.nio.IOUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

class DefaultKubernetesClient
implements KubernetesClient {
    private static final int HTTP_OK = 200;
    private final String kubernetesMaster;
    private final String apiToken;

    DefaultKubernetesClient(String kubernetesMaster, String apiToken) {
        this.kubernetesMaster = kubernetesMaster;
        this.apiToken = apiToken;
    }

    @Override
    public KubernetesClient.Endpoints endpoints(String namespace) {
        String urlString = String.format("%s/api/v1/namespaces/%s/endpoints", this.kubernetesMaster, namespace);
        return DefaultKubernetesClient.parseEndpointsList(this.callGet(urlString));
    }

    @Override
    public KubernetesClient.Endpoints endpointsByLabel(String namespace, String serviceLabel, String serviceLabelValue) {
        String param = String.format("labelSelector=%s=%s", serviceLabel, serviceLabelValue);
        String urlString = String.format("%s/api/v1/namespaces/%s/endpoints?%s", this.kubernetesMaster, namespace, param);
        return DefaultKubernetesClient.parseEndpointsList(this.callGet(urlString));
    }

    @Override
    public KubernetesClient.Endpoints endpointsByName(String namespace, String endpointName) {
        String urlString = String.format("%s/api/v1/namespaces/%s/endpoints/%s", this.kubernetesMaster, namespace, endpointName);
        JsonObject json = this.callGet(urlString);
        return DefaultKubernetesClient.parseEndpoint((JsonValue)json);
    }

    private JsonObject callGet(String urlString) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(DefaultKubernetesClient.buildSslSocketFactory());
            }
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", String.format("Bearer %s", this.apiToken));
            if (connection.getResponseCode() != 200) {
                throw new KubernetesClientException(String.format("Failure executing: GET at: %s. Message: %s,", urlString, DefaultKubernetesClient.read(connection.getErrorStream())));
            }
            JsonObject jsonObject = Json.parse((String)DefaultKubernetesClient.read(connection.getInputStream())).asObject();
            return jsonObject;
        }
        catch (Exception e) {
            throw new KubernetesClientException("Failure in KubernetesClient", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String read(InputStream stream) {
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    private static KubernetesClient.Endpoints parseEndpointsList(JsonObject json) {
        ArrayList<KubernetesClient.EntrypointAddress> addresses = new ArrayList<KubernetesClient.EntrypointAddress>();
        ArrayList<KubernetesClient.EntrypointAddress> notReadyAddresses = new ArrayList<KubernetesClient.EntrypointAddress>();
        for (JsonValue object : DefaultKubernetesClient.toJsonArray(json.get("items"))) {
            KubernetesClient.Endpoints endpoints = DefaultKubernetesClient.parseEndpoint(object);
            addresses.addAll(endpoints.getAddresses());
            notReadyAddresses.addAll(endpoints.getNotReadyAddresses());
        }
        return new KubernetesClient.Endpoints(addresses, notReadyAddresses);
    }

    private static KubernetesClient.Endpoints parseEndpoint(JsonValue endpointsJson) {
        ArrayList<KubernetesClient.EntrypointAddress> addresses = new ArrayList<KubernetesClient.EntrypointAddress>();
        ArrayList<KubernetesClient.EntrypointAddress> notReadyAddresses = new ArrayList<KubernetesClient.EntrypointAddress>();
        for (JsonValue subset : DefaultKubernetesClient.toJsonArray(endpointsJson.asObject().get("subsets"))) {
            for (JsonValue address : DefaultKubernetesClient.toJsonArray(subset.asObject().get("addresses"))) {
                addresses.add(DefaultKubernetesClient.parseEntrypointAddress(address));
            }
            for (JsonValue notReadyAddress : DefaultKubernetesClient.toJsonArray(subset.asObject().get("notReadyAddresses"))) {
                notReadyAddresses.add(DefaultKubernetesClient.parseEntrypointAddress(notReadyAddress));
            }
        }
        return new KubernetesClient.Endpoints(addresses, notReadyAddresses);
    }

    private static KubernetesClient.EntrypointAddress parseEntrypointAddress(JsonValue endpointAddressJson) {
        String ip = endpointAddressJson.asObject().get("ip").asString();
        Map<String, Object> additionalProperties = DefaultKubernetesClient.parseAdditionalProperties(endpointAddressJson);
        return new KubernetesClient.EntrypointAddress(ip, additionalProperties);
    }

    private static Map<String, Object> parseAdditionalProperties(JsonValue endpointAddressJson) {
        HashSet<String> knownFieldNames = new HashSet<String>(Arrays.asList("ip", "nodeName", "targetRef", "hostname"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (JsonObject.Member member : endpointAddressJson.asObject()) {
            if (knownFieldNames.contains(member.getName())) continue;
            result.put(member.getName(), DefaultKubernetesClient.toString(member.getValue()));
        }
        return result;
    }

    private static JsonArray toJsonArray(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonArray();
        }
        return jsonValue.asArray();
    }

    private static String toString(JsonValue jsonValue) {
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        return jsonValue.toString();
    }

    private static SSLSocketFactory buildSslSocketFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", DefaultKubernetesClient.generateCertificate());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new KubernetesClientException("Failure in generating SSLSocketFactory", e);
        }
    }

    private static Certificate generateCertificate() throws IOException, CertificateException {
        Certificate certificate;
        BufferedInputStream caInput = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            caInput = new BufferedInputStream(new FileInputStream(new File(DefaultKubernetesClient.caCertPath())));
            certificate = cf.generateCertificate(caInput);
        }
        catch (Throwable throwable) {
            IOUtil.closeResource(caInput);
            throw throwable;
        }
        IOUtil.closeResource((Closeable)caInput);
        return certificate;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static String caCertPath() {
        return "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    }
}

