/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.kubernetes.DnsEndpointResolver;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.kubernetes.ServiceEndpointResolver;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

final class HazelcastKubernetesDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String DEFAULT_MASTER_URL = "https://kubernetes.default.svc";
    private static final String HAZELCAST_SERVICE_PORT = "hazelcast-service-port";
    private static final int DEFAULT_SERVICE_DNS_TIMEOUT_SECONDS = 5;
    private final EndpointResolver endpointResolver;

    HazelcastKubernetesDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        String serviceDns = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS);
        int serviceDnsTimeout = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS_TIMEOUT, 5);
        String serviceName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_NAME);
        int port = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_PORT, 0);
        String serviceLabel = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_NAME);
        String serviceLabelValue = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_VALUE, "true");
        String namespace = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.NAMESPACE, this.getNamespaceOrDefault());
        Boolean resolveNotReadyAddresses = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.RESOLVE_NOT_READY_ADDRESSES, false);
        String kubernetesMaster = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_MASTER_URL, DEFAULT_MASTER_URL);
        String apiToken = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_API_TOKEN, null);
        logger.info("Kubernetes Discovery properties: { service-dns: " + serviceDns + ", service-dns-timeout: " + serviceDnsTimeout + ", service-name: " + serviceName + ", service-port: " + port + ", service-label: " + serviceLabel + ", service-label-value: " + serviceLabelValue + ", namespace: " + namespace + ", resolve-not-ready-addresses: " + resolveNotReadyAddresses + ", kubernetes-master: " + kubernetesMaster + "}");
        EndpointResolver endpointResolver = serviceDns != null ? new DnsEndpointResolver(logger, serviceDns, port, serviceDnsTimeout) : new ServiceEndpointResolver(logger, serviceName, port, serviceLabel, serviceLabelValue, namespace, resolveNotReadyAddresses, kubernetesMaster, apiToken);
        logger.info("Kubernetes Discovery activated resolver: " + endpointResolver.getClass().getSimpleName());
        this.endpointResolver = endpointResolver;
    }

    private String getNamespaceOrDefault() {
        String namespace = System.getenv("KUBERNETES_NAMESPACE");
        if (namespace == null && (namespace = System.getenv("OPENSHIFT_BUILD_NAMESPACE")) == null) {
            namespace = "default";
        }
        return namespace;
    }

    public void start() {
        this.endpointResolver.start();
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        return this.endpointResolver.resolve();
    }

    public void destroy() {
        this.endpointResolver.destroy();
    }

    protected <T extends Comparable> T getOrNull(Map<String, Comparable> properties, String prefix, PropertyDefinition property) {
        return this.getOrDefault(properties, prefix, property, null);
    }

    protected <T extends Comparable> T getOrDefault(Map<String, Comparable> properties, String prefix, PropertyDefinition property, T defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        Comparable value = this.readProperty(prefix, property);
        if (value == null) {
            value = properties.get(property.key());
        }
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private Comparable readProperty(String prefix, PropertyDefinition property) {
        if (prefix != null) {
            String p = this.getProperty(prefix, property);
            String v = System.getProperty(p);
            if (StringUtil.isNullOrEmpty((String)v) && StringUtil.isNullOrEmpty((String)(v = System.getenv(p)))) {
                v = System.getenv(this.cIdentifierLike(p));
            }
            if (!StringUtil.isNullOrEmpty((String)v)) {
                return property.typeConverter().convert((Comparable)((Object)v));
            }
        }
        return null;
    }

    private String cIdentifierLike(String property) {
        property = property.toUpperCase();
        property = property.replace(".", "_");
        return property.replace("-", "_");
    }

    private String getProperty(String prefix, PropertyDefinition property) {
        StringBuilder sb = new StringBuilder(prefix);
        if (prefix.charAt(prefix.length() - 1) != '.') {
            sb.append('.');
        }
        return sb.append(property.key()).toString();
    }

    static abstract class EndpointResolver {
        protected final ILogger logger;

        EndpointResolver(ILogger logger) {
            this.logger = logger;
        }

        abstract List<DiscoveryNode> resolve();

        void start() {
        }

        void destroy() {
        }

        protected InetAddress mapAddress(String address) {
            if (address == null) {
                return null;
            }
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Address '" + address + "' could not be resolved");
                return null;
            }
        }

        protected int getServicePort(Map<String, Object> properties) {
            String servicePort;
            int port = 5701;
            if (properties != null && (servicePort = (String)properties.get(HazelcastKubernetesDiscoveryStrategy.HAZELCAST_SERVICE_PORT)) != null) {
                port = Integer.parseInt(servicePort);
            }
            return port;
        }
    }
}

