/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.kubernetes.DefaultKubernetesClient;
import com.hazelcast.kubernetes.HazelcastKubernetesDiscoveryStrategy;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.RetryKubernetesClient;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ServiceEndpointResolver
extends HazelcastKubernetesDiscoveryStrategy.EndpointResolver {
    private final String serviceName;
    private final String serviceLabel;
    private final String serviceLabelValue;
    private final String namespace;
    private final Boolean resolveNotReadyAddresses;
    private final int port;
    private final KubernetesClient client;

    ServiceEndpointResolver(ILogger logger, String serviceName, int port, String serviceLabel, String serviceLabelValue, String namespace, Boolean resolveNotReadyAddresses, String kubernetesMaster, String apiToken) {
        super(logger);
        this.serviceName = serviceName;
        this.port = port;
        this.namespace = namespace;
        this.serviceLabel = serviceLabel;
        this.serviceLabelValue = serviceLabelValue;
        this.resolveNotReadyAddresses = resolveNotReadyAddresses;
        this.client = this.buildKubernetesClient(apiToken, kubernetesMaster);
    }

    private KubernetesClient buildKubernetesClient(String token, String kubernetesMaster) {
        if (StringUtil.isNullOrEmpty((String)token)) {
            token = this.getAccountToken();
        }
        return new RetryKubernetesClient(new DefaultKubernetesClient(kubernetesMaster, token));
    }

    @Override
    List<DiscoveryNode> resolve() {
        if (this.serviceName != null && !this.serviceName.isEmpty()) {
            return this.getSimpleDiscoveryNodes(this.client.endpointsByName(this.namespace, this.serviceName));
        }
        if (this.serviceLabel != null && !this.serviceLabel.isEmpty()) {
            return this.getSimpleDiscoveryNodes(this.client.endpointsByLabel(this.namespace, this.serviceLabel, this.serviceLabelValue));
        }
        return this.getSimpleDiscoveryNodes(this.client.endpoints(this.namespace));
    }

    private List<DiscoveryNode> getSimpleDiscoveryNodes(KubernetesClient.Endpoints endpoints) {
        ArrayList<DiscoveryNode> discoveredNodes = new ArrayList<DiscoveryNode>();
        this.resolveNotReadyAddresses(discoveredNodes, endpoints.getNotReadyAddresses());
        this.resolveAddresses(discoveredNodes, endpoints.getAddresses());
        return discoveredNodes;
    }

    private void resolveNotReadyAddresses(List<DiscoveryNode> discoveredNodes, List<KubernetesClient.EntrypointAddress> notReadyAddresses) {
        if (Boolean.TRUE.equals(this.resolveNotReadyAddresses)) {
            this.resolveAddresses(discoveredNodes, notReadyAddresses);
        }
    }

    private void resolveAddresses(List<DiscoveryNode> discoveredNodes, List<KubernetesClient.EntrypointAddress> addresses) {
        for (KubernetesClient.EntrypointAddress address : addresses) {
            this.addAddress(discoveredNodes, address);
        }
    }

    private void addAddress(List<DiscoveryNode> discoveredNodes, KubernetesClient.EntrypointAddress entrypointAddress) {
        Map<String, Object> properties = entrypointAddress.getAdditionalProperties();
        String ip = entrypointAddress.getIp();
        InetAddress inetAddress = this.mapAddress(ip);
        int port = this.port > 0 ? this.port : this.getServicePort(properties);
        Address address = new Address(inetAddress, port);
        discoveredNodes.add((DiscoveryNode)new SimpleDiscoveryNode(address, properties));
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Found node service with address: " + address);
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private String getAccountToken() {
        return ServiceEndpointResolver.readFileContents("/var/run/secrets/kubernetes.io/serviceaccount/token");
    }

    protected static String readFileContents(String tokenFile) {
        String string;
        FileInputStream is = null;
        try {
            File file = new File(tokenFile);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, "UTF-8");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get token file", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource((Closeable)is);
        return string;
    }
}

