/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.opentracing.ScopeManager;
import io.opentracing.Scope;
import io.opentracing.Span;

public class OpenTracingScope
implements Scope {
    private Span currentSpan;
    private boolean finishOnClose;
    private OpenTracingScope previouslyActiveScope;
    private ScopeManager scopeManager;

    OpenTracingScope(ScopeManager scopeManager, Span spanToActivate, boolean finishOnClose) {
        this.scopeManager = scopeManager;
        this.currentSpan = spanToActivate;
        this.finishOnClose = finishOnClose;
        this.previouslyActiveScope = (OpenTracingScope)scopeManager.active();
        scopeManager.activeScope.set(this);
    }

    public void close() {
        if (this.scopeManager.activeScope.get() != this) {
            return;
        }
        if (this.finishOnClose) {
            this.currentSpan.finish();
        }
        this.scopeManager.activeScope.set(this.previouslyActiveScope);
    }

    public Span span() {
        return this.currentSpan;
    }
}

