/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import java.util.List;

public class PropertyResolver {
    private Domain domain = null;
    private Cluster cluster = null;
    private Server server = null;
    private Config config = null;

    public PropertyResolver(Domain domain, String instanceName) {
        this.domain = domain;
        this.server = domain.getServerNamed(instanceName);
        this.config = this.server != null ? domain.getConfigNamed(this.server.getConfigRef()) : domain.getConfigNamed(instanceName);
        this.cluster = domain.getClusterForInstance(instanceName);
    }

    private String getPropertyValue(String propName, List<SystemProperty> props) {
        String propVal = null;
        for (SystemProperty prop : props) {
            if (!prop.getName().equals(propName)) continue;
            return prop.getValue();
        }
        return propVal;
    }

    public String getPropertyValue(String propName) {
        if (propName.startsWith("${") && propName.endsWith("}")) {
            propName = propName.substring(2, propName.lastIndexOf(125));
        }
        String propVal = null;
        if (this.server != null) {
            propVal = this.getPropertyValue(propName, this.server.getSystemProperty());
        }
        if (propVal == null) {
            if (this.cluster != null) {
                propVal = this.getPropertyValue(propName, this.cluster.getSystemProperty());
            }
            if (propVal == null && this.config != null && (propVal = this.getPropertyValue(propName, this.config.getSystemProperty())) == null && this.domain != null) {
                propVal = this.getPropertyValue(propName, this.domain.getSystemProperty());
            }
        }
        return propVal;
    }
}

