/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.digest.impl;

import com.sun.logging.LogDomains;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="CNonceCache")
@PerLookup
public final class CNonceCacheImpl
extends LinkedHashMap<String, NonceInfo>
implements CNonceCache {
    private static final long serialVersionUID = 1L;
    private Logger _logger = LogDomains.getLogger(CNonceCacheImpl.class, (String)"javax.enterprise.system.core.security");
    private static final long LOG_SUPPRESS_TIME = 300000L;
    private long lastLog = 0L;
    private String eldestCNonce;
    long cnonceCacheSize = 1000L;
    long nonceValidity = 300000L;

    public void init(long size, String name, long validity, Map<String, String> props) {
        this.cnonceCacheSize = size;
        this.nonceValidity = validity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
        long currentTime = System.currentTimeMillis();
        this.eldestCNonce = eldest.getKey();
        if ((long)this.size() > this.getCnonceCacheSize()) {
            if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < this.getNonceValidity()) {
                this._logger.log(Level.WARNING, "digestAuthenticator.cacheRemove");
                this.lastLog = currentTime + 300000L;
            }
            return true;
        }
        return false;
    }

    public long getCnonceCacheSize() {
        return this.cnonceCacheSize;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public String getEldestCNonce() {
        return this.eldestCNonce;
    }

    public void setCnonceCacheSize(long cnonceCacheSize) {
        this.cnonceCacheSize = cnonceCacheSize;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public void destroy() {
        this.clear();
    }
}

