/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc;

import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.security.jacc.JaccWebConstraintsTranslator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.security.common.Role;

class ConstraintValue {
    static String[] connectKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    static int connectTypeNone = 1;
    static HashMap<String, Integer> connectHash = new HashMap();
    boolean excluded = false;
    boolean ignoreRoleList = false;
    final List<String> roleList = new ArrayList<String>();
    int connectSet = 0;

    ConstraintValue() {
    }

    static boolean bitIsSet(int map, int bit) {
        return (map & bit) == bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRole(String role) {
        List<String> list = this.roleList;
        synchronized (list) {
            if (!this.roleList.contains(role)) {
                this.roleList.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRole(String role) {
        List<String> list = this.roleList;
        synchronized (list) {
            if (this.roleList.contains(role)) {
                this.roleList.remove(role);
            }
        }
    }

    void setPredefinedOutcome(boolean outcome) {
        if (!outcome) {
            this.excluded = true;
        } else {
            this.ignoreRoleList = true;
        }
    }

    void addConnectType(String guarantee) {
        int b = connectTypeNone;
        if (guarantee != null) {
            Integer bit = connectHash.get(guarantee);
            if (bit == null) {
                throw new IllegalArgumentException("constraint translation error-illegal trx guarantee");
            }
            b = bit;
        }
        this.connectSet |= b;
    }

    boolean isExcluded() {
        return this.excluded;
    }

    boolean isAuthConstrained() {
        if (this.excluded) {
            return true;
        }
        return !this.ignoreRoleList && !this.roleList.isEmpty();
    }

    boolean isTransportConstrained() {
        return this.excluded || this.connectSet != 0 && !ConstraintValue.bitIsSet(this.connectSet, connectTypeNone);
    }

    boolean isConnectAllowed(int cType) {
        return !this.excluded && (this.connectSet == 0 || ConstraintValue.bitIsSet(this.connectSet, connectTypeNone) || ConstraintValue.bitIsSet(this.connectSet, cType));
    }

    void setOutcome(Set<Role> roleSet, AuthorizationConstraint ac, UserDataConstraint udc) {
        if (ac == null) {
            this.setPredefinedOutcome(true);
        } else {
            boolean containsAllRoles = false;
            Enumeration eroles = ac.getSecurityRoles();
            if (!eroles.hasMoreElements()) {
                this.setPredefinedOutcome(false);
            } else {
                while (eroles.hasMoreElements()) {
                    SecurityRoleDescriptor srd = (SecurityRoleDescriptor)eroles.nextElement();
                    String roleName = srd.getName();
                    if ("*".equals(roleName)) {
                        containsAllRoles = true;
                        continue;
                    }
                    this.setRole(roleName);
                }
            }
            if (containsAllRoles) {
                this.removeRole("**");
                Iterator<Role> it = roleSet.iterator();
                while (it.hasNext()) {
                    this.setRole(it.next().getName());
                }
            }
        }
        this.addConnectType(udc == null ? null : udc.getTransportGuarantee());
        if (JaccWebConstraintsTranslator.logger.isLoggable(Level.FINE)) {
            JaccWebConstraintsTranslator.logger.log(Level.FINE, "JACC: setOutcome yields: " + this.toString());
        }
    }

    void setValue(ConstraintValue constraint) {
        this.excluded = constraint.excluded;
        this.ignoreRoleList = constraint.ignoreRoleList;
        this.roleList.clear();
        for (String role : constraint.roleList) {
            this.roleList.add(role);
        }
        this.connectSet = constraint.connectSet;
    }

    public String toString() {
        StringBuilder roles = new StringBuilder(" roles: ");
        Iterator<String> rit = this.roleList.iterator();
        while (rit.hasNext()) {
            roles.append(" ").append(rit.next());
        }
        StringBuilder transports = new StringBuilder("transports: ");
        for (int i = 0; i < connectKeys.length; ++i) {
            if (!this.isConnectAllowed(1 << i)) continue;
            transports.append(" ").append(connectKeys[i]);
        }
        return " ConstraintValue (  excluded: " + this.excluded + " ignoreRoleList: " + this.ignoreRoleList + roles + transports + " ) ";
    }

    boolean isUncovered() {
        return !this.excluded && !this.ignoreRoleList && this.roleList.isEmpty() && this.connectSet == 0;
    }

    static {
        for (int i = 0; i < connectKeys.length; ++i) {
            connectHash.put(connectKeys[i], 1 << i);
        }
    }
}

