/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deployment.PermissionsDescriptor;
import com.sun.enterprise.deployment.io.PermissionsDeploymentDescriptorFile;
import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.GlobalPolicyUtil;
import com.sun.enterprise.security.permissionsxml.PermissionsXMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.xml.sax.SAXParseException;

public class PermissionsXMLLoader {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
    private DasConfig dasConfig;
    private PermissionCollection declaredPermissionXml;
    private PermissionCollection restrictedPermissionCollection;
    private CommponentType componentType;

    public PermissionsXMLLoader(File base, CommponentType type) throws XMLStreamException, FileNotFoundException {
        this.componentType = type;
        this.loadAppPermissionsFromPath(base);
        this.checkServerRestrictedPermissions();
    }

    public PermissionsXMLLoader(InputStream restrictPermInput, InputStream allowedPermInput, CommponentType type) throws XMLStreamException, FileNotFoundException {
        this.componentType = type;
        this.loadAppPermissionsFromStream(allowedPermInput);
        this.checkServerRestrictedPermissions();
    }

    public PermissionCollection getAppDeclaredPermissions() {
        return this.declaredPermissionXml;
    }

    private void loadAppPermissionsFromPath(File base) throws XMLStreamException, FileNotFoundException {
        File permissionsXml = new File(base.getAbsolutePath(), "META-INF/permissions.xml");
        if (permissionsXml.exists()) {
            try (FileInputStream permissionsXmlStream = new FileInputStream(permissionsXml);){
                PermissionsDeploymentDescriptorFile pddf = this.getPermissionsDeploymentDescriptorFile();
                PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)pddf.read((InputStream)permissionsXmlStream);
                this.declaredPermissionXml = permissionsDescriptor.getDeclaredPermissions();
            }
            catch (IOException | SAXParseException e) {
                throw new SecurityException(e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("App declared permission = " + this.declaredPermissionXml);
            }
        }
    }

    private void loadAppPermissionsFromStream(InputStream permissionsInput) throws XMLStreamException, FileNotFoundException {
        if (permissionsInput == null) {
            return;
        }
        PermissionsXMLParser parser = new PermissionsXMLParser(permissionsInput, this.restrictedPermissionCollection);
        this.declaredPermissionXml = parser.getPermissions();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("App declared permission = " + this.declaredPermissionXml);
        }
    }

    private PermissionsDeploymentDescriptorFile getPermissionsDeploymentDescriptorFile() {
        PermissionsDeploymentDescriptorFile descriptorFile = new PermissionsDeploymentDescriptorFile();
        if (serviceLocator == null) {
            return descriptorFile;
        }
        this.dasConfig = serviceLocator.getService(DasConfig.class, new Annotation[0]);
        if (this.dasConfig == null) {
            return descriptorFile;
        }
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        if (xmlValidationLevel.equals("none")) {
            descriptorFile.setXMLValidation(false);
        } else {
            descriptorFile.setXMLValidation(true);
        }
        descriptorFile.setXMLValidationLevel(xmlValidationLevel);
        return descriptorFile;
    }

    private void checkServerRestrictedPermissions() {
        if (this.declaredPermissionXml == null) {
            return;
        }
        if (this.componentType == null) {
            return;
        }
        GlobalPolicyUtil.checkRestrictionOfComponentType(this.declaredPermissionXml, this.componentType);
    }
}

