/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.glassfish.web.admin.cli.CreateHttp;
import org.glassfish.web.admin.cli.CreateProtocol;
import org.glassfish.web.admin.cli.CreateTransport;
import org.glassfish.web.admin.cli.DeleteNetworkListener;
import org.glassfish.web.admin.cli.DeleteProtocol;
import org.glassfish.web.admin.cli.DeleteTransport;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;

@Service(name="create-http-listener")
@PerLookup
@I18n(value="create.http.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateHttpListener
implements AdminCommand {
    @Param(name="listeneraddress")
    String listenerAddress;
    @Param(name="listenerport")
    String listenerPort;
    @Param(name="listenerPortRange", alias="listenerportrange", optional=true)
    String listenerPortRange;
    @Param(name="defaultvs", optional=true)
    String defaultVS;
    @Param(name="default-virtual-server", optional=true)
    String defaultVirtualServer;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy;
    @Param(name="serverHeader", optional=true, defaultValue="true", alias="serverHeader")
    Boolean serverHeader;
    @Param(name="xframe", optional=true, defaultValue="true")
    Boolean xFrameOptions;
    @Param(name="acceptorthreads", optional=true)
    String acceptorThreads;
    @Param(name="redirectport", optional=true)
    String redirectPort;
    @Param(name="securityenabled", optional=true, defaultValue="false")
    Boolean securityEnabled;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean secure;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="http2Enabled", alias="http2enabled", optional=true, defaultValue="true")
    Boolean http2Enabled;
    @Param(name="http2MaxConcurrentStreams", alias="http2maxconcurrentstreams", optional=true)
    Integer http2MaxConcurrentStreams;
    @Param(name="http2InitialWindowSizeInBytes", alias="http2initialwindowsizeinbytes", optional=true)
    Integer http2InitialWindowSizeInBytes;
    @Param(name="http2MaxFramePayloadSizeInBytes", alias="http2maxframepayloadsizeinbytes", optional=true)
    Integer http2MaxFramePayloadSizeInBytes;
    @Param(name="http2MaxHeaderListSizeInBytes", alias="http2maxheaderlistsizeinbytes", optional=true)
    Integer http2MaxHeaderListSizeInBytes;
    @Param(name="http2StreamsHighWaterMark", alias="http2streamshighwatermark", optional=true)
    Float http2StreamsHighWaterMark;
    @Param(name="http2CleanPercentage", alias="http2cleanpercentage", optional=true)
    Float http2CleanPercentage;
    @Param(name="http2CleanFrequencyCheck", alias="http2cleanfrequencycheck", optional=true)
    Integer http2CleanFrequencyCheck;
    @Param(name="http2DisableCipherCheck", alias="http2disableciphercheck", optional=true)
    Boolean http2DisableCipherCheck;
    @Param(name="http2PushEnabled", alias="http2pushenabled", optional=true)
    Boolean http2PushEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    CommandRunner runner;
    @Inject
    Domain domain;
    private static final String DEFAULT_TRANSPORT = "tcp";
    private NetworkConfig networkConfig = null;
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.validateInputs(report)) {
            return;
        }
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.networkConfig = this.config.getNetworkConfig();
        HttpService httpService = this.config.getHttpService();
        if (!(this.verifyUniqueName(report, this.networkConfig) && this.verifyUniquePort(report, this.networkConfig) && this.verifyDefaultVirtualServer(report))) {
            return;
        }
        VirtualServer vs = httpService.getVirtualServerByName(this.defaultVirtualServer);
        boolean listener = false;
        boolean protocol = false;
        boolean transport = false;
        try {
            transport = this.createOrGetTransport(null);
            protocol = this.createProtocol(context);
            this.createHttp(context);
            ThreadPool threadPool = this.getThreadPool(this.networkConfig);
            listener = this.createNetworkListener(this.networkConfig, transport, threadPool);
            this.updateVirtualServer(vs);
        }
        catch (TransactionFailure e) {
            try {
                if (listener) {
                    this.deleteListener(context);
                }
                if (protocol) {
                    this.deleteProtocol(context);
                }
                if (transport) {
                    this.deleteTransport(context);
                }
            }
            catch (Exception e1) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, e.getMessage(), e);
                }
                throw new RuntimeException(e.getMessage());
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, e.getMessage(), e);
            }
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00004"), this.listenerId, e.getMessage()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void updateVirtualServer(VirtualServer vs) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

            public Object run(VirtualServer avs) throws PropertyVetoException {
                String DELIM = ",";
                String lss = avs.getNetworkListeners();
                boolean listenerShouldBeAdded = true;
                if (lss == null || lss.length() == 0) {
                    lss = CreateHttpListener.this.listenerId;
                } else if (!lss.contains(CreateHttpListener.this.listenerId)) {
                    if (!lss.endsWith(DELIM)) {
                        lss = lss + DELIM;
                    }
                    lss = lss + CreateHttpListener.this.listenerId;
                } else {
                    listenerShouldBeAdded = false;
                }
                if (listenerShouldBeAdded) {
                    avs.setNetworkListeners(lss);
                }
                return avs;
            }
        }, (ConfigBeanProxy)vs);
    }

    private boolean createNetworkListener(NetworkConfig networkConfig, final boolean newTransport, final ThreadPool threadPool) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners listenersParam) throws TransactionFailure {
                NetworkListener newListener = (NetworkListener)listenersParam.createChild(NetworkListener.class);
                newListener.setName(CreateHttpListener.this.listenerId);
                newListener.setAddress(CreateHttpListener.this.listenerAddress);
                newListener.setPort(CreateHttpListener.this.listenerPort);
                if (CreateHttpListener.this.listenerPortRange != null) {
                    newListener.setPortRange(CreateHttpListener.this.listenerPortRange);
                }
                newListener.setTransport(newTransport ? CreateHttpListener.this.listenerId : CreateHttpListener.DEFAULT_TRANSPORT);
                newListener.setProtocol(CreateHttpListener.this.listenerId);
                newListener.setThreadPool(threadPool.getName());
                newListener.setEnabled(CreateHttpListener.this.enabled.toString());
                listenersParam.getNetworkListener().add(newListener);
                return newListener;
            }
        }, (ConfigBeanProxy)networkConfig.getNetworkListeners());
        ((Transactions)this.services.getService(Transactions.class, new Annotation[0])).waitForDrain();
        return true;
    }

    private boolean verifyDefaultVirtualServer(ActionReport report) {
        if (this.defaultVS == null && this.defaultVirtualServer == null) {
            report.setMessage(rb.getString("AS-WEB-ADMIN-00005"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.defaultVS != null && this.defaultVirtualServer != null && !this.defaultVS.equals(this.defaultVirtualServer)) {
            report.setMessage(rb.getString("AS-WEB-ADMIN-00006"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.defaultVirtualServer == null && this.defaultVS != null) {
            this.defaultVirtualServer = this.defaultVS;
        }
        if (!this.defaultVirtualServerExists()) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00007"), this.defaultVirtualServer));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniquePort(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.listenerPort) || !listener.getAddress().trim().equals(this.listenerAddress)) continue;
            String def = "Port is already taken by another listener, choose another port.";
            String msg = MessageFormat.format(rb.getString("AS-WEB-ADMIN-00009"), this.listenerPort, this.listenerAddress);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean validateInputs(ActionReport report) {
        if (this.acceptorThreads != null && Integer.parseInt(this.acceptorThreads) < 1) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00003"), this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniqueName(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getName().equals(this.listenerId)) continue;
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00008"), this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private ThreadPool getThreadPool(NetworkConfig config) {
        List pools = ((Config)config.getParent(Config.class)).getThreadPools().getThreadPool();
        ThreadPool target = null;
        for (ThreadPool pool : pools) {
            if (!"http-thread-pool".equals(pool.getName())) continue;
            target = pool;
        }
        if (target == null && !pools.isEmpty()) {
            target = (ThreadPool)pools.get(0);
        }
        return target;
    }

    private boolean createOrGetTransport(AdminCommandContext context) throws TransactionFailure {
        boolean newTransport = false;
        for (Transport t : this.networkConfig.getTransports().getTransport()) {
            if (t.getName().equals(DEFAULT_TRANSPORT)) continue;
            newTransport = true;
        }
        if (newTransport) {
            CreateTransport command = (CreateTransport)this.runner.getCommand("create-transport", context.getActionReport(), context.getLogger());
            command.transportName = this.listenerId;
            command.acceptorThreads = this.acceptorThreads;
            command.target = this.target;
            command.execute(context);
            this.checkProgress(context);
            newTransport = true;
        }
        return newTransport;
    }

    private boolean createProtocol(AdminCommandContext context) throws TransactionFailure {
        CreateProtocol command = (CreateProtocol)this.runner.getCommand("create-protocol", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.securityEnabled = this.securityEnabled;
        command.target = this.target;
        command.execute(context);
        this.checkProgress(context);
        return true;
    }

    private boolean createHttp(AdminCommandContext context) throws TransactionFailure {
        CreateHttp command = (CreateHttp)this.runner.getCommand("create-http", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.defaultVirtualServer = this.defaultVirtualServer;
        command.xPoweredBy = this.xPoweredBy;
        command.serverHeader = this.serverHeader;
        command.xFrameOptions = this.xFrameOptions;
        command.serverName = this.serverName;
        command.target = this.target;
        command.http2Enabled = this.http2Enabled;
        command.http2MaxConcurrentStreams = this.http2MaxConcurrentStreams;
        command.http2InitialWindowSizeInBytes = this.http2InitialWindowSizeInBytes;
        command.http2MaxFramePayloadSizeInBytes = this.http2MaxFramePayloadSizeInBytes;
        command.http2MaxHeaderListSizeInBytes = this.http2MaxHeaderListSizeInBytes;
        command.http2StreamsHighWaterMark = this.http2StreamsHighWaterMark;
        command.http2CleanPercentage = this.http2CleanPercentage;
        command.http2CleanFrequencyCheck = this.http2CleanFrequencyCheck;
        command.http2DisableCipherCheck = this.http2DisableCipherCheck;
        command.http2PushEnabled = this.http2PushEnabled;
        command.execute(context);
        this.checkProgress(context);
        return true;
    }

    private void checkProgress(AdminCommandContext context) throws TransactionFailure {
        if (context.getActionReport().getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            throw new TransactionFailure(context.getActionReport().getMessage());
        }
    }

    private boolean deleteProtocol(AdminCommandContext context) {
        DeleteProtocol command = (DeleteProtocol)this.runner.getCommand("delete-protocol", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean deleteTransport(AdminCommandContext context) {
        DeleteTransport command = (DeleteTransport)this.runner.getCommand("delete-transport", context.getActionReport(), context.getLogger());
        command.transportName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean deleteListener(AdminCommandContext context) {
        DeleteNetworkListener command = (DeleteNetworkListener)this.runner.getCommand("delete-network-listener", context.getActionReport(), context.getLogger());
        command.networkListenerName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean defaultVirtualServerExists() {
        return this.defaultVirtualServer != null && this.config.getHttpService().getVirtualServerByName(this.defaultVirtualServer) != null;
    }
}

