/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-http-listener")
@PerLookup
@I18n(value="get.http.listener")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=HttpService.class, opType=RestEndpoint.OpType.GET, path="get-http-listener", description="get-http-listener")})
public class GetHttpListener
implements AdminCommand {
    private static final Logger logger = LogFacade.getLogger();
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(primary=true)
    private String listenerName;
    @Param(optional=true, shortName="v", defaultValue="false")
    private Boolean verbose;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.targetUtil.getConfig(this.target) == null) {
            report.failure(logger, MessageFormat.format(logger.getResourceBundle().getString("AS-WEB-ADMIN-00047"), this.target));
            return;
        }
        Config config = this.targetUtil.getConfig(this.target);
        List listeners = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
        Optional<NetworkListener> optionalListener = listeners.stream().filter(listener -> listener.getName().equals(this.listenerName)).findFirst();
        if (!optionalListener.isPresent()) {
            report.failure(logger, MessageFormat.format(logger.getResourceBundle().getString("AS-WEB-ADMIN-00048"), this.listenerName, this.target));
            return;
        }
        NetworkListener listener2 = optionalListener.get();
        report.appendMessage(String.format("Name: %s\n", listener2.getName()));
        report.appendMessage(String.format("Enabled: %s\n", listener2.getEnabled()));
        report.appendMessage(String.format("Port: %s\n", listener2.getPort()));
        if (listener2.getPortRange() != null) {
            report.appendMessage(String.format("Port Range: %s\n", listener2.getPortRange()));
        }
        report.appendMessage(String.format("Address: %s\n", listener2.getAddress()));
        report.appendMessage(String.format("Protocol: %s\n", listener2.getProtocol()));
        if (this.verbose.booleanValue()) {
            report.appendMessage(String.format("Transport: %s\n", listener2.getTransport()));
            report.appendMessage(String.format("Type: %s\n", listener2.getType()));
            report.appendMessage(String.format("Thread Pool: %s\n", listener2.getThreadPool()));
            report.appendMessage(String.format("JK Enabled: %s\n", listener2.getJkEnabled()));
            report.appendMessage(String.format("JK Configuration File: %s\n", listener2.getJkConfigurationFile()));
        }
        Properties properties = new Properties();
        properties.put("name", listener2.getName());
        properties.put("enabled", listener2.getEnabled());
        properties.put("port", listener2.getPort());
        if (listener2.getPortRange() != null) {
            properties.put("portRange", listener2.getPortRange());
        }
        properties.put("address", listener2.getAddress());
        properties.put("protocol", listener2.getProtocol());
        properties.put("transport", listener2.getTransport());
        properties.put("type", listener2.getType());
        properties.put("threadPool", listener2.getThreadPool());
        properties.put("jkEnabled", listener2.getJkEnabled());
        properties.put("jkConfigurationFile", listener2.getJkConfigurationFile());
        report.setExtraProperties(properties);
    }
}

