/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi;

import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigPropertyProducer {
    @ConfigProperty
    @Dependent
    public static final Object getGenericProperty(InjectionPoint ip) {
        Collection result = null;
        ConfigProperty property = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        Config config = ConfigProvider.getConfig();
        String name = property.name();
        if (name.isEmpty()) {
            Class<?> beanClass = null;
            Bean bean = ip.getBean();
            if (bean == null) {
                Member member = ip.getMember();
                beanClass = member.getDeclaringClass();
            } else {
                beanClass = bean.getBeanClass();
            }
            StringBuilder sb = new StringBuilder(beanClass.getCanonicalName());
            sb.append('.');
            sb.append(ip.getMember().getName());
            name = sb.toString();
        }
        Type type = ip.getType();
        String defaultValue = property.defaultValue();
        if (type instanceof Class) {
            result = (Collection)config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).as((Class)type).get();
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type rawType = ptype.getRawType();
            result = List.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).asList(ConfigPropertyProducer.getElementTypeFrom(ptype)) : (Set.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).asSet(ConfigPropertyProducer.getElementTypeFrom(ptype)) : (Collection)config.getValue(name, (Class)rawType));
        }
        if (result == null) {
            throw new DeploymentException("Microprofile Config Property " + property.name() + " can not be found");
        }
        return result;
    }

    private static Class<?> getElementTypeFrom(ParameterizedType collectionType) {
        Type elementType = collectionType.getActualTypeArguments()[0];
        if (!(elementType instanceof Class)) {
            throw new DeploymentException("Only config values of lists and sets of non generic types (Class types) are supported but found: " + collectionType);
        }
        return (Class)elementType;
    }
}

