/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.jaspic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.soteria.cdi.spi.CDIPerRequestInitializer;
import org.glassfish.soteria.mechanisms.BasicAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.CustomFormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.FormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.HttpMessageContextImpl;
import org.glassfish.soteria.mechanisms.jaspic.ContextAuthenticationMechanismMapping;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;

public class HttpBridgeServerAuthModule
implements ServerAuthModule {
    private static final Logger LOGGER = Logger.getLogger(HttpBridgeServerAuthModule.class.getName());
    private CallbackHandler handler;
    private final Class<?>[] supportedMessageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private final CDIPerRequestInitializer cdiPerRequestInitializer;
    private final Map<String, Class<?>> mappings = new HashMap();

    public HttpBridgeServerAuthModule(CDIPerRequestInitializer cdiPerRequestInitializer) {
        this.cdiPerRequestInitializer = cdiPerRequestInitializer;
        try {
            this.initMappings();
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    private void initMappings() throws ClassNotFoundException {
        this.mappings.put("Basic", BasicAuthenticationMechanism.class);
        this.mappings.put("Form", FormAuthenticationMechanism.class);
        this.mappings.put("CustomForm", CustomFormAuthenticationMechanism.class);
        this.mappings.put("JWT", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.microprofile.jwtauth.eesecurity.JWTAuthenticationMechanism"));
        this.mappings.put("Certificate", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.realm.mechanisms.CertificateAuthenticationMechanism"));
        this.mappings.put("Azure", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.openid.azure.AzureOpenIdAuthenticationMechanism"));
        this.mappings.put("Google", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.openid.google.GoogleOpenIdAuthenticationMechanism"));
        this.mappings.put("OAuth2", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.oauth2.OAuth2AuthenticationMechanism"));
        this.mappings.put("OIDC", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.openid.OpenIdAuthenticationMechanism"));
        this.mappings.put("TwoIdentityStore", Thread.currentThread().getContextClassLoader().loadClass("fish.payara.security.authentication.twoIdentityStore.TwoIdentityStoreAuthenticationMechanism"));
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
    }

    public Class<?>[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Class<?> mechanismClassName;
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, clientSubject);
        if (this.cdiPerRequestInitializer != null) {
            this.cdiPerRequestInitializer.init(msgContext.getRequest());
        }
        AuthenticationStatus status = AuthenticationStatus.NOT_DONE;
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        HttpServletRequest request = msgContext.getRequest();
        String mechanism = ContextAuthenticationMechanismMapping.getInstance().getMechanism(request);
        try {
            mechanismClassName = this.defineMechanismClassName(mechanism);
        }
        catch (ClassNotFoundException e) {
            throw new AuthException(e.getMessage());
        }
        try {
            HttpAuthenticationMechanism mechanismInstance = (HttpAuthenticationMechanism)CDI.current().select(mechanismClassName, new Annotation[0]).get();
            status = mechanismInstance.validateRequest(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
        }
        catch (AuthenticationException e) {
            Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), AuthenticationStatus.SEND_FAILURE);
            throw (AuthException)new AuthException("Authentication failure in HttpAuthenticationMechanism").initCause((Throwable)e);
        }
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        return Jaspic.fromAuthenticationStatus(status);
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        Class<?> mechanismClassName;
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, null);
        HttpServletRequest request = msgContext.getRequest();
        String mechanism = ContextAuthenticationMechanismMapping.getInstance().getMechanism(request);
        try {
            mechanismClassName = this.defineMechanismClassName(mechanism);
        }
        catch (ClassNotFoundException e) {
            throw new AuthException(e.getMessage());
        }
        try {
            HttpAuthenticationMechanism mechanismInstance = (HttpAuthenticationMechanism)CDI.current().select(mechanismClassName, new Annotation[0]).get();
            AuthenticationStatus status = mechanismInstance.secureResponse(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
            AuthStatus authStatus = Jaspic.fromAuthenticationStatus(status);
            if (authStatus == AuthStatus.SUCCESS) {
                AuthStatus authStatus2 = AuthStatus.SEND_SUCCESS;
                return authStatus2;
            }
            AuthStatus authStatus3 = authStatus;
            return authStatus3;
        }
        catch (AuthenticationException e) {
            throw (AuthException)new AuthException("Secure response failure in HttpAuthenticationMechanism").initCause((Throwable)e);
        }
        finally {
            if (this.cdiPerRequestInitializer != null) {
                this.cdiPerRequestInitializer.destroy(msgContext.getRequest());
            }
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, subject);
        ((HttpAuthenticationMechanism)CDI.current().select(HttpAuthenticationMechanism.class, new Annotation[0]).get()).cleanSubject(msgContext.getRequest(), msgContext.getResponse(), (HttpMessageContext)msgContext);
    }

    private Class<?> defineMechanismClassName(String mechanism) throws ClassNotFoundException {
        Class<Object> result = this.mappings.get(mechanism);
        if (result == null) {
            if (mechanism != null) {
                result = Thread.currentThread().getContextClassLoader().loadClass(mechanism);
                if (!HttpAuthenticationMechanism.class.isAssignableFrom(result)) {
                    throw new IllegalArgumentException("The value for the 'fish.payara.security.mechanism' context parameter doesn't contain a reference to a HttpAuthenticationMechanism implementation.");
                }
                this.mappings.put(mechanism, result);
            } else {
                result = HttpAuthenticationMechanism.class;
            }
        }
        return result;
    }
}

