/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl.impl;

import com.sun.enterprise.security.ssl.impl.MasterPasswordImpl;
import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.manager.UnifiedX509TrustManager;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.embedded.Server;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecuritySupportImpl
extends SecuritySupport {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.security.ssl.LogMessages";
    @LoggerInfo(subsystem="SECURITY - SSL", description="Security - SSL", publish=true)
    public static final String SEC_SSL_LOGGER = "javax.enterprise.system.security.ssl";
    protected static final Logger _logger = Logger.getLogger("javax.enterprise.system.security.ssl", "com.sun.enterprise.security.ssl.LogMessages");
    @LogMessageInfo(message="The SSL certificate has expired: {0}", level="WARNING", cause="Certificate expired.", action="Check the expiration date of the certificate.")
    private static final String SSL_CERT_EXPIRED = "NCLS-SECURITY-05054";
    private static final String DEFAULT_KEYSTORE_PASS = "changeit";
    private static final String DEFAULT_TRUSTSTORE_PASS = "changeit";
    private static final Map<String, List<KeyStore>> keyStores = new ConcurrentHashMap<String, List<KeyStore>>();
    private static final Map<String, List<KeyStore>> trustStores = new ConcurrentHashMap<String, List<KeyStore>>();
    private static final Map<String, List<char[]>> keyStorePasswords = new ConcurrentHashMap<String, List<char[]>>();
    private static final Map<String, List<String>> tokenNames = new ConcurrentHashMap<String, List<String>>();
    private static final String DEFAULT_MAP_KEY = "key";
    private static boolean instantiated;
    private static boolean initialized;
    private Date initDate = new Date();
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    @Optional
    private ServerEnvironment serverEnvironment;
    private MasterPasswordImpl masterPasswordHelper;

    public SecuritySupportImpl() {
        this(true);
    }

    protected SecuritySupportImpl(boolean init) {
        if (init) {
            this.initJKS();
        }
    }

    @Override
    public KeyStore[] getKeyStores() {
        List<KeyStore> keyStoresList = keyStores.get(DEFAULT_MAP_KEY);
        return keyStoresList.toArray(new KeyStore[keyStoresList.size()]);
    }

    @Override
    public KeyStore[] getTrustStores() {
        List<KeyStore> trustStoresList = trustStores.get(DEFAULT_MAP_KEY);
        return trustStoresList.toArray(new KeyStore[trustStoresList.size()]);
    }

    @Override
    public String[] getTokenNames() {
        List<String> tokenNamesList = tokenNames.get(DEFAULT_MAP_KEY);
        return tokenNamesList.toArray(new String[tokenNamesList.size()]);
    }

    @Override
    public KeyStore getKeyStore(String token) {
        int tokenIndex = this.getTokenIndex(token);
        if (tokenIndex < 0) {
            return null;
        }
        return keyStores.get(DEFAULT_MAP_KEY).get(tokenIndex);
    }

    @Override
    public KeyStore getTrustStore(String token) {
        int tokenIndex = this.getTokenIndex(token);
        if (tokenIndex < 0) {
            return null;
        }
        return trustStores.get(DEFAULT_MAP_KEY).get(tokenIndex);
    }

    @Override
    public void reset() {
        char[] keyStorePass;
        char[] trustStorePass = keyStorePass = this.masterPasswordHelper.getMasterPassword();
        this.initStores(keyStorePass, trustStorePass);
    }

    @Override
    public KeyStore loadNullStore(String type, int index) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(null, keyStorePasswords.get(DEFAULT_MAP_KEY).get(index));
        return keyStore;
    }

    @Override
    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore[] keyStores = this.getKeyStores();
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < keyStores.length; ++i) {
            this.checkCertificateDates(keyStores[i]);
            KeyManager[] keyManagersPerStore = this.getKeyManagerFactory(keyStores[i], keyStorePasswords.get(DEFAULT_MAP_KEY).get(i), algorithm).getKeyManagers();
            if (keyManagersPerStore == null) continue;
            keyManagers.addAll(Arrays.asList(keyManagersPerStore));
        }
        UnifiedX509KeyManager keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), this.getTokenNames());
        return new KeyManager[]{keyManager};
    }

    @Override
    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (KeyStore trustStore : this.getTrustStores()) {
            this.checkCertificateDates(trustStore);
            TrustManager[] trustManagersPerStore = this.getTrustManagerFactory(trustStore, algorithm).getTrustManagers();
            if (trustManagersPerStore == null) continue;
            trustManagers.addAll(Arrays.asList(trustManagersPerStore));
        }
        TrustManager trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
        return new TrustManager[]{trustManager};
    }

    @Override
    public boolean verifyMasterPassword(char[] masterPass) {
        return Arrays.equals(masterPass, keyStorePasswords.get(DEFAULT_MAP_KEY).get(0));
    }

    @Override
    public void synchronizeKeyFile(Object configContext, String fileRealmName) throws Exception {
    }

    @Override
    public PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.checkPermission("javax.net.ssl.keyStorePassword");
        Key key = keyStores.get(DEFAULT_MAP_KEY).get(keystoreIndex).getKey(alias, keyStorePasswords.get(DEFAULT_MAP_KEY).get(keystoreIndex));
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    @Override
    public void checkPermission(String key) {
        try {
            if (this.isEmbeddedServer() || this.serviceLocator == null || this.isACC() || this.isNotServerORACC()) {
                return;
            }
            AccessController.checkPermission(new RuntimePermission("SSLPassword"));
        }
        catch (AccessControlException e) {
            PropertyPermission permission = new PropertyPermission(key, "read");
            String message = e.getMessage();
            if (message != null) {
                message = message.replace(e.getPermission().toString(), permission.toString());
            }
            throw new AccessControlException(message, permission);
        }
    }

    private int getTokenIndex(String token) {
        int tokenIndex = -1;
        if (token != null && (tokenIndex = tokenNames.get(DEFAULT_MAP_KEY).indexOf(token)) < 0 && _logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "token {0} is not found", token);
        }
        return tokenIndex;
    }

    public boolean isACC() {
        return this.processEnvironment == null ? false : this.processEnvironment.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isNotServerORACC() {
        return this.processEnvironment.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    private void initJKS() {
        char[] keyStorePass = null;
        char[] trustStorePass = null;
        if (!SecuritySupportImpl.isInstantiated()) {
            if (this.serviceLocator == null) {
                this.serviceLocator = Globals.getDefaultHabitat();
            }
            if (this.masterPasswordHelper == null && this.serviceLocator != null) {
                this.masterPasswordHelper = (MasterPasswordImpl)this.serviceLocator.getService(MasterPasswordImpl.class, new Annotation[0]);
            }
            if (this.masterPasswordHelper != null) {
                trustStorePass = keyStorePass = this.masterPasswordHelper.getMasterPassword();
            }
        }
        if (this.processEnvironment == null && this.serviceLocator != null) {
            this.processEnvironment = (ProcessEnvironment)this.serviceLocator.getService(ProcessEnvironment.class, new Annotation[0]);
        }
        if (this.serverEnvironment == null && this.serviceLocator != null) {
            this.serverEnvironment = (ServerEnvironment)this.serviceLocator.getService(ServerEnvironment.class, new Annotation[0]);
        }
        if (!initialized) {
            this.initStores(keyStorePass, trustStorePass);
            initialized = true;
        }
    }

    private void initStores(char[] keyStorePassIn, char[] trustStorePassIn) {
        String keyStoreFileName = System.getProperty("javax.net.ssl.keyStore");
        String trustStoreFileName = System.getProperty("javax.net.ssl.trustStore");
        char[] keyStorePass = keyStorePassIn;
        char[] trustStorePass = trustStorePassIn;
        if (this.shouldGetPassFromProperty(keyStorePass)) {
            keyStorePass = this.getKeyStorePass(keyStorePass);
            trustStorePass = this.getTrustStorePass(trustStorePass);
        }
        SecuritySupportImpl.initStores(keyStoreFileName, keyStorePass, trustStoreFileName, trustStorePass);
    }

    private static void initStores(String keyStoreFileName, char[] keyStorePass, String trustStoreFileName, char[] trustStorePass) {
        try {
            ArrayList<KeyStore> keyStoresList = new ArrayList<KeyStore>();
            ArrayList<KeyStore> trustStoresList = new ArrayList<KeyStore>();
            ArrayList<char[]> keyStorePasswordsList = new ArrayList<char[]>();
            ArrayList<Object> tokenNamesList = new ArrayList<Object>();
            keyStoresList.add(SecuritySupportImpl.loadStore(System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()), null, keyStoreFileName, keyStorePass));
            trustStoresList.add(SecuritySupportImpl.loadStore(System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()), null, trustStoreFileName, trustStorePass));
            keyStorePasswordsList.add(Arrays.copyOf(keyStorePass, keyStorePass.length));
            tokenNamesList.add(null);
            keyStores.put(DEFAULT_MAP_KEY, keyStoresList);
            trustStores.put(DEFAULT_MAP_KEY, trustStoresList);
            keyStorePasswords.put(DEFAULT_MAP_KEY, keyStorePasswordsList);
            tokenNames.put(DEFAULT_MAP_KEY, tokenNamesList);
        }
        catch (Exception ex) {
            _logger.severe("Failed to load key stores " + ex.getMessage());
            throw new IllegalStateException(ex);
        }
        finally {
            Arrays.fill(keyStorePass, ' ');
            Arrays.fill(trustStorePass, ' ');
        }
    }

    protected static synchronized void loadStores(String tokenName, Provider provider, String keyStoreFile, char[] keyStorePass, String keyStoreType, String trustStoreFile, char[] trustStorePass, String trustStoreType) {
        try {
            keyStores.get(DEFAULT_MAP_KEY).add(SecuritySupportImpl.loadStore(keyStoreType, provider, keyStoreFile, keyStorePass));
            trustStores.get(DEFAULT_MAP_KEY).add(SecuritySupportImpl.loadStore(trustStoreType, provider, trustStoreFile, trustStorePass));
            keyStorePasswords.get(DEFAULT_MAP_KEY).add(Arrays.copyOf(keyStorePass, keyStorePass.length));
            tokenNames.get(DEFAULT_MAP_KEY).add(tokenName);
        }
        catch (Exception ex) {
            _logger.severe("Failed to load key stores " + ex.getMessage());
            throw new IllegalStateException(ex);
        }
    }

    private static KeyStore loadStore(String keyStoreType, Provider provider, String keyStoreFile, char[] keyStorePass) throws Exception {
        KeyStore keyStore = null;
        keyStore = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        if (keyStoreFile != null) {
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(keyStoreFile));){
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = {0}, keystorePass = {1}", new Object[]{keyStoreFile, keyStorePass});
                }
                keyStore.load(stream, keyStorePass);
            }
        } else {
            keyStore.load(null, keyStorePass);
        }
        return keyStore;
    }

    private boolean isEmbeddedServer() {
        return !Server.getServerNames().isEmpty();
    }

    private boolean shouldGetPassFromProperty(char[] keyStorePass) {
        return keyStorePass == null || this.isACC() || this.serverEnvironment != null && this.serverEnvironment.isMicro();
    }

    private char[] getKeyStorePass(char[] keyStorePass) {
        String keyStorePassOverride = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
        if (keyStorePassOverride == null) {
            return keyStorePass;
        }
        return keyStorePassOverride.toCharArray();
    }

    private char[] getTrustStorePass(char[] trustStorePass) {
        String trustStorePassOverride = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
        if (trustStorePassOverride == null) {
            return trustStorePass;
        }
        return trustStorePassOverride.toCharArray();
    }

    private static synchronized boolean isInstantiated() {
        if (!instantiated) {
            instantiated = true;
            return false;
        }
        return true;
    }

    private void checkCertificateDates(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate = keyStore.getCertificate(aliases.nextElement());
            if (!(certificate instanceof X509Certificate) || !((X509Certificate)certificate).getNotAfter().before(this.initDate)) continue;
            _logger.log(Level.WARNING, SSL_CERT_EXPIRED, certificate);
        }
    }

    private TrustManagerFactory getTrustManagerFactory(KeyStore trustStore, String algorithm) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm != null ? algorithm : TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    private KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, char[] keyStorePassword, String algorithm) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm != null ? algorithm : KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        return keyManagerFactory;
    }
}

