/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.connector;

import com.sun.enterprise.config.serverbeans.Config;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.inject.Scope;
import javax.interceptor.Interceptor;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.weld.connector.CDIService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WeldUtils {
    public static final char SEPARATOR_CHAR = '/';
    public static final String WEB_INF = "WEB-INF";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String BEANS_XML_FILENAME = "beans.xml";
    public static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_CLASSES_META_INF_BEANS_XML = "WEB-INF/classes/META-INF/beans.xml";
    private static final String SERVICES_DIR = "services";
    private static final String SERVICES_CLASSNAME = "javax.enterprise.inject.spi.Extension";
    public static final String META_INF_SERVICES_EXTENSION = "META-INF/services/javax.enterprise.inject.spi.Extension";
    public static final String CLASS_SUFFIX = ".class";
    public static final String JAR_SUFFIX = ".jar";
    public static final String RAR_SUFFIX = ".rar";
    public static final String EXPANDED_RAR_SUFFIX = "_rar";
    public static final String EXPANDED_JAR_SUFFIX = "_jar";
    protected static final List<String> cdiScopeAnnotations = new ArrayList<String>();
    protected static final List<String> cdiEnablingAnnotations;
    protected static final List<String> excludedAnnotationTypes;

    public static boolean isImplicitBeanArchive(DeploymentContext context, ReadableArchive archive) throws IOException {
        boolean result = false;
        if (archive != null && !archive.exists(META_INF_SERVICES_EXTENSION)) {
            result = WeldUtils.isImplicitBeanArchive(context, archive.getURI());
        }
        return result;
    }

    public static boolean isImplicitBeanArchive(DeploymentContext context, URI archivePath) {
        return WeldUtils.isImplicitBeanDiscoveryEnabled(context) && WeldUtils.hasCDIEnablingAnnotations(context, archivePath);
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, URI path) {
        HashSet<URI> paths = new HashSet<URI>();
        paths.add(path);
        return WeldUtils.hasCDIEnablingAnnotations(context, paths);
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, Collection<URI> paths) {
        ArrayList<String> result = new ArrayList<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(at) || !type.wasDefinedIn(paths) || result.contains(at.getName())) continue;
                    result.add(at.getName());
                }
            }
        }
        return !result.isEmpty();
    }

    public static String[] getCDIEnablingAnnotations(DeploymentContext context) {
        ArrayList<String> result = new ArrayList<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(at) || result.contains(at.getName())) continue;
                    result.add(at.getName());
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Collection<String> getCDIAnnotatedClassNames(DeploymentContext context) {
        HashSet<String> result = new HashSet<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(at) || result.contains(at.getName())) continue;
                    result.add(type.getName());
                }
            }
        }
        return result;
    }

    public static boolean hasScopeAnnotation(Class clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiScopeAnnotations, null);
    }

    public static boolean hasCDIEnablingAnnotation(Class clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiEnablingAnnotations, null);
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType) {
        return WeldUtils.isCDIEnablingAnnotation(annotationType, null);
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType, Set<String> excludedTypeNames) {
        String annotationTypeName;
        boolean result = false;
        HashSet<String> exclusions = new HashSet<String>();
        if (excludedTypeNames != null) {
            exclusions.addAll(excludedTypeNames);
        }
        if (cdiEnablingAnnotations.contains(annotationTypeName = annotationType.getName()) && !exclusions.contains(annotationTypeName)) {
            result = true;
        } else if (!exclusions.contains(annotationTypeName)) {
            exclusions.add(annotationTypeName);
            for (AnnotationModel parent : annotationType.getAnnotations()) {
                if (!WeldUtils.isCDIEnablingAnnotation(parent.getType(), exclusions)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean hasValidAnnotation(Class annotatedClass, Collection<String> validScopes, Collection<String> excludedScopes) {
        boolean result = false;
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            if (!WeldUtils.isValidAnnotation(annotation.annotationType(), validScopes, excludedScopes)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected static boolean isValidAnnotation(Class<? extends Annotation> annotationType, Collection<String> validTypeNames, Collection<String> excludedTypeNames) {
        boolean result = false;
        if (validTypeNames != null && !validTypeNames.isEmpty()) {
            String annotationTypeName;
            HashSet<String> excludedScopes = new HashSet<String>();
            if (excludedTypeNames != null) {
                excludedScopes.addAll(excludedTypeNames);
            }
            if (validTypeNames.contains(annotationTypeName = annotationType.getName()) && !excludedScopes.contains(annotationTypeName)) {
                result = true;
            } else if (!excludedScopes.contains(annotationTypeName)) {
                excludedScopes.add(annotationTypeName);
                for (Annotation parent : annotationType.getAnnotations()) {
                    if (!WeldUtils.isValidAnnotation(parent.annotationType(), validTypeNames, excludedScopes)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private static Types getTypes(DeploymentContext context) {
        String metadataKey = Types.class.getName();
        Types types = (Types)context.getTransientAppMetadata().get(metadataKey);
        while (types == null && (context = ((ExtendedDeploymentContext)context).getParentContext()) != null) {
            types = (Types)context.getTransientAppMetadata().get(metadataKey);
        }
        return types;
    }

    public static int getPreLoaderThreads() {
        Config config;
        int result = 0;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Integer.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getPreLoaderThreadPoolSize());
        }
        return result;
    }

    public static boolean isConcurrentDeploymentEnabled() {
        Config config;
        boolean result = false;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Boolean.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getEnableConcurrentDeployment());
        }
        return result;
    }

    public static boolean isImplicitBeanDiscoveryEnabled() {
        Config config;
        boolean result = false;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Boolean.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getEnableImplicitCdi());
        }
        return result;
    }

    public static boolean isImplicitBeanDiscoveryEnabled(DeploymentContext context) {
        boolean result = false;
        if (WeldUtils.isImplicitBeanDiscoveryEnabled()) {
            Object propValue = context.getAppProps().get("implicitCdiEnabled");
            Object appPropValue = context.getAppProps().get("enable-implicit-cdi");
            if (appPropValue != null) {
                propValue = appPropValue;
            }
            result = propValue == null || Boolean.parseBoolean((String)propValue);
        }
        return result;
    }

    public static boolean isCDIDevModeEnabled(DeploymentContext context) {
        Object propValue = context.getAppProps().get("cdiDevModeEnabled");
        return propValue != null && Boolean.parseBoolean((String)propValue);
    }

    public static void setCDIDevMode(DeploymentContext context, boolean enabled) {
        context.getAppProps().setProperty("cdiDevModeEnabled", String.valueOf(enabled));
    }

    public static InputStream getBeansXmlInputStream(DeploymentContext context) {
        return WeldUtils.getBeansXmlInputStream(context.getSource());
    }

    public static boolean isValidBdaBasedOnExtensionAndBeansXml(ReadableArchive archive) {
        boolean retVal = true;
        try {
            if (archive.exists(META_INF_SERVICES_EXTENSION)) {
                retVal = false;
                InputStream inputStream = WeldUtils.getBeansXmlInputStream(archive);
                if (inputStream != null) {
                    retVal = true;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retVal;
    }

    public static InputStream getBeansXmlInputStream(ReadableArchive archive) {
        InputStream inputStream = null;
        try {
            if (archive.exists(WEB_INF)) {
                inputStream = archive.getEntry(WEB_INF_BEANS_XML);
                if (inputStream == null) {
                    inputStream = archive.getEntry(WEB_INF_CLASSES_META_INF_BEANS_XML);
                }
            } else {
                inputStream = archive.getEntry(META_INF_BEANS_XML);
            }
        }
        catch (IOException e) {
            return null;
        }
        return inputStream;
    }

    public static String getBeanDiscoveryMode(InputStream beansXmlInputStream) {
        if (beansXmlInputStream == null) {
            return "annotated";
        }
        String beanDiscoveryMode = null;
        LocalDefaultHandler handler = new LocalDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(beansXmlInputStream, (DefaultHandler)handler);
        }
        catch (SAXStoppedIntentionallyException exc) {
            beanDiscoveryMode = handler.getBeanDiscoveryMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanDiscoveryMode == null) {
            return "all";
        }
        if (beanDiscoveryMode.equals("")) {
            return "annotated";
        }
        return beanDiscoveryMode;
    }

    static {
        cdiScopeAnnotations.add(Scope.class.getName());
        cdiScopeAnnotations.add(NormalScope.class.getName());
        cdiScopeAnnotations.add("javax.faces.view.ViewScoped");
        cdiScopeAnnotations.add("javax.faces.flow.FlowScoped");
        cdiScopeAnnotations.add(ConversationScoped.class.getName());
        cdiScopeAnnotations.add(ApplicationScoped.class.getName());
        cdiScopeAnnotations.add(SessionScoped.class.getName());
        cdiScopeAnnotations.add(RequestScoped.class.getName());
        cdiScopeAnnotations.add(Dependent.class.getName());
        cdiScopeAnnotations.add(javax.inject.Singleton.class.getName());
        cdiScopeAnnotations.add(Model.class.getName());
        cdiEnablingAnnotations = new ArrayList<String>();
        cdiEnablingAnnotations.addAll(cdiScopeAnnotations);
        cdiEnablingAnnotations.add(Decorator.class.getName());
        cdiEnablingAnnotations.add(Interceptor.class.getName());
        cdiEnablingAnnotations.add(Stereotype.class.getName());
        cdiEnablingAnnotations.add(MessageDriven.class.getName());
        cdiEnablingAnnotations.add(Stateful.class.getName());
        cdiEnablingAnnotations.add(Stateless.class.getName());
        cdiEnablingAnnotations.add(Singleton.class.getName());
        excludedAnnotationTypes = new ArrayList<String>();
        excludedAnnotationTypes.add(Documented.class.getName());
        excludedAnnotationTypes.add(Retention.class.getName());
        excludedAnnotationTypes.add(Target.class.getName());
    }

    private static class SAXStoppedIntentionallyException
    extends SAXException {
        private SAXStoppedIntentionallyException() {
        }
    }

    private static class LocalDefaultHandler
    extends DefaultHandler {
        String beanDiscoveryMode = null;

        private LocalDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("beans")) {
                this.beanDiscoveryMode = attributes.getValue("bean-discovery-mode");
                if (this.beanDiscoveryMode != null && this.beanDiscoveryMode.equals("")) {
                    this.beanDiscoveryMode = "annotated";
                }
                throw new SAXStoppedIntentionallyException();
            }
        }

        public String getBeanDiscoveryMode() {
            return this.beanDiscoveryMode;
        }
    }

    public static enum BDAType {
        WAR,
        JAR,
        RAR,
        UNKNOWN;

    }
}

