/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.ContextProviderImpl;
import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.jacc.ContextProvider;
import fish.payara.jacc.JaccConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.security.Policy;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={PolicyConfigurationFactoryImpl.class, PolicyConfigurationFactory.class})
public class PolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory
implements JaccConfigurationFactory {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PolicyConfigurationFactoryImpl.class);
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    private Map<String, String> applicationToPolicyContextIdMap = new ConcurrentHashMap<String, String>();
    private Map<String, ContextProvider> contextToContextProviderMap = new ConcurrentHashMap<String, ContextProvider>();
    private Map<String, PolicyConfigurationImpl> contextToConfigurationMap = new ConcurrentHashMap<String, PolicyConfigurationImpl>();
    private Map<String, Set<String>> linkTable = new HashMap<String, Set<String>>();
    private String repository = this.initializeRepository();
    private Permission setPolicyPermission;
    private static PolicyConfigurationFactoryImpl singleton;

    public PolicyConfigurationFactoryImpl() {
        singleton = this;
    }

    public void registerContextProvider(String applicationContextId, PolicyConfigurationFactory factory, Policy policy) {
        this.checkSetPolicyPermission();
        try {
            String policyContextId = this.applicationToPolicyContextIdMap.get(applicationContextId);
            if (policyContextId == null) {
                throw new IllegalStateException("No policyContextId available for applicationContextId " + applicationContextId + " Is this JaccConfigurationFactory instance used by the container?");
            }
            if (this.inService(policyContextId)) {
                throw new IllegalStateException("Context :" + policyContextId + " already has an active global provider");
            }
            ContextProvider contextProvider = this.contextToContextProviderMap.get(policyContextId);
            if (contextProvider != null && contextProvider.getPolicyConfigurationFactory().inService(policyContextId)) {
                throw new IllegalStateException("Context :" + policyContextId + " already has an active context (per app) provider");
            }
            this.contextToContextProviderMap.put(policyContextId, new ContextProviderImpl(factory, policy));
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addContextIdMapping(String applicationContextId, String policyContextId) {
        this.applicationToPolicyContextIdMap.put(applicationContextId, policyContextId);
    }

    public boolean removeContextIdMappingByPolicyContextId(String policyContextId) {
        return this.applicationToPolicyContextIdMap.entrySet().removeIf(e -> ((String)e.getValue()).equals(policyContextId));
    }

    public ContextProvider getContextProviderByPolicyContextId(String contextId) {
        return this.contextToContextProviderMap.get(contextId);
    }

    public ContextProvider removeContextProviderByPolicyContextId(String policyContextId) {
        return this.contextToContextProviderMap.remove(policyContextId);
    }

    @Override
    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        ContextProvider contextProvider;
        this.checkSetPolicyPermission();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Getting PolicyConfiguration object with id = " + contextId);
        }
        if ((contextProvider = this.contextToContextProviderMap.get(contextId)) != null) {
            return contextProvider.getPolicyConfigurationFactory().getPolicyConfiguration(contextId, remove);
        }
        return this.getPolicyConfigurationImpl(contextId, true, remove);
    }

    @Override
    public boolean inService(String contextId) throws PolicyContextException {
        this.checkSetPolicyPermission();
        ContextProvider contextProvider = this.contextToContextProviderMap.get(contextId);
        if (contextProvider != null) {
            return contextProvider.getPolicyConfigurationFactory().inService(contextId);
        }
        PolicyConfigurationImpl policyConfiguration = this.getPolicyConfigurationImpl(contextId);
        return policyConfiguration == null ? false : policyConfiguration.inService();
    }

    static PolicyConfigurationFactoryImpl getInstance() {
        return singleton;
    }

    private String initializeRepository() {
        try {
            this.repository = System.getProperty(REPOSITORY_HOME_PROP);
            if (this.repository == null) {
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.no_repository", "no repository"));
            } else {
                File repositoryDirectory;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC policy provider: repository set to: " + this.repository);
                }
                if ((repositoryDirectory = new File(this.repository)).exists()) {
                    if (!repositoryDirectory.isDirectory()) {
                        logger.log(Level.SEVERE, localStrings.getLocalString("pc.unable_to_create_repository", "unable to create repository" + this.repository, new Object[]{this.repository}));
                    } else {
                        File[] appsInService = repositoryDirectory.listFiles();
                        if (appsInService != null) {
                            for (int i = 0; i < appsInService.length; ++i) {
                                File[] contextsInService = appsInService[i].listFiles(pathName -> pathName.isDirectory());
                                if (contextsInService == null) continue;
                                for (int j = 0; j < contextsInService.length; ++j) {
                                    try {
                                        PolicyConfigurationImpl pc = new PolicyConfigurationImpl(contextsInService[j], false, false, this);
                                        this.contextToConfigurationMap.put(pc.CONTEXT_ID, pc);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        logger.log(Level.WARNING, localStrings.getLocalString("pc.unable_to_read_repostory", "unable to read repository", new Object[]{contextsInService[i].toString()}), ex);
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JACC Policy Provider: creating new policy repository");
                    }
                    if (!repositoryDirectory.mkdirs()) {
                        throw new IOException();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, localStrings.getLocalString("pc.unable_to_init_repository", "unable to init repository", new Object[]{e}));
            this.repository = null;
        }
        return this.repository;
    }

    String getRepository() {
        return this.repository;
    }

    String getContextDirectoryName(String contextId) {
        if (this.repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return this.repository + File.separator + contextId;
    }

    protected PolicyConfigurationImpl getPolicyConfigurationImpl(String contextId) {
        return this.getPolicyConfigurationImpl(contextId, false, false);
    }

    protected PolicyConfigurationImpl getPolicyConfigurationImpl(String contextId, boolean open, boolean remove) {
        PolicyConfigurationImpl policyConfiguration = this.contextToConfigurationMap.get(contextId);
        if (policyConfiguration != null) {
            if (open) {
                policyConfiguration.initialize(true, remove, false);
            }
        } else {
            policyConfiguration = this.getPolicyConfigurationImplFromDirectory(contextId, open, remove);
            if (policyConfiguration == null && open) {
                policyConfiguration = new PolicyConfigurationImpl(contextId, this);
                this.contextToConfigurationMap.put(contextId, policyConfiguration);
            }
        }
        return policyConfiguration;
    }

    private PolicyConfigurationImpl getPolicyConfigurationImplFromDirectory(String contextId, boolean open, boolean remove) {
        PolicyConfigurationImpl policyConfigurationImpl = null;
        File contextDirectory = new File(this.getContextDirectoryName(contextId));
        if (contextDirectory.exists()) {
            policyConfigurationImpl = new PolicyConfigurationImpl(contextDirectory, open, remove, this);
            this.contextToConfigurationMap.put(contextId, policyConfigurationImpl);
        }
        return policyConfigurationImpl;
    }

    protected List<PolicyConfigurationImpl> getPolicyConfigurationImpls() {
        return new ArrayList<PolicyConfigurationImpl>(this.contextToConfigurationMap.values());
    }

    protected PolicyConfigurationImpl removePolicyConfigurationImpl(String contextID) {
        return this.contextToConfigurationMap.remove(contextID);
    }

    protected void checkSetPolicyPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.setPolicyPermission == null) {
                this.setPolicyPermission = new SecurityPermission("setPolicy");
            }
            securityManager.checkPermission(this.setPolicyPermission);
        }
    }

    Map<String, Set<String>> getLinkTable() {
        return this.linkTable;
    }
}

