/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.spi.MemberAddressProvider;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.grizzly.utils.Holder;

public class MemberAddressPicker
implements MemberAddressProvider {
    private static final Logger logger = Logger.getLogger(MemberAddressPicker.class.getName());
    private final ServerEnvironment env;
    private final HazelcastRuntimeConfiguration config;
    private final HazelcastConfigSpecificConfiguration localConfig;
    private final InetSocketAddress bindAddress;
    private final InetSocketAddress publicAddress;
    private final Holder.LazyHolder<InetAddress> chosenAddress = Holder.LazyHolder.lazyHolder(MemberAddressPicker::findMyAddress);

    MemberAddressPicker(ServerEnvironment env, HazelcastRuntimeConfiguration config, HazelcastConfigSpecificConfiguration localConfig) {
        this.env = env;
        this.config = config;
        this.localConfig = localConfig;
        this.bindAddress = this.initBindAddress();
        this.publicAddress = this.initPublicAddress(this.bindAddress);
    }

    public InetSocketAddress getBindAddress(EndpointQualifier endpointQualifier) {
        return this.getBindAddress();
    }

    public InetSocketAddress getPublicAddress(EndpointQualifier endpointQualifier) {
        return this.getPublicAddress();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public InetSocketAddress getPublicAddress() {
        return this.publicAddress;
    }

    private InetSocketAddress initBindAddress() {
        InetSocketAddress address = new InetSocketAddress(0);
        if (this.env.isDas() && !this.env.isMicro() && !this.config.getDASBindAddress().isEmpty()) {
            int port = new Integer(this.config.getDasPort());
            address = MemberAddressPicker.initAddress(this.config.getDASBindAddress(), port);
            logger.log(Level.FINE, "Bind address is specified in the configuration so we will use that {0}", address);
        } else if (this.config.getDiscoveryMode().startsWith("multicast")) {
            address = MemberAddressPicker.ensureAddress(null, null, this.chosenAddress, 0);
        } else {
            logger.log(Level.FINE, "Using Wildcard bind address");
        }
        return address;
    }

    private InetSocketAddress initPublicAddress(InetSocketAddress bindAddress) {
        InetSocketAddress address;
        logger.fine("Finding an appropriate address for Hazelcast to use");
        int port = 0;
        if (this.env.isDas() && !this.env.isMicro()) {
            port = new Integer(this.config.getDasPort());
            address = MemberAddressPicker.initAddress(this.config.getDASPublicAddress(), port);
        } else {
            address = MemberAddressPicker.initAddress(this.localConfig.getPublicAddress(), Integer.parseInt(this.config.getStartPort()));
        }
        return MemberAddressPicker.ensureAddress(address, bindAddress, this.chosenAddress, port);
    }

    static InetSocketAddress initAddress(String address, int port) {
        if (address != null && !address.isEmpty()) {
            String[] addressParts = address.split(":");
            if (addressParts.length > 1) {
                return new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1]));
            }
            return new InetSocketAddress(addressParts[0], port);
        }
        return null;
    }

    static InetAddress findMyAddressOrLocalHost() {
        InetAddress myAddress = MemberAddressPicker.findMyAddress();
        if (myAddress == null) {
            return MemberAddressPicker.tryLocalHostOrLoopback(0, true).getAddress();
        }
        return myAddress;
    }

    private static InetSocketAddress ensureAddress(InetSocketAddress targetAddress, InetSocketAddress sourceAddress, Holder.LazyHolder<InetAddress> backupAddress, int port) {
        if (targetAddress == null) {
            targetAddress = sourceAddress != null && !sourceAddress.getAddress().isAnyLocalAddress() ? sourceAddress : (backupAddress.get() != null ? new InetSocketAddress((InetAddress)backupAddress.get(), port) : MemberAddressPicker.tryLocalHostOrLoopback(port, false));
        }
        return targetAddress;
    }

    private static InetSocketAddress tryLocalHostOrLoopback(int port, boolean warn) {
        try {
            logger.log(warn ? Level.WARNING : Level.FINE, "Could not find an appropriate address, falling back to local host");
            return new InetSocketAddress(InetAddress.getLocalHost(), port);
        }
        catch (UnknownHostException ex) {
            logger.log(warn ? Level.WARNING : Level.FINE, "Could not find local host, falling back to loop back address");
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
        }
    }

    private static InetAddress findMyAddress() {
        NetworkInterface intf;
        HashSet<NetworkInterface> possibleInterfaces = new HashSet<NetworkInterface>();
        try {
            logger.fine("No address in configuration so let's find one");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                intf = interfaces.nextElement();
                logger.log(Level.FINE, "Found Network Interface {0}", new Object[]{intf.getName()});
                if (!(!intf.isUp() || intf.isLoopback() || intf.isVirtual() || intf.isPointToPoint() || intf.getName().contains("docker0") || intf.getDisplayName().contains("Teredo") || intf.getInterfaceAddresses().size() <= 0)) {
                    logger.log(Level.FINE, "Adding interface {0} as a possible interface", intf.getName());
                    possibleInterfaces.add(intf);
                    continue;
                }
                logger.log(Level.FINE, "Ignoring down, docker, p2p or loopback interface {0}", intf.getName());
            }
        }
        catch (SocketException socketException) {
            logger.log(Level.WARNING, "There was a problem determining the network interfaces on this machine", socketException);
        }
        InetAddress chosenAddress = null;
        if (!possibleInterfaces.isEmpty()) {
            intf = (NetworkInterface)possibleInterfaces.iterator().next();
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses.hasMoreElements() && !((chosenAddress = addresses.nextElement()) instanceof Inet4Address)) {
            }
            logger.log(Level.FINE, "Picked address {0}", chosenAddress);
        }
        return chosenAddress;
    }
}

