/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.jaspic.services.AuthConfigRegistrationWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ClientPipeCloser {
    private static final ClientPipeCloser INSTANCE = new ClientPipeCloser();
    private Map<ServiceReferenceDescriptor, AuthConfigRegistrationWrapper> svcRefListenerMap = Collections.synchronizedMap(new WeakHashMap());

    private ClientPipeCloser() {
    }

    public static ClientPipeCloser getInstance() {
        return INSTANCE;
    }

    public void registerListenerWrapper(ServiceReferenceDescriptor desc, AuthConfigRegistrationWrapper wrapper) {
        this.svcRefListenerMap.put(desc, wrapper);
    }

    public AuthConfigRegistrationWrapper lookupListenerWrapper(ServiceReferenceDescriptor desc) {
        return this.svcRefListenerMap.get(desc);
    }

    public void removeListenerWrapper(AuthConfigRegistrationWrapper wrapper) {
        ServiceReferenceDescriptor entryToRemove = null;
        for (Map.Entry<ServiceReferenceDescriptor, AuthConfigRegistrationWrapper> entry : this.svcRefListenerMap.entrySet()) {
            ServiceReferenceDescriptor svc = entry.getKey();
            AuthConfigRegistrationWrapper wrp = entry.getValue();
            if (wrp != wrapper) continue;
            entryToRemove = svc;
            break;
        }
        if (entryToRemove != null) {
            this.svcRefListenerMap.remove(entryToRemove);
        }
    }

    public void cleanupClientPipe(ServiceReferenceDescriptor desc) {
        AuthConfigRegistrationWrapper listenerWrapper = this.svcRefListenerMap.get(desc);
        if (listenerWrapper != null) {
            listenerWrapper.disable();
        }
        this.svcRefListenerMap.remove(desc);
    }
}

